/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BaseSitePage;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.models.List;
import com.microsoft.graph.models.ListItem;
import com.microsoft.graph.models.RecycleBin;
import com.microsoft.graph.models.RecycleBinItem;
import com.microsoft.graph.models.SharedDriveItem;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.SitePage;
import com.microsoft.graph.models.User;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BaseItem
extends Entity
implements Parsable {
    @Nonnull
    public static BaseItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.baseSitePage": {
                    return new BaseSitePage();
                }
                case "#microsoft.graph.drive": {
                    return new Drive();
                }
                case "#microsoft.graph.driveItem": {
                    return new DriveItem();
                }
                case "#microsoft.graph.list": {
                    return new List();
                }
                case "#microsoft.graph.listItem": {
                    return new ListItem();
                }
                case "#microsoft.graph.recycleBin": {
                    return new RecycleBin();
                }
                case "#microsoft.graph.recycleBinItem": {
                    return new RecycleBinItem();
                }
                case "#microsoft.graph.sharedDriveItem": {
                    return new SharedDriveItem();
                }
                case "#microsoft.graph.site": {
                    return new Site();
                }
                case "#microsoft.graph.sitePage": {
                    return new SitePage();
                }
            }
        }
        return new BaseItem();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public User getCreatedByUser() {
        return (User)this.backingStore.get("createdByUser");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getETag() {
        return (String)this.backingStore.get("eTag");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdByUser", n -> this.setCreatedByUser((User)n.getObjectValue(User::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("eTag", n -> this.setETag(n.getStringValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedByUser", n -> this.setLastModifiedByUser((User)n.getObjectValue(User::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("parentReference", n -> this.setParentReference((ItemReference)n.getObjectValue(ItemReference::createFromDiscriminatorValue)));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public User getLastModifiedByUser() {
        return (User)this.backingStore.get("lastModifiedByUser");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public ItemReference getParentReference() {
        return (ItemReference)this.backingStore.get("parentReference");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeObjectValue("createdByUser", (Parsable)this.getCreatedByUser(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("eTag", this.getETag());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeObjectValue("lastModifiedByUser", (Parsable)this.getLastModifiedByUser(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("name", this.getName());
        writer.writeObjectValue("parentReference", (Parsable)this.getParentReference(), new Parsable[0]);
        writer.writeStringValue("webUrl", this.getWebUrl());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedByUser(@Nullable User value) {
        this.backingStore.set("createdByUser", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setETag(@Nullable String value) {
        this.backingStore.set("eTag", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedByUser(@Nullable User value) {
        this.backingStore.set("lastModifiedByUser", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setParentReference(@Nullable ItemReference value) {
        this.backingStore.set("parentReference", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

