/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.LocaleInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AutomaticRepliesMailTips
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AutomaticRepliesMailTips() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AutomaticRepliesMailTips createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AutomaticRepliesMailTips();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("message", n -> this.setMessage(n.getStringValue()));
        deserializerMap.put("messageLanguage", n -> this.setMessageLanguage((LocaleInfo)n.getObjectValue(LocaleInfo::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("scheduledEndTime", n -> this.setScheduledEndTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("scheduledStartTime", n -> this.setScheduledStartTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getMessage() {
        return (String)this.backingStore.get("message");
    }

    @Nullable
    public LocaleInfo getMessageLanguage() {
        return (LocaleInfo)this.backingStore.get("messageLanguage");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public DateTimeTimeZone getScheduledEndTime() {
        return (DateTimeTimeZone)this.backingStore.get("scheduledEndTime");
    }

    @Nullable
    public DateTimeTimeZone getScheduledStartTime() {
        return (DateTimeTimeZone)this.backingStore.get("scheduledStartTime");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("message", this.getMessage());
        writer.writeObjectValue("messageLanguage", (Parsable)this.getMessageLanguage(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("scheduledEndTime", (Parsable)this.getScheduledEndTime(), new Parsable[0]);
        writer.writeObjectValue("scheduledStartTime", (Parsable)this.getScheduledStartTime(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setMessage(@Nullable String value) {
        this.backingStore.set("message", (Object)value);
    }

    public void setMessageLanguage(@Nullable LocaleInfo value) {
        this.backingStore.set("messageLanguage", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setScheduledEndTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("scheduledEndTime", (Object)value);
    }

    public void setScheduledStartTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("scheduledStartTime", (Object)value);
    }
}

