/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AppliedConditionalAccessPolicyResult;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AppliedConditionalAccessPolicy
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AppliedConditionalAccessPolicy() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AppliedConditionalAccessPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AppliedConditionalAccessPolicy();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public List<String> getEnforcedGrantControls() {
        return (List)this.backingStore.get("enforcedGrantControls");
    }

    @Nullable
    public List<String> getEnforcedSessionControls() {
        return (List)this.backingStore.get("enforcedSessionControls");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("enforcedGrantControls", n -> this.setEnforcedGrantControls(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("enforcedSessionControls", n -> this.setEnforcedSessionControls(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("id", n -> this.setId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("result", n -> this.setResult((AppliedConditionalAccessPolicyResult)n.getEnumValue(AppliedConditionalAccessPolicyResult::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getId() {
        return (String)this.backingStore.get("id");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public AppliedConditionalAccessPolicyResult getResult() {
        return (AppliedConditionalAccessPolicyResult)((Object)this.backingStore.get("result"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfPrimitiveValues("enforcedGrantControls", this.getEnforcedGrantControls());
        writer.writeCollectionOfPrimitiveValues("enforcedSessionControls", this.getEnforcedSessionControls());
        writer.writeStringValue("id", this.getId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("result", (Enum)this.getResult());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEnforcedGrantControls(@Nullable List<String> value) {
        this.backingStore.set("enforcedGrantControls", value);
    }

    public void setEnforcedSessionControls(@Nullable List<String> value) {
        this.backingStore.set("enforcedSessionControls", value);
    }

    public void setId(@Nullable String value) {
        this.backingStore.set("id", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setResult(@Nullable AppliedConditionalAccessPolicyResult value) {
        this.backingStore.set("result", (Object)value);
    }
}

