/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackageQuestion;
import com.microsoft.graph.models.EntitlementManagementSchedule;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageAssignmentRequestRequirements
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AccessPackageAssignmentRequestRequirements() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AccessPackageAssignmentRequestRequirements createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AccessPackageAssignmentRequestRequirements();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowCustomAssignmentSchedule() {
        return (Boolean)this.backingStore.get("allowCustomAssignmentSchedule");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("allowCustomAssignmentSchedule", n -> this.setAllowCustomAssignmentSchedule(n.getBooleanValue()));
        deserializerMap.put("isApprovalRequiredForAdd", n -> this.setIsApprovalRequiredForAdd(n.getBooleanValue()));
        deserializerMap.put("isApprovalRequiredForUpdate", n -> this.setIsApprovalRequiredForUpdate(n.getBooleanValue()));
        deserializerMap.put("isRequestorJustificationRequired", n -> this.setIsRequestorJustificationRequired(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("policyDescription", n -> this.setPolicyDescription(n.getStringValue()));
        deserializerMap.put("policyDisplayName", n -> this.setPolicyDisplayName(n.getStringValue()));
        deserializerMap.put("policyId", n -> this.setPolicyId(n.getStringValue()));
        deserializerMap.put("questions", n -> this.setQuestions(n.getCollectionOfObjectValues(AccessPackageQuestion::createFromDiscriminatorValue)));
        deserializerMap.put("schedule", n -> this.setSchedule((EntitlementManagementSchedule)n.getObjectValue(EntitlementManagementSchedule::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsApprovalRequiredForAdd() {
        return (Boolean)this.backingStore.get("isApprovalRequiredForAdd");
    }

    @Nullable
    public Boolean getIsApprovalRequiredForUpdate() {
        return (Boolean)this.backingStore.get("isApprovalRequiredForUpdate");
    }

    @Nullable
    public Boolean getIsRequestorJustificationRequired() {
        return (Boolean)this.backingStore.get("isRequestorJustificationRequired");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPolicyDescription() {
        return (String)this.backingStore.get("policyDescription");
    }

    @Nullable
    public String getPolicyDisplayName() {
        return (String)this.backingStore.get("policyDisplayName");
    }

    @Nullable
    public String getPolicyId() {
        return (String)this.backingStore.get("policyId");
    }

    @Nullable
    public List<AccessPackageQuestion> getQuestions() {
        return (List)this.backingStore.get("questions");
    }

    @Nullable
    public EntitlementManagementSchedule getSchedule() {
        return (EntitlementManagementSchedule)this.backingStore.get("schedule");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowCustomAssignmentSchedule", this.getAllowCustomAssignmentSchedule());
        writer.writeBooleanValue("isApprovalRequiredForAdd", this.getIsApprovalRequiredForAdd());
        writer.writeBooleanValue("isApprovalRequiredForUpdate", this.getIsApprovalRequiredForUpdate());
        writer.writeBooleanValue("isRequestorJustificationRequired", this.getIsRequestorJustificationRequired());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("policyDescription", this.getPolicyDescription());
        writer.writeStringValue("policyDisplayName", this.getPolicyDisplayName());
        writer.writeStringValue("policyId", this.getPolicyId());
        writer.writeCollectionOfObjectValues("questions", this.getQuestions());
        writer.writeObjectValue("schedule", (Parsable)this.getSchedule(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowCustomAssignmentSchedule(@Nullable Boolean value) {
        this.backingStore.set("allowCustomAssignmentSchedule", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsApprovalRequiredForAdd(@Nullable Boolean value) {
        this.backingStore.set("isApprovalRequiredForAdd", (Object)value);
    }

    public void setIsApprovalRequiredForUpdate(@Nullable Boolean value) {
        this.backingStore.set("isApprovalRequiredForUpdate", (Object)value);
    }

    public void setIsRequestorJustificationRequired(@Nullable Boolean value) {
        this.backingStore.set("isRequestorJustificationRequired", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPolicyDescription(@Nullable String value) {
        this.backingStore.set("policyDescription", (Object)value);
    }

    public void setPolicyDisplayName(@Nullable String value) {
        this.backingStore.set("policyDisplayName", (Object)value);
    }

    public void setPolicyId(@Nullable String value) {
        this.backingStore.set("policyId", (Object)value);
    }

    public void setQuestions(@Nullable List<AccessPackageQuestion> value) {
        this.backingStore.set("questions", value);
    }

    public void setSchedule(@Nullable EntitlementManagementSchedule value) {
        this.backingStore.set("schedule", (Object)value);
    }
}

