/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.groups.item.sites.item.onenote;

import com.microsoft.graph.groups.item.sites.item.onenote.notebooks.NotebooksRequestBuilder;
import com.microsoft.graph.groups.item.sites.item.onenote.operations.OperationsRequestBuilder;
import com.microsoft.graph.groups.item.sites.item.onenote.pages.PagesRequestBuilder;
import com.microsoft.graph.groups.item.sites.item.onenote.resources.ResourcesRequestBuilder;
import com.microsoft.graph.groups.item.sites.item.onenote.sectiongroups.SectionGroupsRequestBuilder;
import com.microsoft.graph.groups.item.sites.item.onenote.sections.SectionsRequestBuilder;
import com.microsoft.graph.models.Onenote;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OnenoteRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public NotebooksRequestBuilder notebooks() {
        return new NotebooksRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PagesRequestBuilder pages() {
        return new PagesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ResourcesRequestBuilder resources() {
        return new ResourcesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SectionGroupsRequestBuilder sectionGroups() {
        return new SectionGroupsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SectionsRequestBuilder sections() {
        return new SectionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public OnenoteRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{group%2Did}/sites/{site%2Did}/onenote{?%24expand,%24select}", pathParameters);
    }

    public OnenoteRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{group%2Did}/sites/{site%2Did}/onenote{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public Onenote get() {
        return this.get(null);
    }

    @Nullable
    public Onenote get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Onenote)this.requestAdapter.send(requestInfo, errorMapping, Onenote::createFromDiscriminatorValue);
    }

    @Nullable
    public Onenote patch(@Nonnull Onenote body) {
        return this.patch(body, null);
    }

    @Nullable
    public Onenote patch(@Nonnull Onenote body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Onenote)this.requestAdapter.send(requestInfo, errorMapping, Onenote::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Onenote body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Onenote body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public OnenoteRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new OnenoteRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

