/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class BlockIterator
implements SequenceIterator {
    private Expression[] children;
    private int i = 0;
    private SequenceIterator child;
    private XPathContext context;
    private int position = 0;

    public BlockIterator(Expression[] children, XPathContext context) {
        this.children = children;
        this.context = context;
    }

    public Item next() throws XPathException {
        if (this.position < 0) {
            return null;
        }
        do {
            Item current;
            if (this.child == null) {
                this.child = this.children[this.i++].iterate(this.context);
            }
            if ((current = this.child.next()) != null) {
                ++this.position;
                return current;
            }
            this.child = null;
        } while (this.i < this.children.length);
        this.position = -1;
        return null;
    }

    public void close() {
        if (this.child != null) {
            this.child.close();
        }
    }

    public BlockIterator getAnother() throws XPathException {
        return new BlockIterator(this.children, this.context);
    }

    public int getProperties() {
        return 0;
    }
}

