/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;

public class ModelSnapshot
implements ToXContentObject,
Writeable {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField SNAPSHOT_DOC_COUNT = new ParseField("snapshot_doc_count", new String[0]);
    public static final ParseField LATEST_RECORD_TIME = new ParseField("latest_record_time_stamp", new String[0]);
    public static final ParseField LATEST_RESULT_TIME = new ParseField("latest_result_time_stamp", new String[0]);
    public static final ParseField QUANTILES = new ParseField("quantiles", new String[0]);
    public static final ParseField RETAIN = new ParseField("retain", new String[0]);
    public static final ParseField MIN_VERSION = new ParseField("min_version", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("model_snapshots", new String[0]);
    public static final ParseField TYPE = new ParseField("model_snapshot", new String[0]);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = ModelSnapshot.createParser(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = ModelSnapshot.createParser(true);
    public static String EMPTY_SNAPSHOT_ID = "empty";
    private final String jobId;
    private final MlConfigVersion minVersion;
    private final Date timestamp;
    private final String description;
    private final String snapshotId;
    private final int snapshotDocCount;
    private final ModelSizeStats modelSizeStats;
    private final Date latestRecordTimeStamp;
    private final Date latestResultTimeStamp;
    private final Quantiles quantiles;
    private final boolean retain;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(TYPE.getPreferredName(), ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setJobId, Job.ID);
        parser.declareString(Builder::setMinVersion, MIN_VERSION);
        parser.declareField(Builder::setTimestamp, p -> TimeUtils.parseTimeField(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareString(Builder::setDescription, DESCRIPTION);
        parser.declareString(Builder::setSnapshotId, ModelSnapshotField.SNAPSHOT_ID);
        parser.declareInt(Builder::setSnapshotDocCount, SNAPSHOT_DOC_COUNT);
        parser.declareObject(Builder::setModelSizeStats, ignoreUnknownFields ? ModelSizeStats.LENIENT_PARSER : ModelSizeStats.STRICT_PARSER, ModelSizeStats.RESULT_TYPE_FIELD);
        parser.declareField(Builder::setLatestRecordTimeStamp, p -> TimeUtils.parseTimeField(p, LATEST_RECORD_TIME.getPreferredName()), LATEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setLatestResultTimeStamp, p -> TimeUtils.parseTimeField(p, LATEST_RESULT_TIME.getPreferredName()), LATEST_RESULT_TIME, ObjectParser.ValueType.VALUE);
        parser.declareObject(Builder::setQuantiles, ignoreUnknownFields ? Quantiles.LENIENT_PARSER : Quantiles.STRICT_PARSER, QUANTILES);
        parser.declareBoolean(Builder::setRetain, RETAIN);
        return parser;
    }

    private ModelSnapshot(String jobId, MlConfigVersion minVersion, Date timestamp, String description, String snapshotId, int snapshotDocCount, ModelSizeStats modelSizeStats, Date latestRecordTimeStamp, Date latestResultTimeStamp, Quantiles quantiles, boolean retain) {
        this.jobId = jobId;
        this.minVersion = minVersion;
        this.timestamp = timestamp;
        this.description = description;
        this.snapshotId = snapshotId;
        this.snapshotDocCount = snapshotDocCount;
        this.modelSizeStats = modelSizeStats;
        this.latestRecordTimeStamp = latestRecordTimeStamp;
        this.latestResultTimeStamp = latestResultTimeStamp;
        this.quantiles = quantiles;
        this.retain = retain;
    }

    public ModelSnapshot(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.minVersion = MlConfigVersion.readVersion(in);
        this.timestamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.description = in.readOptionalString();
        this.snapshotId = in.readOptionalString();
        this.snapshotDocCount = in.readInt();
        this.modelSizeStats = in.readOptionalWriteable(ModelSizeStats::new);
        this.latestRecordTimeStamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.latestResultTimeStamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.quantiles = in.readOptionalWriteable(Quantiles::new);
        this.retain = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        MlConfigVersion.writeVersion(this.minVersion, out);
        if (this.timestamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.timestamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.snapshotId);
        out.writeInt(this.snapshotDocCount);
        out.writeOptionalWriteable(this.modelSizeStats);
        if (this.latestRecordTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestRecordTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.latestResultTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestResultTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable(this.quantiles);
        out.writeBoolean(this.retain);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(MIN_VERSION.getPreferredName(), this.minVersion);
        if (this.timestamp != null) {
            builder.timestampFieldsFromUnixEpochMillis(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.snapshotId != null) {
            builder.field(ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        }
        builder.field(SNAPSHOT_DOC_COUNT.getPreferredName(), this.snapshotDocCount);
        if (this.modelSizeStats != null) {
            builder.field(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName(), this.modelSizeStats);
        }
        if (this.latestRecordTimeStamp != null) {
            builder.timestampFieldsFromUnixEpochMillis(LATEST_RECORD_TIME.getPreferredName(), LATEST_RECORD_TIME.getPreferredName() + "_string", this.latestRecordTimeStamp.getTime());
        }
        if (this.latestResultTimeStamp != null) {
            builder.timestampFieldsFromUnixEpochMillis(LATEST_RESULT_TIME.getPreferredName(), LATEST_RESULT_TIME.getPreferredName() + "_string", this.latestResultTimeStamp.getTime());
        }
        if (this.quantiles != null) {
            builder.field(QUANTILES.getPreferredName(), this.quantiles);
        }
        builder.field(RETAIN.getPreferredName(), this.retain);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public MlConfigVersion getMinVersion() {
        return this.minVersion;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public int getSnapshotDocCount() {
        return this.snapshotDocCount;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public Date getLatestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public Date getLatestResultTimeStamp() {
        return this.latestResultTimeStamp;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.minVersion, this.timestamp, this.description, this.snapshotId, this.quantiles, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.retain);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelSnapshot)) {
            return false;
        }
        ModelSnapshot that = (ModelSnapshot)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.minVersion, that.minVersion) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.description, that.description) && Objects.equals(this.snapshotId, that.snapshotId) && this.snapshotDocCount == that.snapshotDocCount && Objects.equals(this.modelSizeStats, that.modelSizeStats) && Objects.equals(this.quantiles, that.quantiles) && Objects.equals(this.latestRecordTimeStamp, that.latestRecordTimeStamp) && Objects.equals(this.latestResultTimeStamp, that.latestResultTimeStamp) && this.retain == that.retain;
    }

    public List<String> stateDocumentIds() {
        ArrayList<String> stateDocumentIds = new ArrayList<String>(this.snapshotDocCount);
        for (int i = 1; i <= this.snapshotDocCount; ++i) {
            stateDocumentIds.add(ModelState.documentId(this.jobId, this.snapshotId, i));
        }
        return stateDocumentIds;
    }

    public boolean isTheEmptySnapshot() {
        return ModelSnapshot.isTheEmptySnapshot(this.snapshotId);
    }

    public static boolean isTheEmptySnapshot(String snapshotId) {
        return EMPTY_SNAPSHOT_ID.equals(snapshotId);
    }

    public static String documentIdPrefix(String jobId) {
        return jobId + "_" + String.valueOf(TYPE) + "_";
    }

    public static String annotationDocumentId(ModelSnapshot snapshot) {
        return "annotation_for_" + ModelSnapshot.documentId(snapshot);
    }

    public static String documentId(ModelSnapshot snapshot) {
        return ModelSnapshot.documentId(snapshot.getJobId(), snapshot.getSnapshotId());
    }

    public static String v54DocumentId(ModelSnapshot snapshot) {
        return ModelSnapshot.v54DocumentId(snapshot.getJobId(), snapshot.getSnapshotId());
    }

    public static String documentId(String jobId, String snapshotId) {
        return ModelSnapshot.documentIdPrefix(jobId) + snapshotId;
    }

    public static String v54DocumentId(String jobId, String snapshotId) {
        return jobId + "-" + snapshotId;
    }

    public static ModelSnapshot fromJson(BytesReference bytesReference) {
        ModelSnapshot modelSnapshot;
        block8: {
            XContentParser parser = XContentHelper.createParserNotCompressed(LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, bytesReference, XContentType.JSON);
            try {
                modelSnapshot = LENIENT_PARSER.apply(parser, null).build();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse modelSnapshot", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return modelSnapshot;
    }

    public static ModelSnapshot emptySnapshot(String jobId) {
        return new ModelSnapshot(jobId, MlConfigVersion.CURRENT, new Date(), "empty snapshot", EMPTY_SNAPSHOT_ID, 0, new ModelSizeStats.Builder(jobId).build(), null, null, null, false);
    }

    public static class Builder {
        private String jobId;
        private MlConfigVersion minVersion = MlConfigVersion.fromString("6.3.0");
        private Date timestamp;
        private String description;
        private String snapshotId;
        private int snapshotDocCount;
        private ModelSizeStats modelSizeStats;
        private Date latestRecordTimeStamp;
        private Date latestResultTimeStamp;
        private Quantiles quantiles;
        private boolean retain;

        public Builder() {
        }

        public Builder(String jobId) {
            this();
            this.jobId = jobId;
        }

        public Builder(ModelSnapshot modelSnapshot) {
            this.jobId = modelSnapshot.jobId;
            this.timestamp = modelSnapshot.timestamp;
            this.description = modelSnapshot.description;
            this.snapshotId = modelSnapshot.snapshotId;
            this.snapshotDocCount = modelSnapshot.snapshotDocCount;
            this.modelSizeStats = modelSnapshot.modelSizeStats;
            this.latestRecordTimeStamp = modelSnapshot.latestRecordTimeStamp;
            this.latestResultTimeStamp = modelSnapshot.latestResultTimeStamp;
            this.quantiles = modelSnapshot.quantiles;
            this.retain = modelSnapshot.retain;
            this.minVersion = modelSnapshot.minVersion;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setMinVersion(MlConfigVersion minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public Builder setMinVersion(String minVersion) {
            this.minVersion = MlConfigVersion.fromString(minVersion);
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setSnapshotDocCount(int snapshotDocCount) {
            this.snapshotDocCount = snapshotDocCount;
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats.Builder modelSizeStats) {
            this.modelSizeStats = modelSizeStats.build();
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats modelSizeStats) {
            this.modelSizeStats = modelSizeStats;
            return this;
        }

        public Builder setLatestRecordTimeStamp(Date latestRecordTimeStamp) {
            this.latestRecordTimeStamp = latestRecordTimeStamp;
            return this;
        }

        public Builder setLatestResultTimeStamp(Date latestResultTimeStamp) {
            this.latestResultTimeStamp = latestResultTimeStamp;
            return this;
        }

        public Builder setQuantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public Builder setRetain(boolean value) {
            this.retain = value;
            return this;
        }

        public ModelSnapshot build() {
            return new ModelSnapshot(this.jobId, this.minVersion, this.timestamp, this.description, this.snapshotId, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.quantiles, this.retain);
        }
    }
}

