/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.fielddata.AbstractSortingNumericDocValues;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.elasticsearch.index.fielddata.SortingNumericDoubleValues;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.values.ScriptBytesValues;
import org.elasticsearch.search.aggregations.support.values.ScriptDoubleValues;
import org.elasticsearch.search.aggregations.support.values.ScriptLongValues;

public abstract class ValuesSource {
    public abstract SortedBinaryDocValues bytesValues(LeafReaderContext var1) throws IOException;

    public abstract DocValueBits docsWithValue(LeafReaderContext var1) throws IOException;

    public boolean needsScores() {
        return false;
    }

    protected abstract Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext var1) throws IOException;

    public boolean hasOrdinals() {
        return false;
    }

    public static abstract class GeoPoint
    extends ValuesSource {
        public static final GeoPoint EMPTY = new GeoPoint(){

            @Override
            public SortedNumericDocValues geoSortedNumericDocValues(LeafReaderContext context) {
                return DocValues.emptySortedNumeric();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return FieldData.emptySortedBinary();
            }
        };

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            MultiGeoPointValues geoPoints = this.geoPointValues(context);
            return FieldData.docsWithValue(geoPoints);
        }

        @Override
        public final Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
            throw AggregationErrors.unsupportedRounding("GEO_POINT");
        }

        public final MultiGeoPointValues geoPointValues(LeafReaderContext context) {
            return new MultiGeoPointValues(this.geoSortedNumericDocValues(context));
        }

        public abstract SortedNumericDocValues geoSortedNumericDocValues(LeafReaderContext var1);

        public static class Fielddata
        extends GeoPoint {
            protected final IndexGeoPointFieldData indexFieldData;

            public Fielddata(IndexGeoPointFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafPointFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public SortedNumericDocValues geoSortedNumericDocValues(LeafReaderContext context) {
                return ((LeafPointFieldData)this.indexFieldData.load(context)).getSortedNumericDocValues();
            }
        }
    }

    public static class Range
    extends ValuesSource {
        private final RangeType rangeType;
        protected final IndexFieldData<?> indexFieldData;

        public Range(IndexFieldData<?> indexFieldData, RangeType rangeType) {
            this.indexFieldData = indexFieldData;
            this.rangeType = rangeType;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return this.indexFieldData.load(context).getBytesValues();
        }

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            SortedBinaryDocValues bytes = this.bytesValues(context);
            return FieldData.docsWithValue(bytes);
        }

        @Override
        public Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
            return Rounding::prepareForUnknown;
        }

        public RangeType rangeType() {
            return this.rangeType;
        }
    }

    public static abstract class Numeric
    extends ValuesSource {
        public static final Numeric EMPTY = new Numeric(){

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) {
                return DocValues.emptySortedNumeric();
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return org.elasticsearch.index.fielddata.FieldData.emptySortedNumericDoubles();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return org.elasticsearch.index.fielddata.FieldData.emptySortedBinary();
            }
        };

        public abstract boolean isFloatingPoint();

        public abstract SortedNumericDocValues longValues(LeafReaderContext var1) throws IOException;

        public abstract SortedNumericDoubleValues doubleValues(LeafReaderContext var1) throws IOException;

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            if (this.isFloatingPoint()) {
                SortedNumericDoubleValues values = this.doubleValues(context);
                return org.elasticsearch.index.fielddata.FieldData.docsWithValue(values);
            }
            SortedNumericDocValues values = this.longValues(context);
            return org.elasticsearch.index.fielddata.FieldData.docsWithValue(values);
        }

        @Override
        public Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
            return Rounding::prepareForUnknown;
        }

        public static class Script
        extends Numeric {
            private final AggregationScript.LeafFactory script;
            private final ValueType scriptValueType;

            public Script(AggregationScript.LeafFactory script, ValueType scriptValueType) {
                this.script = script;
                this.scriptValueType = scriptValueType;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.scriptValueType != null ? this.scriptValueType == ValueType.DOUBLE : true;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                return new ScriptLongValues(this.script.newInstance(context));
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return new ScriptDoubleValues(this.script.newInstance(context));
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new ScriptBytesValues(this.script.newInstance(context));
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }
        }

        public static class FieldData
        extends Numeric {
            protected final IndexNumericFieldData indexFieldData;

            public FieldData(IndexNumericFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.indexFieldData.getNumericType().isFloatingPoint();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafNumericFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) {
                return ((LeafNumericFieldData)this.indexFieldData.load(context)).getLongValues();
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) {
                return ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
            }
        }

        public static class WithScript
        extends Numeric {
            private final Numeric delegate;
            private final AggregationScript.LeafFactory script;

            public WithScript(Numeric delegate, AggregationScript.LeafFactory script) {
                this.delegate = delegate;
                this.script = script;
            }

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new Bytes.WithScript.BytesValues(this.delegate.bytesValues(context), this.script.newInstance(context));
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                return new LongValues(this.delegate.longValues(context), this.script.newInstance(context));
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return new DoubleValues(this.delegate.doubleValues(context), this.script.newInstance(context));
            }

            static class LongValues
            extends AbstractSortingNumericDocValues
            implements ScorerAware {
                private final SortedNumericDocValues longValues;
                private final AggregationScript script;

                LongValues(SortedNumericDocValues values, AggregationScript script) {
                    this.longValues = values;
                    this.script = script;
                }

                @Override
                public void setScorer(Scorable scorer) {
                    this.script.setScorer(scorer);
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    if (this.longValues.advanceExact(target)) {
                        this.resize(this.longValues.docValueCount());
                        this.script.setDocument(target);
                        for (int i = 0; i < this.docValueCount(); ++i) {
                            this.script.setNextAggregationValue(this.longValues.nextValue());
                            this.values[i] = this.script.runAsLong();
                        }
                        this.sort();
                        return true;
                    }
                    return false;
                }
            }

            static class DoubleValues
            extends SortingNumericDoubleValues
            implements ScorerAware {
                private final SortedNumericDoubleValues doubleValues;
                private final AggregationScript script;

                DoubleValues(SortedNumericDoubleValues values, AggregationScript script) {
                    this.doubleValues = values;
                    this.script = script;
                }

                @Override
                public void setScorer(Scorable scorer) {
                    this.script.setScorer(scorer);
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    if (this.doubleValues.advanceExact(target)) {
                        this.resize(this.doubleValues.docValueCount());
                        this.script.setDocument(target);
                        for (int i = 0; i < this.docValueCount(); ++i) {
                            this.script.setNextAggregationValue(this.doubleValues.nextValue());
                            this.values[i] = this.script.runAsDouble();
                        }
                        this.sort();
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    public static abstract class Bytes
    extends ValuesSource {
        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            SortedBinaryDocValues bytes = this.bytesValues(context);
            return org.elasticsearch.index.fielddata.FieldData.docsWithValue(bytes);
        }

        @Override
        public final Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
            throw AggregationErrors.unsupportedRounding("BYTES");
        }

        public static class WithScript
        extends Bytes {
            private final ValuesSource delegate;
            private final AggregationScript.LeafFactory script;

            public WithScript(ValuesSource delegate, AggregationScript.LeafFactory script) {
                this.delegate = delegate;
                this.script = script;
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new BytesValues(this.delegate.bytesValues(context), this.script.newInstance(context));
            }

            static class BytesValues
            extends SortingBinaryDocValues
            implements ScorerAware {
                private final SortedBinaryDocValues bytesValues;
                private final AggregationScript script;

                BytesValues(SortedBinaryDocValues bytesValues, AggregationScript script) {
                    this.bytesValues = bytesValues;
                    this.script = script;
                }

                @Override
                public void setScorer(Scorable scorer) {
                    this.script.setScorer(scorer);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    if (this.bytesValues.advanceExact(doc)) {
                        this.count = this.bytesValues.docValueCount();
                        this.grow();
                        this.script.setDocument(doc);
                        for (int i = 0; i < this.count; ++i) {
                            BytesRef value = this.bytesValues.nextValue();
                            this.script.setNextAggregationValue(value.utf8ToString());
                            Object run = this.script.execute();
                            CollectionUtils.ensureNoSelfReferences(run, "ValuesSource.BytesValues script");
                            this.values[i].copyChars(run.toString());
                        }
                        this.sort();
                        return true;
                    }
                    this.count = 0;
                    this.grow();
                    return false;
                }
            }
        }

        public static class Script
        extends Bytes {
            private final AggregationScript.LeafFactory script;

            public Script(AggregationScript.LeafFactory script) {
                this.script = script;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new ScriptBytesValues(this.script.newInstance(context));
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }
        }

        public static class FieldData
        extends Bytes {
            protected final IndexFieldData<?> indexFieldData;

            public FieldData(IndexFieldData<?> indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return this.indexFieldData.load(context).getBytesValues();
            }
        }

        public static abstract class WithOrdinals
        extends Bytes {
            public static final WithOrdinals EMPTY = new WithOrdinals(){

                @Override
                public SortedSetDocValues ordinalsValues(LeafReaderContext context) {
                    return DocValues.emptySortedSet();
                }

                @Override
                public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) {
                    return DocValues.emptySortedSet();
                }

                @Override
                public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                    return org.elasticsearch.index.fielddata.FieldData.emptySortedBinary();
                }

                @Override
                public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                    return LongUnaryOperator.identity();
                }

                @Override
                public boolean supportsGlobalOrdinalsMapping() {
                    return true;
                }
            };

            @Override
            public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
                SortedSetDocValues ordinals = this.ordinalsValues(context);
                return org.elasticsearch.index.fielddata.FieldData.docsWithValue(ordinals);
            }

            public abstract SortedSetDocValues ordinalsValues(LeafReaderContext var1) throws IOException;

            public abstract SortedSetDocValues globalOrdinalsValues(LeafReaderContext var1) throws IOException;

            public abstract boolean supportsGlobalOrdinalsMapping();

            @Override
            public boolean hasOrdinals() {
                return true;
            }

            public abstract LongUnaryOperator globalOrdinalsMapping(LeafReaderContext var1) throws IOException;

            public long globalMaxOrd(IndexReader indexReader) throws IOException {
                if (indexReader.leaves().isEmpty()) {
                    return 0L;
                }
                LeafReaderContext atomicReaderContext = indexReader.leaves().get(0);
                SortedSetDocValues values = this.globalOrdinalsValues(atomicReaderContext);
                return values.getValueCount();
            }

            public static class FieldData
            extends WithOrdinals {
                protected final IndexOrdinalsFieldData indexFieldData;

                public FieldData(IndexOrdinalsFieldData indexFieldData) {
                    this.indexFieldData = indexFieldData;
                }

                @Override
                public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                    LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)this.indexFieldData.load(context);
                    return atomicFieldData.getBytesValues();
                }

                @Override
                public SortedSetDocValues ordinalsValues(LeafReaderContext context) {
                    LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)this.indexFieldData.load(context);
                    return atomicFieldData.getOrdinalsValues();
                }

                @Override
                public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) {
                    IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                    LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)global.load(context);
                    return atomicFieldData.getOrdinalsValues();
                }

                @Override
                public boolean supportsGlobalOrdinalsMapping() {
                    return this.indexFieldData.supportsGlobalOrdinalsMapping();
                }

                @Override
                public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                    IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                    OrdinalMap map = global.getOrdinalMap();
                    if (map == null) {
                        return LongUnaryOperator.identity();
                    }
                    LongValues segmentToGlobalOrd = map.getGlobalOrds(context.ord);
                    return segmentToGlobalOrd::get;
                }
            }
        }
    }
}

