/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.bulk.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class BulkStats
implements Writeable,
ToXContentFragment {
    private long totalOperations = 0L;
    private long totalTimeInMillis = 0L;
    private long totalSizeInBytes = 0L;
    private long avgTimeInMillis = 0L;
    private long avgSizeInBytes = 0L;

    public BulkStats() {
    }

    public BulkStats(StreamInput in) throws IOException {
        this.totalOperations = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.totalSizeInBytes = in.readVLong();
        this.avgTimeInMillis = in.readVLong();
        this.avgSizeInBytes = in.readVLong();
    }

    public BulkStats(long totalOperations, long totalTimeInMillis, long totalSizeInBytes, long avgTimeInMillis, long avgSizeInBytes) {
        this.totalOperations = totalOperations;
        this.totalTimeInMillis = totalTimeInMillis;
        this.totalSizeInBytes = totalSizeInBytes;
        this.avgTimeInMillis = avgTimeInMillis;
        this.avgSizeInBytes = avgSizeInBytes;
    }

    public void add(BulkStats bulkStats) {
        this.addTotals(bulkStats);
    }

    public void addTotals(BulkStats bulkStats) {
        if (bulkStats == null) {
            return;
        }
        if (this.totalOperations > 0L || bulkStats.totalOperations > 0L) {
            this.avgTimeInMillis = (this.avgTimeInMillis * this.totalOperations + bulkStats.avgTimeInMillis * bulkStats.totalOperations) / (this.totalOperations + bulkStats.totalOperations);
            this.avgSizeInBytes = (this.avgSizeInBytes * this.totalOperations + bulkStats.avgSizeInBytes * bulkStats.totalOperations) / (this.totalOperations + bulkStats.totalOperations);
        }
        this.totalOperations += bulkStats.totalOperations;
        this.totalTimeInMillis += bulkStats.totalTimeInMillis;
        this.totalSizeInBytes += bulkStats.totalSizeInBytes;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getTotalOperations() {
        return this.totalOperations;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public TimeValue getAvgTime() {
        return new TimeValue(this.avgTimeInMillis);
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getAvgTimeInMillis() {
        return this.avgTimeInMillis;
    }

    public long getAvgSizeInBytes() {
        return this.avgSizeInBytes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalOperations);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.totalSizeInBytes);
        out.writeVLong(this.avgTimeInMillis);
        out.writeVLong(this.avgSizeInBytes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("bulk");
        builder.field("total_operations", this.totalOperations);
        builder.humanReadableField("total_time_in_millis", "total_time", this.getTotalTime());
        builder.field("total_size_in_bytes", this.totalSizeInBytes);
        builder.humanReadableField("avg_time_in_millis", "avg_time", this.getAvgTime());
        builder.field("avg_size_in_bytes", this.avgSizeInBytes);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkStats that = (BulkStats)o;
        return Objects.equals(this.totalOperations, that.totalOperations) && Objects.equals(this.totalTimeInMillis, that.totalTimeInMillis) && Objects.equals(this.totalSizeInBytes, that.totalSizeInBytes) && Objects.equals(this.avgTimeInMillis, that.avgTimeInMillis) && Objects.equals(this.avgSizeInBytes, that.avgSizeInBytes);
    }

    public int hashCode() {
        return Objects.hash(this.totalOperations, this.totalTimeInMillis, this.totalSizeInBytes, this.avgTimeInMillis, this.avgSizeInBytes);
    }

    static final class Fields {
        static final String BULK = "bulk";
        static final String TOTAL_OPERATIONS = "total_operations";
        static final String TOTAL_TIME = "total_time";
        static final String AVG_TIME = "avg_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String TOTAL_SIZE_IN_BYTES = "total_size_in_bytes";
        static final String AVG_TIME_IN_MILLIS = "avg_time_in_millis";
        static final String AVG_SIZE_IN_BYTES = "avg_size_in_bytes";

        Fields() {
        }
    }
}

