/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.util.ServiceLoader;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.env.DefaultBuildVersion;
import org.elasticsearch.internal.BuildExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public abstract class BuildVersion {
    public abstract boolean canRemoveAssumedFeatures();

    public abstract boolean onOrAfterMinimumCompatible();

    public abstract boolean isFutureVersion();

    @Deprecated
    public Version toVersion() {
        return null;
    }

    public static BuildVersion fromVersionId(int versionId) {
        return CurrentExtensionHolder.BUILD_EXTENSION.fromVersionId(versionId);
    }

    public static BuildVersion current() {
        return CurrentExtensionHolder.BUILD_EXTENSION.currentBuildVersion();
    }

    public abstract int id();

    private static class CurrentExtensionHolder {
        private static final BuildExtension BUILD_EXTENSION = CurrentExtensionHolder.findExtension();

        private CurrentExtensionHolder() {
        }

        private static BuildExtension findExtension() {
            return ExtensionLoader.loadSingleton(ServiceLoader.load(BuildExtension.class)).orElse(new DefaultBuildExtension());
        }
    }

    private static class DefaultBuildExtension
    implements BuildExtension {
        private DefaultBuildExtension() {
        }

        @Override
        public Build getCurrentBuild() {
            return Build.current();
        }

        @Override
        public BuildVersion currentBuildVersion() {
            return DefaultBuildVersion.CURRENT;
        }

        @Override
        public BuildVersion fromVersionId(int versionId) {
            return new DefaultBuildVersion(versionId);
        }
    }
}

