/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ReadOnlyUrlRepositorySettings;
import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ReadOnlyUrlRepository
extends RepositoryBase
implements RepositoryVariant {
    private final ReadOnlyUrlRepositorySettings settings;
    public static final JsonpDeserializer<ReadOnlyUrlRepository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReadOnlyUrlRepository::setupReadOnlyUrlRepositoryDeserializer);

    private ReadOnlyUrlRepository(Builder builder) {
        super(builder);
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
    }

    public static ReadOnlyUrlRepository of(Function<Builder, ObjectBuilder<ReadOnlyUrlRepository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Repository.Kind _repositoryKind() {
        return Repository.Kind.Url;
    }

    public final ReadOnlyUrlRepositorySettings settings() {
        return this.settings;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "url");
        super.serializeInternal(generator, mapper);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    protected static void setupReadOnlyUrlRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        RepositoryBase.setupRepositoryBaseDeserializer(op);
        op.add(Builder::settings, ReadOnlyUrlRepositorySettings._DESERIALIZER, "settings");
        op.ignore("type");
    }

    public static class Builder
    extends RepositoryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ReadOnlyUrlRepository> {
        private ReadOnlyUrlRepositorySettings settings;

        public final Builder settings(ReadOnlyUrlRepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<ReadOnlyUrlRepositorySettings.Builder, ObjectBuilder<ReadOnlyUrlRepositorySettings>> fn) {
            return this.settings(fn.apply(new ReadOnlyUrlRepositorySettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReadOnlyUrlRepository build() {
            this._checkSingleUse();
            return new ReadOnlyUrlRepository(this);
        }
    }
}

