/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TimingStats
implements JsonpSerializable {
    private final long elapsedTime;
    @Nullable
    private final Long iterationTime;
    public static final JsonpDeserializer<TimingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimingStats::setupTimingStatsDeserializer);

    private TimingStats(Builder builder) {
        this.elapsedTime = ApiTypeHelper.requireNonNull(builder.elapsedTime, (Object)this, "elapsedTime", 0L);
        this.iterationTime = builder.iterationTime;
    }

    public static TimingStats of(Function<Builder, ObjectBuilder<TimingStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long elapsedTime() {
        return this.elapsedTime;
    }

    @Nullable
    public final Long iterationTime() {
        return this.iterationTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("elapsed_time");
        generator.write(this.elapsedTime);
        if (this.iterationTime != null) {
            generator.writeKey("iteration_time");
            generator.write(this.iterationTime);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTimingStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::elapsedTime, JsonpDeserializer.longDeserializer(), "elapsed_time");
        op.add(Builder::iterationTime, JsonpDeserializer.longDeserializer(), "iteration_time");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TimingStats> {
        private Long elapsedTime;
        @Nullable
        private Long iterationTime;

        public final Builder elapsedTime(long value) {
            this.elapsedTime = value;
            return this;
        }

        public final Builder iterationTime(@Nullable Long value) {
            this.iterationTime = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TimingStats build() {
            this._checkSingleUse();
            return new TimingStats(this);
        }
    }
}

