/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.security.HttpResponse;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class CommandLineHttpClient {
    private static final int READ_TIMEOUT = 35000;
    private final Environment env;
    private final String pinnedCaCertFingerprint;

    public CommandLineHttpClient(Environment env) {
        this.env = env;
        this.pinnedCaCertFingerprint = null;
    }

    public CommandLineHttpClient(Environment env, String pinnedCaCertFingerprint) {
        this.env = env;
        this.pinnedCaCertFingerprint = pinnedCaCertFingerprint;
    }

    public HttpResponse execute(String method, URL url, String user, SecureString password, CheckedSupplier<String, Exception> requestBodySupplier, CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception> responseHandler) throws Exception {
        String authorizationHeader = UsernamePasswordToken.basicAuthHeaderValue(user, password);
        return this.execute(method, url, authorizationHeader, requestBodySupplier, responseHandler);
    }

    public HttpResponse execute(String method, URL url, SecureString apiKey, CheckedSupplier<String, Exception> requestBodySupplier, CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception> responseHandler) throws Exception {
        String authorizationHeaderValue = CommandLineHttpClient.apiKeyHeaderValue(apiKey);
        return this.execute(method, url, authorizationHeaderValue, requestBodySupplier, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="We call connect in doPrivileged and provide SocketPermission")
    private HttpResponse execute(String method, URL url, String authorizationHeader, CheckedSupplier<String, Exception> requestBodySupplier, CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception> responseHandler) throws Exception {
        HttpResponse.HttpResponseBuilder responseBuilder;
        HttpURLConnection conn;
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            SSLService sslService = new SSLService(this.env);
            HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
            AccessController.doPrivileged(() -> {
                if (this.pinnedCaCertFingerprint != null) {
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, new TrustManager[]{CommandLineHttpClient.fingerprintTrustingTrustManager(this.pinnedCaCertFingerprint)}, null);
                    httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
                } else {
                    SslConfiguration sslConfiguration = sslService.getHttpTransportSSLConfiguration();
                    httpsConn.setSSLSocketFactory(sslService.sslSocketFactory(sslConfiguration));
                    boolean isHostnameVerificationEnabled = sslConfiguration.verificationMode().isHostnameVerificationEnabled();
                    if (!isHostnameVerificationEnabled) {
                        httpsConn.setHostnameVerifier((hostname, session) -> true);
                    }
                }
                return null;
            });
            conn = httpsConn;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setReadTimeout(35000);
        conn.setRequestProperty("Authorization", authorizationHeader);
        conn.setRequestProperty("Content-Type", XContentType.JSON.mediaType());
        String bodyString = requestBodySupplier.get();
        conn.setDoOutput(bodyString != null);
        SocketAccess.doPrivileged(conn::connect);
        if (bodyString != null) {
            try (OutputStream out = conn.getOutputStream();){
                out.write(bodyString.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                Releasable[] releasableArray = new Releasable[1];
                releasableArray[0] = conn::disconnect;
                Releasables.closeWhileHandlingException(releasableArray);
                throw e;
            }
        }
        int responseCode = conn.getResponseCode();
        try (InputStream inputStream = conn.getInputStream();){
            responseBuilder = responseHandler.apply(inputStream);
        }
        catch (IOException e) {
            try (InputStream errorStream = conn.getErrorStream();){
                responseBuilder = responseHandler.apply(errorStream);
            }
            catch (Throwable throwable) {
                Releasable[] releasableArray = new Releasable[1];
                releasableArray[0] = conn::disconnect;
                Releasables.closeWhileHandlingException(releasableArray);
                throw throwable;
            }
            Releasable[] releasableArray = new Releasable[1];
            releasableArray[0] = conn::disconnect;
            Releasables.closeWhileHandlingException(releasableArray);
        }
        Releasable[] releasableArray = new Releasable[1];
        releasableArray[0] = conn::disconnect;
        Releasables.closeWhileHandlingException(releasableArray);
        responseBuilder.withHttpStatus(responseCode);
        return responseBuilder.build();
    }

    public String getDefaultURL() {
        Settings settings = this.env.settings();
        String scheme = XPackSettings.HTTP_SSL_ENABLED.get(settings) != false ? "https" : "http";
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        if (httpPublishHost.isEmpty()) {
            httpPublishHost = NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings);
        }
        NetworkService networkService = new NetworkService(Collections.emptyList());
        try {
            InetAddress publishAddress = networkService.resolvePublishHostAddresses(httpPublishHost.toArray(Strings.EMPTY_ARRAY));
            int port = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
            if (port <= 0) {
                int[] ports = HttpTransportSettings.SETTING_HTTP_PORT.get(settings).ports();
                if (ports.length > 0) {
                    port = ports[0];
                }
                if (port <= 0) {
                    throw new IllegalStateException("unable to determine http port from settings");
                }
            }
            return scheme + "://" + InetAddresses.toUriString(publishAddress) + ":" + port;
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to determine default URL from settings, please use the -u option to explicitly provide the url", e);
        }
    }

    public static String getErrorCause(HttpResponse httpResponse) {
        Object error = httpResponse.getResponseBody().get("error");
        if (error == null) {
            return null;
        }
        if (error instanceof Map) {
            Object reason = ((Map)error).get("reason");
            if (reason != null) {
                return reason.toString();
            }
            Object root = ((Map)error).get("root_cause");
            if (root != null && root instanceof Map) {
                reason = ((Map)root).get("reason");
                if (reason != null) {
                    return reason.toString();
                }
                Object type = ((Map)root).get("type");
                if (type != null) {
                    return (String)type;
                }
            }
            return String.valueOf(((Map)error).get("type"));
        }
        return error.toString();
    }

    public void checkClusterHealthWithRetriesWaitingForCluster(String username, SecureString password, int retries) throws Exception {
        HttpResponse response;
        URL clusterHealthUrl = CommandLineHttpClient.createURL(new URL(this.getDefaultURL()), "_cluster/health", "?wait_for_status=yellow&pretty");
        try {
            response = this.execute("GET", clusterHealthUrl, username, password, () -> null, CommandLineHttpClient::responseBuilder);
        }
        catch (Exception e) {
            if (retries > 0) {
                Thread.sleep(1000L);
                this.checkClusterHealthWithRetriesWaitingForCluster(username, password, --retries);
                return;
            }
            throw new IllegalStateException("Failed to determine the health of the cluster.", e);
        }
        int responseStatus = response.getHttpStatus();
        if (responseStatus != 200) {
            if (responseStatus != 503) {
                if (retries > 0) {
                    Thread.sleep(1000L);
                    this.checkClusterHealthWithRetriesWaitingForCluster(username, password, --retries);
                    return;
                }
                throw new IllegalStateException("Failed to determine the health of the cluster. Unexpected http status [" + responseStatus + "]");
            }
            throw new IllegalStateException("Failed to determine the health of the cluster. Unexpected http status [" + responseStatus + "]");
        }
        String clusterStatus = Objects.toString(response.getResponseBody().get("status"), "");
        if (clusterStatus.isEmpty()) {
            throw new IllegalStateException("Failed to determine the health of the cluster. Cluster health API did not return a status value.");
        }
        if ("red".equalsIgnoreCase(clusterStatus)) {
            throw new IllegalStateException("Failed to determine the health of the cluster. Cluster health is currently RED.");
        }
    }

    public static HttpResponse.HttpResponseBuilder responseBuilder(InputStream is) throws IOException {
        HttpResponse.HttpResponseBuilder httpResponseBuilder = new HttpResponse.HttpResponseBuilder();
        String responseBody = Streams.readFully(is).utf8ToString();
        httpResponseBuilder.withResponseBody(responseBody);
        return httpResponseBuilder;
    }

    public static URL createURL(URL url, String path, String query) throws MalformedURLException, URISyntaxException {
        return new URL(url, (url.toURI().getPath() + path).replaceAll("//+", "/") + query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String apiKeyHeaderValue(SecureString apiKey) {
        CharBuffer chars = CharBuffer.allocate(apiKey.length());
        byte[] charBytes = null;
        try {
            chars.put(apiKey.getChars());
            charBytes = CharArrays.toUtf8Bytes(chars.array());
            String apiKeyToken = Base64.getEncoder().encodeToString(charBytes);
            String string = "ApiKey " + apiKeyToken;
            return string;
        }
        finally {
            Arrays.fill(chars.array(), '\u0000');
            if (charBytes != null) {
                Arrays.fill(charBytes, (byte)0);
            }
        }
    }

    private static TrustManager fingerprintTrustingTrustManager(final String caCertFingerprint) {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain.length < 2) {
                    throw new CertificateException("CA certificate not in chain, or self-signed certificate");
                }
                X509Certificate caCertFromChain = chain[1];
                MessageDigest sha256 = MessageDigests.sha256();
                sha256.update(caCertFromChain.getEncoded());
                if (!MessageDigests.toHexString(sha256.digest()).equals(caCertFingerprint)) {
                    throw new CertificateException();
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return trustManager;
    }
}

