/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ml.inference.utils.SimpleBoundedInputStream;

public final class InferenceToXContentCompressor {
    private static final int BUFFER_SIZE = 4096;
    private static final long MAX_INFLATED_BYTES = Math.min((long)(0.25 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes()), ByteSizeValue.ofGb(1L).getBytes());

    private InferenceToXContentCompressor() {
    }

    public static <T extends ToXContentObject> BytesReference deflate(T objectToCompress) throws IOException {
        BytesReference reference = XContentHelper.toXContent(objectToCompress, XContentType.JSON, false);
        return InferenceToXContentCompressor.deflate(reference);
    }

    public static <T> T inflateUnsafe(BytesReference compressedBytes, CheckedFunction<XContentParser, T, IOException> parserFunction, NamedXContentRegistry xContentRegistry) throws IOException {
        return InferenceToXContentCompressor.inflate(compressedBytes, parserFunction, xContentRegistry, Long.MAX_VALUE);
    }

    public static <T> T inflate(BytesReference compressedBytes, CheckedFunction<XContentParser, T, IOException> parserFunction, NamedXContentRegistry xContentRegistry) throws IOException {
        return InferenceToXContentCompressor.inflate(compressedBytes, parserFunction, xContentRegistry, MAX_INFLATED_BYTES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T inflate(BytesReference compressedBytes, CheckedFunction<XContentParser, T, IOException> parserFunction, NamedXContentRegistry xContentRegistry, long maxBytes) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(xContentRegistry, LoggingDeprecationHandler.INSTANCE, InferenceToXContentCompressor.inflate(compressedBytes, maxBytes));){
            XContentParser t = parserFunction.apply(parser);
            return (T)t;
        }
        catch (XContentParseException parseException) {
            SimpleBoundedInputStream.StreamSizeExceededException streamSizeCause = (SimpleBoundedInputStream.StreamSizeExceededException)ExceptionsHelper.unwrap(parseException, SimpleBoundedInputStream.StreamSizeExceededException.class);
            if (streamSizeCause == null) throw parseException;
            throw new CircuitBreakingException("Cannot parse model definition as the content is larger than the maximum stream size of [" + streamSizeCause.getMaxBytes() + "] bytes. Max stream size is 10% of the JVM heap or 1GB whichever is smallest", CircuitBreaker.Durability.PERMANENT);
        }
    }

    static Map<String, Object> inflateToMap(BytesReference compressedBytes) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, InferenceToXContentCompressor.inflate(compressedBytes, MAX_INFLATED_BYTES));){
            Map<String, Object> map = parser.mapOrdered();
            return map;
        }
    }

    static InputStream inflate(BytesReference compressedBytes, long streamSize) throws IOException {
        if ((long)compressedBytes.length() > Math.max(100L, streamSize)) {
            throw new CircuitBreakingException("compressed stream is longer than maximum allowed bytes [" + streamSize + "]", CircuitBreaker.Durability.PERMANENT);
        }
        GZIPInputStream gzipStream = new GZIPInputStream((InputStream)compressedBytes.streamInput(), 4096);
        return new SimpleBoundedInputStream(gzipStream, streamSize);
    }

    private static BytesReference deflate(BytesReference reference) throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        try (GZIPOutputStream compressedOutput = new GZIPOutputStream((OutputStream)out, 4096);){
            reference.writeTo(compressedOutput);
        }
        return out.bytes();
    }
}

