/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenFloatKnnVectorQuery;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.KnnScoreDocQuery;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class ESDiversifyingChildrenFloatKnnVectorQuery
extends DiversifyingChildrenFloatKnnVectorQuery
implements QueryProfilerProvider {
    private final Integer kParam;
    private long vectorOpsCount;
    private final int k;

    public ESDiversifyingChildrenFloatKnnVectorQuery(String field, float[] query, Query childFilter, Integer k, int numCands, BitSetProducer parentsFilter) {
        super(field, query, childFilter, numCands, parentsFilter);
        this.kParam = k;
        this.k = numCands;
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query rewrittenQuery = super.rewrite(searcher);
        if (rewrittenQuery instanceof MatchNoDocsQuery) {
            return rewrittenQuery;
        }
        return KnnScoreDocQuery.fromQuery(rewrittenQuery, this.kParam == null ? this.k : this.kParam, searcher);
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = this.kParam == null ? super.mergeLeafResults(perLeafResults) : TopDocs.merge(this.kParam, perLeafResults);
        this.vectorOpsCount = topK.totalHits.value;
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.addVectorOpsCount(this.vectorOpsCount);
    }
}

