/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.search.aggregations.bucket.terms.BucketAndOrd;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public abstract class GeoGridAggregator<T extends InternalGeoGrid<?>>
extends BucketsAggregator {
    protected final int requiredSize;
    protected final int shardSize;
    protected final ValuesSource.Numeric valuesSource;
    protected final LongKeyedBucketOrds bucketOrds;

    protected GeoGridAggregator(String name, AggregatorFactories factories, Function<LongConsumer, ValuesSource.Numeric> valuesSource, int requiredSize, int shardSize, AggregationContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.valuesSource = valuesSource.apply(x$0 -> this.addRequestCircuitBreakerBytes(x$0));
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.bucketOrds = LongKeyedBucketOrds.build(this.bigArrays(), cardinality);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        SortedNumericDocValues values = this.valuesSource.longValues(aggCtx.getLeafReaderContext());
        NumericDocValues singleton = DocValues.unwrapSingleton(values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final NumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    long val = values.longValue();
                    long bucketOrdinal = GeoGridAggregator.this.bucketOrds.add(owningBucketOrd, val);
                    if (bucketOrdinal < 0L) {
                        bucketOrdinal = -1L - bucketOrdinal;
                        GeoGridAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                    } else {
                        GeoGridAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        long bucketOrdinal = GeoGridAggregator.this.bucketOrds.add(owningBucketOrd, val);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            GeoGridAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            GeoGridAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                        previous = val;
                    }
                }
            }
        };
    }

    protected abstract T buildAggregation(String var1, int var2, List<InternalGeoGridBucket> var3, Map<String, Object> var4);

    protected abstract InternalGeoGridBucket newEmptyBucket();

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        try (ObjectArray<B[]> topBucketsPerOrd = this.bigArrays().newObjectArray(owningBucketOrds.size());){
            try (IntArray bucketsSizePerOrd = this.bigArrays().newIntArray(owningBucketOrds.size());){
                long ordsToCollect = 0L;
                for (long ordIdx2 = 0L; ordIdx2 < owningBucketOrds.size(); ++ordIdx2) {
                    int size = (int)Math.min(this.bucketOrds.bucketsInOrd(owningBucketOrds.get(ordIdx2)), (long)this.shardSize);
                    ordsToCollect += (long)size;
                    bucketsSizePerOrd.set(ordIdx2, size);
                }
                try (LongArray ordsArray = this.bigArrays().newLongArray(ordsToCollect);){
                    long ordsCollected = 0L;
                    for (long ordIdx3 = 0L; ordIdx3 < topBucketsPerOrd.size(); ++ordIdx3) {
                        try (BucketPriorityQueue<BucketAndOrd, InternalGeoGridBucket> ordered = new BucketPriorityQueue<BucketAndOrd, InternalGeoGridBucket>(bucketsSizePerOrd.get(ordIdx3), this.bigArrays(), b -> (InternalGeoGridBucket)b.bucket);){
                            BucketAndOrd<InternalGeoGridBucket> spare = null;
                            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds.get(ordIdx3));
                            while (ordsEnum.next()) {
                                if (spare == null) {
                                    this.checkRealMemoryCBForInternalBucket();
                                    spare = new BucketAndOrd<InternalGeoGridBucket>(this.newEmptyBucket());
                                }
                                ((InternalGeoGridBucket)spare.bucket).hashAsLong = ordsEnum.value();
                                ((InternalGeoGridBucket)spare.bucket).docCount = this.bucketDocCount(ordsEnum.ord());
                                spare.ord = ordsEnum.ord();
                                spare = ordered.insertWithOverflow(spare);
                            }
                            int orderedSize = (int)ordered.size();
                            InternalGeoGridBucket[] buckets = new InternalGeoGridBucket[orderedSize];
                            for (int i = orderedSize - 1; i >= 0; --i) {
                                BucketAndOrd bucketBucketAndOrd = (BucketAndOrd)ordered.pop();
                                buckets[i] = (InternalGeoGridBucket)bucketBucketAndOrd.bucket;
                                ordsArray.set(ordsCollected + (long)i, bucketBucketAndOrd.ord);
                            }
                            topBucketsPerOrd.set(ordIdx3, buckets);
                            ordsCollected += (long)orderedSize;
                            continue;
                        }
                    }
                    assert (ordsCollected == ordsArray.size());
                    this.buildSubAggsForAllBuckets(topBucketsPerOrd, ordsArray, (B b, InternalAggregations aggs) -> {
                        b.aggregations = aggs;
                    });
                }
            }
            InternalAggregation[] internalAggregationArray = this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> this.buildAggregation(this.name, this.requiredSize, Arrays.asList((InternalGeoGridBucket[])topBucketsPerOrd.get(ordIdx)), this.metadata()));
            return internalAggregationArray;
        }
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.buildAggregation(this.name, this.requiredSize, Collections.emptyList(), this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

