/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.Validation;
import co.elastic.clients.elasticsearch.connector.ValidationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ListTypeValidation
implements ValidationVariant,
JsonpSerializable {
    private final String constraint;
    public static final JsonpDeserializer<ListTypeValidation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListTypeValidation::setupListTypeValidationDeserializer);

    private ListTypeValidation(Builder builder) {
        this.constraint = ApiTypeHelper.requireNonNull(builder.constraint, this, "constraint");
    }

    public static ListTypeValidation of(Function<Builder, ObjectBuilder<ListTypeValidation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Validation.Kind _validationKind() {
        return Validation.Kind.ListType;
    }

    public final String constraint() {
        return this.constraint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "list_type");
        generator.writeKey("constraint");
        generator.write(this.constraint);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupListTypeValidationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::constraint, JsonpDeserializer.stringDeserializer(), "constraint");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ListTypeValidation> {
        private String constraint;

        public final Builder constraint(String value) {
            this.constraint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ListTypeValidation build() {
            this._checkSingleUse();
            return new ListTypeValidation(this);
        }
    }
}

