/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimplePatternSplitTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final String pattern;
    public static final JsonpDeserializer<SimplePatternSplitTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimplePatternSplitTokenizer::setupSimplePatternSplitTokenizerDeserializer);

    private SimplePatternSplitTokenizer(Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
    }

    public static SimplePatternSplitTokenizer of(Function<Builder, ObjectBuilder<SimplePatternSplitTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.SimplePatternSplit;
    }

    @Nullable
    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "simple_pattern_split");
        super.serializeInternal(generator, mapper);
        if (this.pattern != null) {
            generator.writeKey("pattern");
            generator.write(this.pattern);
        }
    }

    protected static void setupSimplePatternSplitTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SimplePatternSplitTokenizer> {
        @Nullable
        private String pattern;

        public final Builder pattern(@Nullable String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimplePatternSplitTokenizer build() {
            this._checkSingleUse();
            return new SimplePatternSplitTokenizer(this);
        }
    }
}

