# frozen_string_literal: true

module Actastic
  module ActasticRecord
    class ActasticRecordError < StandardError; end
    class InvalidFieldName < StandardError; end
    class InvalidUpdate < StandardError; end
    class InvalidIdValue < StandardError; end
    class InvalidForeignKey < StandardError; end
    class RecordNotFound < ActasticRecordError; end
    class RecordNotUnique < ActasticRecordError; end
    class AssociationNotFound < ActasticRecordError; end
    class StaleObjectError < ActasticRecordError; end
    class InvalidQueryError < ArgumentError; end

    class RecordInvalid < ActasticRecordError
      attr_reader :record

      def initialize(record)
        @record = record
        errors = @record.errors.full_messages.join(', ')
        super(I18n.t(:'activemodel.errors.messages.record_invalid', :errors => errors, :default => :'errors.messages.record_invalid'))
      end
    end

    class RecordNotDestroyed < ActasticRecordError
      attr_reader :record

      def initialize(message, record = nil)
        @record = record
        super(message)
      end
    end
  end
end
