/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.pptx;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PPTXThumbnailer
implements Thumbnailer {
    Logger logger = LoggerFactory.getLogger(PPTXThumbnailer.class);

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream fis = new FileInputStream(input);){
                return this.getThumbnails(fis, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Could not find file {}", (Object)input.getAbsolutePath());
            this.logger.error("With stack: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new ThumbnailingException((Exception)e);
        }
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (XMLSlideShow pptx = new XMLSlideShow(input);){
                BufferedImage image = this.pptxToImage(pptx);
                ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
                for (Dimensions singleDimension : dimensions) {
                    results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to parse PPTX from stream: ", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
    }

    private BufferedImage pptxToImage(XMLSlideShow pptx) {
        Dimension pageSize = pptx.getPageSize();
        Dimensions optimizedDimensions = ThumbnailUtils.memoryOptimiseDimension((Dimensions)new Dimensions(pageSize.width, pageSize.height));
        double scaleFactor = (double)optimizedDimensions.getWidth() / (double)pageSize.width;
        BufferedImage image = new BufferedImage(optimizedDimensions.getWidth(), optimizedDimensions.getHeight(), 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setPaint(Color.white);
        graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, optimizedDimensions.getWidth(), optimizedDimensions.getHeight()));
        graphics.scale(scaleFactor, scaleFactor);
        ((XSLFSlide)pptx.getSlides().get(0)).draw(graphics);
        graphics.dispose();
        return image;
    }
}

