# frozen_string_literal: true
#
class Views::FritoPie::Components::Icons < ::Views::Base
  def content
    rawtext %{
      <svg style="position: absolute; width: 0; height: 0; overflow: hidden;" version="1.1" xmlns="http://www.w3.org/2000/svg">
          <defs>
              <symbol id="icon-analytics-fill" viewBox="0 0 32 32">
                  <title>icon-analytics-fill</title>
                  <path
                      d="M18.212 17.357c0.59 0.59 1.547 0.59 2.137 0l10.257-10.257c0.59-0.59 0.59-1.547 0-2.137s-1.547-0.59-2.137 0l-9.188 9.188-6.405-6.405c-0.59-0.59-1.547-0.59-2.137 0l-10.164 10.164c-0.59 0.59-0.59 1.547 0 2.137s1.547 0.59 2.137 0l9.096-9.096 6.405 6.405z"></path>
                  <path d="M28.412 12.898c0 0.835 0.677 1.511 1.511 1.511s1.511-0.677 1.511-1.511v-7.23c0-0.835-0.677-1.511-1.511-1.511h-7.23c-0.835 0-1.511 0.677-1.511 1.511s0.677 1.511 1.511 1.511h5.719v5.719z"></path>
                  <path d="M3.285 24.485v4.515c0 0.835 0.677 1.511 1.511 1.511s1.511-0.677 1.511-1.511v-4.515c0-0.835-0.677-1.511-1.511-1.511s-1.511 0.677-1.511 1.511z"></path>
                  <path d="M24.618 16.885v12.115c0 0.835 0.677 1.511 1.511 1.511s1.511-0.677 1.511-1.511v-12.115c0-0.835-0.677-1.511-1.511-1.511s-1.511 0.677-1.511 1.511z"></path>
                  <path d="M17.507 21.819v7.181c0 0.835 0.677 1.511 1.511 1.511s1.511-0.677 1.511-1.511v-7.181c0-0.835-0.677-1.511-1.511-1.511s-1.511 0.677-1.511 1.511z"></path>
                  <path d="M10.396 16.838v12.162c0 0.835 0.677 1.511 1.511 1.511s1.511-0.677 1.511-1.511v-12.162c0-0.835-0.677-1.511-1.511-1.511s-1.511 0.677-1.511 1.511z"></path>
              </symbol>
              <symbol id="icon-analytics" viewBox="0 0 32 32">
                  <title>icon-analytics</title>
                  <path
                      d="M18.658 16.9c0.347 0.347 0.91 0.347 1.257 0l10.257-10.257c0.347-0.347 0.347-0.91 0-1.257s-0.91-0.347-1.257 0l-9.628 9.628-6.845-6.845c-0.347-0.347-0.91-0.347-1.257 0l-10.164 10.164c-0.347 0.347-0.347 0.91 0 1.257s0.91 0.347 1.257 0l9.536-9.536 6.845 6.845z"></path>
                  <path d="M29.041 12.881c0 0.491 0.398 0.889 0.889 0.889s0.889-0.398 0.889-0.889v-7.23c0-0.491-0.398-0.889-0.889-0.889h-7.23c-0.491 0-0.889 0.398-0.889 0.889s0.398 0.889 0.889 0.889h6.341v6.341z"></path>
                  <path d="M3.914 24.468v4.515c0 0.491 0.398 0.889 0.889 0.889s0.889-0.398 0.889-0.889v-4.515c0-0.491-0.398-0.889-0.889-0.889s-0.889 0.398-0.889 0.889z"></path>
                  <path d="M25.247 16.868v12.115c0 0.491 0.398 0.889 0.889 0.889s0.889-0.398 0.889-0.889v-12.115c0-0.491-0.398-0.889-0.889-0.889s-0.889 0.398-0.889 0.889z"></path>
                  <path d="M18.136 21.801v7.181c0 0.491 0.398 0.889 0.889 0.889s0.889-0.398 0.889-0.889v-7.181c0-0.491-0.398-0.889-0.889-0.889s-0.889 0.398-0.889 0.889z"></path>
                  <path d="M11.025 16.821v12.162c0 0.491 0.398 0.889 0.889 0.889s0.889-0.398 0.889-0.889v-12.162c0-0.491-0.398-0.889-0.889-0.889s-0.889 0.398-0.889 0.889z"></path>
              </symbol>
              <symbol id="icon-settings-fill" viewBox="0 0 32 32">
                  <title>icon-settings-fill</title>
                  <path
                      d="M26.139 8.591c1.067 1.486 1.818 3.215 2.153 5.087h3.166v4.089h-3.105c-0.299 2.016-1.077 3.875-2.214 5.459l2.217 2.217-2.891 2.891-2.217-2.217c-1.535 1.102-3.329 1.867-5.273 2.185v3.134h-4.089v-3.134c-1.944-0.318-3.738-1.083-5.273-2.185l-2.217 2.217-2.891-2.891 2.217-2.217c-1.137-1.584-1.915-3.444-2.214-5.459h-3.105v-4.089h3.166c0.336-1.873 1.086-3.601 2.153-5.088l-2.217-2.217 2.891-2.891 2.217 2.217c1.535-1.102 3.329-1.867 5.273-2.185v-3.134h4.089v3.134c1.944 0.318 3.738 1.083 5.273 2.185l2.217-2.217 2.891 2.891-2.217 2.217zM21.24 15.909c0-2.932-2.377-5.309-5.309-5.309s-5.309 2.377-5.309 5.309 2.377 5.309 5.309 5.309c2.932 0 5.309-2.377 5.309-5.309z"></path>
              </symbol>
              <symbol id="icon-settings" viewBox="0 0 32 32">
                  <title>icon-settings</title>
                  <path
                      d="M26.459 15.906c0-5.807-4.708-10.515-10.515-10.515s-10.516 4.708-10.516 10.515 4.708 10.515 10.516 10.515c5.807 0 10.515-4.708 10.515-10.515zM28.237 15.906c0 6.789-5.504 12.293-12.293 12.293s-12.293-5.504-12.293-12.293 5.504-12.293 12.293-12.293c6.789 0 12.293 5.504 12.293 12.293z"></path>
                  <path
                      d="M19.209 15.906c0-1.803-1.462-3.265-3.265-3.265s-3.265 1.462-3.265 3.265 1.462 3.265 3.265 3.265c1.803 0 3.265-1.462 3.265-3.265zM20.986 15.906c0 2.785-2.258 5.043-5.043 5.043s-5.043-2.258-5.043-5.043 2.258-5.043 5.043-5.043c2.785 0 5.043 2.258 5.043 5.043z"></path>
                  <path d="M14.077 27.195v4.24h3.733v-4.24z"></path>
                  <path d="M14.077 0.378v3.468h3.733v-3.468z"></path>
                  <path d="M4.745 13.854h-4.33v3.733h4.33z"></path>
                  <path d="M31.472 13.854h-4.519v3.733h4.519z"></path>
                  <path d="M22.546 25.148l3.058 3.058 2.64-2.64-3.058-3.058z"></path>
                  <path d="M3.644 6.246l3.070 3.070 2.64-2.64-3.070-3.070z"></path>
                  <path d="M6.706 22.504l-3.063 3.063 2.64 2.64 3.063-3.063z"></path>
                  <path d="M25.604 3.606l-2.975 2.975 2.64 2.64 2.975-2.975z"></path>
              </symbol>
              <symbol id="icon-groups-fill" viewBox="0 0 32 32">
                  <title>icon-groups-fill</title>
                  <path d="M9.492 6.945c0-1.643-1.333-2.974-2.976-2.974s-2.974 1.332-2.974 2.974c0 1.643 1.332 2.976 2.974 2.976s2.976-1.333 2.976-2.976z"></path>
                  <path d="M28.459 6.945c0-1.643-1.333-2.974-2.976-2.974-1.644 0-2.976 1.332-2.976 2.974s1.332 2.976 2.976 2.976c1.643 0 2.976-1.333 2.976-2.976z"></path>
                  <path d="M20.378 9.2c0-2.549-2.066-4.615-4.615-4.615s-4.615 2.066-4.615 4.615c0 2.549 2.066 4.615 4.615 4.615s4.615-2.066 4.615-4.615z"></path>
                  <path d="M31.176 16.105c-0.22-2.754-2.455-4.532-5.692-4.532-2.597 0-4.528 1.157-5.312 3.029 2.656 0.958 4.62 2.812 5.596 5.264h4.747c0.249 0 0.484-0.105 0.652-0.286 0.169-0.183 0.254-0.427 0.233-0.674l-0.224-2.802z"></path>
                  <path d="M11.769 14.449c-0.825-1.785-2.725-2.876-5.253-2.876-3.237 0-5.472 1.778-5.692 4.532l-0.224 2.802c-0.020 0.247 0.064 0.491 0.233 0.674 0.167 0.181 0.405 0.286 0.652 0.286h4.272c1.026-2.581 3.143-4.508 6.012-5.417z"></path>
                  <path
                      d="M23.963 22.807c-0.32-3.989-3.461-6.469-8.201-6.469s-7.881 2.48-8.201 6.469l-0.34 4.261c-0.021 0.249 0.064 0.492 0.233 0.674 0.167 0.183 0.404 0.288 0.652 0.288h15.31c0.249 0 0.485-0.105 0.654-0.288 0.167-0.181 0.252-0.425 0.231-0.674l-0.34-4.261z"></path>
              </symbol>
              <symbol id="icon-groups" viewBox="0 0 32 32">
                  <title>icon-groups</title>
                  <path
                      d="M18.582 9.35c0-1.558-1.263-2.82-2.82-2.82s-2.82 1.263-2.82 2.82c0 1.558 1.263 2.82 2.82 2.82s2.82-1.263 2.82-2.82zM18.582 9.35c0-0.491 0.398-0.889 0.889-0.889s0.889 0.398 0.889 0.889c0 2.54-2.059 4.598-4.598 4.598s-4.598-2.059-4.598-4.598c0-2.54 2.059-4.598 4.598-4.598s4.598 2.059 4.598 4.598c0 0.491-0.398 0.889-0.889 0.889s-0.889-0.398-0.889-0.889z"></path>
                  <path
                      d="M27.029 7.145c0-0.854-0.692-1.546-1.546-1.546s-1.546 0.692-1.546 1.546c0 0.854 0.692 1.546 1.546 1.546s1.546-0.692 1.546-1.546zM27.029 7.145c0-0.491 0.398-0.889 0.889-0.889s0.889 0.398 0.889 0.889c0 1.836-1.488 3.324-3.324 3.324s-3.324-1.488-3.324-3.324c0-1.836 1.488-3.324 3.324-3.324s3.324 1.488 3.324 3.324c0 0.491-0.398 0.889-0.889 0.889s-0.889-0.398-0.889-0.889z"></path>
                  <path
                      d="M8.058 7.145c0-0.851-0.69-1.541-1.541-1.541s-1.541 0.69-1.541 1.541c0 0.851 0.69 1.541 1.541 1.541s1.541-0.69 1.541-1.541zM8.058 7.145c0-0.491 0.398-0.889 0.889-0.889s0.889 0.398 0.889 0.889c0 1.833-1.486 3.319-3.319 3.319s-3.319-1.486-3.319-3.319c0-1.833 1.486-3.319 3.319-3.319s3.319 1.486 3.319 3.319c0 0.491-0.398 0.889-0.889 0.889s-0.889-0.398-0.889-0.889z"></path>
                  <path
                      d="M11.14 19.127c0 0.491-0.398 0.889-0.889 0.889h-8.766c-0.519 0-0.927-0.443-0.886-0.96l0.224-2.801c0.23-2.872 2.557-4.532 5.694-4.532s5.464 1.66 5.694 4.532l0.147 1.839c0.039 0.489-0.326 0.918-0.815 0.957-0.146 0.012-0.287-0.013-0.414-0.066 0.007 0.046 0.011 0.094 0.011 0.142zM10.585 18.236l-0.147-1.839c-0.147-1.838-1.63-2.896-3.921-2.896s-3.774 1.058-3.921 2.896l-0.147 1.842h7.803c0.121 0 0.237 0.024 0.343 0.069-0.004-0.023-0.007-0.047-0.009-0.071z"></path>
                  <path
                      d="M20.436 19.325c-0.489-0.039-0.854-0.468-0.815-0.957l0.169-2.113c0.23-2.872 2.557-4.532 5.694-4.532s5.464 1.66 5.694 4.532l0.224 2.801c0.041 0.517-0.367 0.96-0.886 0.96h-9.16c-0.422 0-0.776-0.294-0.866-0.689-0.017-0-0.035-0.001-0.053-0.003zM29.552 18.239l-0.147-1.842c-0.147-1.838-1.63-2.896-3.921-2.896s-3.774 1.058-3.921 2.896l-0.147 1.842h8.137z"></path>
                  <path
                      d="M22.191 23.099c-0.245-3.067-2.722-4.833-6.428-4.833s-6.183 1.767-6.428 4.833l-0.264 3.303h13.385l-0.264-3.303zM23.418 28.179h-15.311c-0.519 0-0.927-0.443-0.886-0.96l0.341-4.262c0.328-4.101 3.648-6.469 8.2-6.469s7.872 2.368 8.2 6.469l0.341 4.262c0.041 0.517-0.367 0.96-0.886 0.96z"></path>
              </symbol>
              <symbol id="icon-overview-fill" viewBox="0 0 32 32">
                  <title>icon-overview-fill</title>
                  <path
                      d="M19.924 21.099c0-2.651 2.060-4.786 4.581-4.786s4.581 2.135 4.581 4.786c0 2.652-2.060 4.786-4.581 4.786s-4.581-2.133-4.581-4.786zM14.588 15.724c0.009-0.508 0.009-0.508 0.016-1.020 0.020-1.33 0.036-2.473 0.046-3.415 0.036-0.011 0.059-0.020 0.096-0.030 0.857-0.242 1.746-0.283 2.594-0.060 0.012 0.958 0.028 2.133 0.048 3.506 0.009 0.512 0.009 0.512 0.016 1.020 0.016 1.063 0.034 2.151 0.050 3.22-0.981-0.183-1.964-0.133-2.917 0.085 0.018-1.097 0.036-2.213 0.052-3.305zM2.913 21.099c0-2.651 2.060-4.786 4.581-4.786 2.523 0 4.583 2.135 4.583 4.786 0 2.652-2.060 4.786-4.583 4.786-2.521 0-4.581-2.133-4.581-4.786zM30.918 18.455c-0.199-0.564-0.199-0.564-0.482-1.362-0.498-1.408-0.996-2.816-1.461-4.132-1.305-3.684-2.064-5.813-2.156-6.043-0.761-1.867-2.544-3.115-4.558-3.115-2.727 0-4.919 2.263-4.937 5.040-0.892-0.146-1.785-0.108-2.652 0.076 0-2.836-2.203-5.116-4.939-5.116-2.016 0-3.797 1.248-4.558 3.115-0.094 0.229-0.853 2.359-2.148 6.014-0.476 1.344-0.974 2.752-1.472 4.16-0.283 0.798-0.283 0.798-0.482 1.362-0.149 0.421-0.471 1.906-0.471 2.644 0 3.911 3.077 7.097 6.892 7.097 3.692 0 6.667-2.99 6.857-6.727 0.1-0.037 0.224-0.080 0.395-0.128 0.958-0.27 1.959-0.284 2.894 0.041 0.148 3.778 3.143 6.814 6.866 6.814 3.817 0 6.892-3.186 6.892-7.097 0-0.74-0.331-2.222-0.48-2.644z"></path>
              </symbol>
              <symbol id="icon-overview" viewBox="0 0 32 32">
                  <title>icon-overview</title>
                  <path
                      d="M7.495 27.929c-3.667 0-6.626-3.065-6.626-6.83s2.96-6.83 6.626-6.83c3.667 0 6.626 3.065 6.626 6.83s-2.96 6.83-6.626 6.83zM7.495 26.151c2.671 0 4.849-2.255 4.849-5.052s-2.178-5.052-4.849-5.052c-2.671 0-4.849 2.255-4.849 5.052s2.178 5.052 4.849 5.052z"></path>
                  <path
                      d="M24.506 27.929c-3.667 0-6.626-3.065-6.626-6.83s2.96-6.83 6.626-6.83c3.667 0 6.626 3.065 6.626 6.83s-2.96 6.83-6.626 6.83zM24.506 26.151c2.671 0 4.849-2.255 4.849-5.052s-2.178-5.052-4.849-5.052c-2.671 0-4.849 2.255-4.849 5.052s2.178 5.052 4.849 5.052z"></path>
                  <path
                      d="M30.849 19.060c-0.033-0.094-0.033-0.094-0.182-0.516-0.199-0.563-0.199-0.563-0.481-1.361-0.498-1.408-0.996-2.816-1.461-4.131-1.297-3.662-2.062-5.809-2.153-6.031-0.721-1.769-2.407-2.95-4.311-2.95-2.588 0-4.673 2.159-4.673 4.808 0 0.851 0.025 2.912 0.068 5.822 0.008 0.512 0.008 0.512 0.015 1.020 0.018 1.198 0.038 2.431 0.057 3.631 0.012 0.72 0.021 1.268 0.026 1.577l1.778-0.030c-0.005-0.308-0.014-0.856-0.026-1.576-0.020-1.199-0.039-2.431-0.057-3.629-0.008-0.508-0.008-0.508-0.015-1.019-0.043-2.899-0.068-4.958-0.068-5.796 0-1.68 1.303-3.030 2.896-3.030 1.168 0 2.212 0.731 2.665 1.843 0.073 0.179 0.88 2.445 2.113 5.925 0.476 1.343 0.974 2.751 1.471 4.158 0.282 0.798 0.282 0.798 0.481 1.361 0.149 0.422 0.149 0.422 0.182 0.516l1.676-0.592z"></path>
                  <path
                      d="M2.819 19.652c0.033-0.094 0.033-0.094 0.182-0.516 0.199-0.563 0.199-0.563 0.481-1.361 0.498-1.408 0.996-2.816 1.461-4.13 1.243-3.509 2.050-5.775 2.123-5.954 0.453-1.111 1.498-1.843 2.665-1.843 1.592 0 2.896 1.35 2.896 3.030 0 0.839-0.025 2.897-0.068 5.796-0.008 0.512-0.008 0.512-0.015 1.019-0.018 1.198-0.038 2.43-0.057 3.629-0.012 0.719-0.021 1.267-0.026 1.576l1.778 0.030c0.005-0.309 0.014-0.857 0.026-1.577 0.020-1.199 0.039-2.432 0.057-3.631 0.008-0.508 0.008-0.508 0.015-1.020 0.043-2.91 0.068-4.971 0.068-5.822 0-2.648-2.085-4.808-4.673-4.808-1.904 0-3.59 1.181-4.311 2.95-0.090 0.222-0.856 2.37-2.143 6.003-0.476 1.343-0.974 2.751-1.472 4.16-0.282 0.798-0.282 0.798-0.481 1.361-0.149 0.422-0.149 0.422-0.182 0.516l1.676 0.592z"></path>
                  <path d="M14.091 21.286c0.093-0.044 0.295-0.121 0.582-0.202 1.135-0.32 2.335-0.326 3.433 0.175l0.737-1.618c-1.537-0.701-3.149-0.692-4.653-0.268-0.386 0.109-0.678 0.221-0.854 0.304l0.755 1.609z"></path>
                  <path d="M14.091 11.205c0.093-0.044 0.295-0.121 0.582-0.202 1.135-0.32 2.335-0.326 3.433 0.175l0.737-1.618c-1.537-0.701-3.149-0.692-4.653-0.268-0.386 0.109-0.678 0.221-0.854 0.304l0.755 1.609z"></path>
              </symbol>
              <symbol id="icon-security-fill" viewBox="0 0 32 32">
                  <title>icon-security-fill</title>
                  <path d="M19.811 8.6v-1.52c0-2.095-1.706-3.795-3.812-3.795s-3.812 1.7-3.812 3.795v1.521c-1.074 0.332-2.089 0.801-3.022 1.386v-2.907c0-3.766 3.061-6.817 6.834-6.817s6.834 3.051 6.834 6.817v2.906c-0.934-0.585-1.948-1.054-3.022-1.386z"></path>
                  <path
                      d="M15.119 21.169l-1.444 4.572h4.739l-1.442-4.598c0.998-0.386 1.706-1.357 1.706-2.493 0-1.475-1.194-2.672-2.667-2.672s-2.667 1.196-2.667 2.672c0 1.162 0.741 2.151 1.775 2.519zM16 31.738c-6.023 0-10.908-4.869-10.908-10.877s4.884-10.877 10.908-10.877c6.023 0 10.908 4.869 10.908 10.877s-4.884 10.877-10.908 10.877z"></path>
              </symbol>
              <symbol id="icon-security" viewBox="0 0 32 32">
                  <title>icon-security</title>
                  <path d="M22.211 12.467v-5.383c0-3.422-2.782-6.195-6.212-6.195s-6.212 2.773-6.212 6.195v5.383h1.778v-5.383c0-2.439 1.985-4.417 4.434-4.417s4.434 1.978 4.434 4.417v5.383h1.778z"></path>
                  <path
                      d="M16 31.475c-5.876 0-10.641-4.75-10.641-10.611s4.765-10.611 10.641-10.611c5.876 0 10.641 4.75 10.641 10.611s-4.765 10.611-10.641 10.611zM16 29.698c4.896 0 8.863-3.955 8.863-8.833s-3.968-8.833-8.863-8.833c-4.896 0-8.863 3.955-8.863 8.833s3.968 8.833 8.863 8.833z"></path>
                  <path d="M15.119 21.174c-1.034-0.367-1.775-1.356-1.775-2.519 0-1.475 1.194-2.672 2.667-2.672s2.667 1.196 2.667 2.672c0 1.136-0.708 2.106-1.706 2.493l1.442 4.598h-4.739l1.444-4.572z"></path>
              </symbol>
              <symbol id="icon-sources-fill" viewBox="0 0 32 32">
                  <title>icon-sources-fill</title>
                  <path
                      d="M24.892 10.009c-1.65-3.287-5.020-5.383-8.725-5.383-4.779 0-8.859 3.524-9.628 8.16-2.924 0.231-5.236 2.686-5.236 5.669 0 3.136 2.553 5.687 5.689 5.687h6.059l1.906-4.581c0.092-0.22-0.071-0.462-0.309-0.462h-3.554c-0.185 0-0.283-0.219-0.164-0.359l7.552-8.736c0.135-0.158 0.386-0.004 0.306 0.188l-2.386 5.842c-0.091 0.22 0.071 0.46 0.309 0.46h3.824c0.185 0 0.284 0.219 0.165 0.361l-6.316 7.287h9.188c3.931 0 7.127-3.198 7.127-7.129 0-3.452-2.462-6.379-5.806-7.004z"></path>
              </symbol>
              <symbol id="icon-sources" viewBox="0 0 32 32">
                  <title>icon-sources</title>
                  <path
                      d="M16.166 4.688c-4.82 0-8.862 3.507-9.628 8.16-2.929 0.231-5.235 2.681-5.235 5.67 0 3.141 2.546 5.687 5.687 5.687h2.765c0.491 0 0.889-0.398 0.889-0.889s-0.398-0.889-0.889-0.889h-2.765c-2.159 0-3.91-1.75-3.91-3.91s1.75-3.91 3.91-3.91c0.092 0 0.183 0.003 0.273 0.009 0.486 0.033 0.908-0.33 0.947-0.816 0.33-4.128 3.787-7.335 7.955-7.335 3.196 0 6.044 1.895 7.309 4.771 0.127 0.289 0.398 0.489 0.712 0.525 2.684 0.308 4.733 2.59 4.733 5.315 0 2.955-2.395 5.35-5.35 5.35h-2.691c-0.491 0-0.889 0.398-0.889 0.889s0.398 0.889 0.889 0.889h2.691c3.937 0 7.128-3.191 7.128-7.128 0-3.46-2.477-6.382-5.807-7.006-1.637-3.262-4.987-5.383-8.725-5.383z"></path>
                  <path
                      d="M20.534 16.557h-3.824c-0.239 0-0.4-0.241-0.309-0.462l2.386-5.841c0.080-0.192-0.172-0.346-0.307-0.189l-7.551 8.736c-0.12 0.141-0.021 0.359 0.164 0.359h3.553c0.239 0 0.401 0.242 0.309 0.463l-2.7 6.493c-0.081 0.192 0.171 0.348 0.307 0.19l8.136-9.391c0.12-0.14 0.021-0.359-0.164-0.359z"></path>
              </symbol>
              <symbol id="icon-users-fill" viewBox="0 0 32 32">
                  <title>icon-users-fill</title>
                  <path
                      d="M16 18.531c4.432 0 7.435 2.187 8.071 5.732-2.082 2.034-4.928 3.292-8.071 3.292s-5.988-1.259-8.071-3.292c0.635-3.547 3.639-5.732 8.071-5.732zM16 6.794c2.535 0 4.597 2.064 4.597 4.599s-2.062 4.597-4.597 4.597c-2.535 0-4.597-2.062-4.597-4.597s2.062-4.599 4.597-4.599zM16 1.777c-7.854 0-14.222 6.368-14.222 14.222s6.368 14.222 14.222 14.222c7.854 0 14.222-6.368 14.222-14.222s-6.368-14.222-14.222-14.222z"></path>
              </symbol>
              <symbol id="icon-users" viewBox="0 0 32 32">
                  <title>icon-users</title>
                  <path
                      d="M18.875 11.393c0-1.558-1.263-2.82-2.82-2.82s-2.82 1.263-2.82 2.82c0 1.558 1.263 2.82 2.82 2.82s2.82-1.263 2.82-2.82zM18.875 11.393c0-0.491 0.398-0.889 0.889-0.889s0.889 0.398 0.889 0.889c0 2.54-2.059 4.598-4.598 4.598s-4.598-2.059-4.598-4.598c0-2.54 2.059-4.598 4.598-4.598s4.598 2.059 4.598 4.598c0 0.491-0.398 0.889-0.889 0.889s-0.889-0.398-0.889-0.889z"></path>
                  <path
                      d="M9.48 26.969l0.146-1.827c0.245-3.067 2.722-4.833 6.428-4.833s6.183 1.767 6.428 4.833l0.14 1.744c0.039 0.489 0.468 0.854 0.957 0.815s0.854-0.468 0.815-0.957l-0.14-1.744c-0.328-4.101-3.648-6.469-8.2-6.469s-7.872 2.368-8.2 6.469l-0.146 1.827c-0.039 0.489 0.326 0.918 0.815 0.957s0.918-0.326 0.957-0.815z"></path>
                  <path
                      d="M16.055 30.222c-7.855 0-14.222-6.367-14.222-14.222s6.367-14.222 14.222-14.222c7.855 0 14.222 6.367 14.222 14.222s-6.367 14.222-14.222 14.222zM16.055 28.444c6.873 0 12.444-5.572 12.444-12.444s-5.572-12.444-12.444-12.444c-6.873 0-12.444 5.572-12.444 12.444s5.572 12.444 12.444 12.444z"></path>
              </symbol>
              <symbol id="icon-activity" viewBox="0 0 32 32">
                <title>icon-activity</title>
                <path
                  d="M27.727 14.418c0.881 0 1.606 0.675 1.606 1.566 0 0.885-0.721 1.606-1.606 1.606h-5.944c-0.552 0-1.042-0.256-1.351-0.719l-2.496-3.744-3.574 9.744c-0.173 0.606-0.725 1.020-1.455 1.105-0.652 0-1.157-0.315-1.47-0.863l-2.985-5.523h-4.18c-0.885 0-1.606-0.721-1.606-1.606s0.721-1.606 1.606-1.606h5.141c0.614 0 1.179 0.362 1.432 0.867l1.725 3.234 3.421-9.342c0.169-0.591 0.707-1.012 1.301-1.097 0.592-0.085 1.214 0.215 1.545 0.711l3.778 5.666h5.112z"></path>
              </symbol>
              <symbol id="icon-content" viewBox="0 0 32 32">
                <title>icon-content</title>
                <path d="M2.944 27.228h26.133v-22.456h-26.133v22.456zM1.788 2.461h28.444c0.638 0 1.156 0.517 1.156 1.156v24.767c0 0.638-0.517 1.156-1.156 1.156h-28.444c-0.638 0-1.156-0.517-1.156-1.156v-24.767c0-0.638 0.517-1.156 1.156-1.156z"></path>
                <path d="M0.898 11.246h30.226v-2.311h-30.226z"></path>
                <path
                  d="M13.629 17.334h10.81c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156h-10.81c-0.638 0-1.156 0.517-1.156 1.156s0.517 1.156 1.156 1.156zM13.629 23.464h10.81c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156h-10.81c-0.638 0-1.156 0.517-1.156 1.156s0.517 1.156 1.156 1.156zM7.208 17.334h1.233c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156h-1.233c-0.638 0-1.156 0.517-1.156 1.156s0.517 1.156 1.156 1.156zM7.208 23.464h1.233c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156h-1.233c-0.638 0-1.156 0.517-1.156 1.156s0.517 1.156 1.156 1.156z"></path>
              </symbol>
              <symbol id="icon-configuration" viewBox="0 0 32 32">
                <title>icon-configuration</title>
                <path
                  d="M26.193 15.906c0-5.66-4.588-10.249-10.249-10.249s-10.249 4.588-10.249 10.249 4.589 10.249 10.249 10.249c5.66 0 10.249-4.588 10.249-10.249zM28.504 15.906c0 6.937-5.623 12.56-12.56 12.56s-12.56-5.623-12.56-12.56 5.623-12.56 12.56-12.56c6.937 0 12.56 5.623 12.56 12.56z"></path>
                <path
                  d="M18.942 15.906c0-1.656-1.342-2.998-2.998-2.998s-2.998 1.342-2.998 2.998 1.342 2.998 2.998 2.998c1.656 0 2.998-1.342 2.998-2.998zM21.253 15.906c0 2.932-2.377 5.309-5.309 5.309s-5.309-2.377-5.309-5.309 2.377-5.309 5.309-5.309c2.932 0 5.309 2.377 5.309 5.309z"></path>
                <path d="M13.899 26.201v5.234h4.089v-5.234z"></path>
                <path d="M13.899 0.377v5.246h4.089v-5.246z"></path>
                <path d="M5.65 13.676h-5.234v4.089h5.234z"></path>
                <path d="M31.472 13.676h-5.244v4.089h5.244z"></path>
                <path d="M21.78 24.633l3.7 3.7 2.891-2.891-3.7-3.7z"></path>
                <path d="M3.518 6.372l3.703 3.703 2.891-2.891-3.703-3.703z"></path>
                <path d="M7.214 21.746l-3.696 3.696 2.891 2.891 3.696-3.696z"></path>
                <path d="M25.479 3.481l-3.707 3.707 2.891 2.891 3.707-3.707z"></path>
              </symbol>
              <symbol id="icon-summary" viewBox="0 0 32 32">
                <title>icon-summary</title>
                <path d="M3.827 28.173h24.356v-24.356h-24.356v24.356zM2.671 1.506h26.667c0.638 0 1.156 0.517 1.156 1.156v26.667c0 0.638-0.517 1.156-1.156 1.156h-26.667c-0.638 0-1.156-0.517-1.156-1.156v-26.667c0-0.638 0.517-1.156 1.156-1.156z"></path>
                <path d="M30.265 14.487h-21.479v2.311h21.479z"></path>
                <path d="M29.099 9.989c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156h-20.313c-0.638 0-1.156 0.517-1.156 1.156v19.654c0 0.638 0.517 1.156 1.156 1.156s1.156-0.517 1.156-1.156v-18.499h19.157z"></path>
                <path d="M30.265 21.298h-21.479v2.311h21.479z"></path>
                <path d="M17.984 8.206v21.028h2.311v-21.028z"></path>]
              </symbol>
              <symbol id="icon-alert" viewBox="0 0 32 32">
                  <title>icon-alert</title>
                  <path d="M16 29.6c-7.511 0-13.6-6.089-13.6-13.6s6.089-13.6 13.6-13.6c7.511 0 13.6 6.089 13.6 13.6s-6.089 13.6-13.6 13.6zM16 27.289c6.235 0 11.289-5.054 11.289-11.289s-5.054-11.289-11.289-11.289c-6.235 0-11.289 5.054-11.289 11.289s5.054 11.289 11.289 11.289z"></path>
                  <path d="M14.667 8.337v9.479c0 0.736 0.597 1.333 1.333 1.333s1.333-0.597 1.333-1.333v-9.479c0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333zM14.489 22.607v0.561c0 0.835 0.677 1.511 1.511 1.511s1.511-0.677 1.511-1.511v-0.561c0-0.835-0.677-1.511-1.511-1.511s-1.511 0.677-1.511 1.511z"></path>
              </symbol>
              <symbol id="icon-shield" viewBox="0 0 19 19">
                <title>icon-shield</title>
                <path d="M18.5766344,0 C18.5766344,0 14.1772629,1.0139137 9.45141113,1.0139137 C4.72555939,1.0139137 0.326187856,0 0.326187856,0 C-1.09329132,10.8488766 2.15123251,15.8170537 9.45141113,18.4532293 C16.7515898,15.8170537 19.9961136,10.8488766 18.5766344,0"></path>
              </symbol>
              <symbol id="icon-changecontext" viewBox="0 0 32 32">
                <title>icon-changecontext</title>
                <path d="M25.187 6.715c0.148 3.016 0.156 6.215-0.065 9.199-0.469 6.33-1.906 10.054-4.006 10.054-1.941 0-2.883-2.612-4.020-10.142l-0.015-0.1c-1.367-9.054-2.42-12.007-6.197-12.007-3.915 0-5.681 4.61-6.264 12.192-0.227 2.949-0.242 6.070-0.125 9.030l-1.97-1.97c-0.451-0.451-1.183-0.451-1.634 0s-0.451 1.183 0 1.634l4.061 4.061c0.451 0.451 1.183 0.451 1.634 0l4.061-4.061c0.451-0.451 0.451-1.183 0-1.634s-1.183-0.451-1.634 0l-2.195 2.195c-0.127-2.971-0.12-6.126 0.107-9.077 0.486-6.324 1.916-10.058 3.96-10.058 1.868 0 2.783 2.567 3.911 10.041l0.015 0.1c1.371 9.083 2.462 12.108 6.305 12.108 3.968 0 5.75-4.619 6.311-12.195 0.221-2.978 0.221-6.135 0.085-9.135l1.964 1.964c0.451 0.451 1.183 0.451 1.634 0s0.451-1.183 0-1.634l-4.061-4.061c-0.451-0.451-1.183-0.451-1.634 0l-4.061 4.061c-0.451 0.451-0.451 1.183 0 1.634s1.183 0.451 1.634 0l2.199-2.199z"></path>
              </symbol>
              <symbol id="icon-exit" viewBox="0 0 32 32">
                <title>icon-exit</title>
                <path d="M19.364 16.743h-13.293l3.304 3.303c0.451 0.451 0.451 1.183 0 1.634s-1.183 0.451-1.634 0l-5.281-5.279c-0.451-0.451-0.451-1.183-0-1.634l5.274-5.274c0.451-0.451 1.183-0.451 1.634 0s0.451 1.183 0 1.634l-3.304 3.304h13.298c1.541 0 1.541 2.311 0 2.311z"></path>
                <path d="M27.494 4.667v22.666h-12.084v-5.034c0-0.638-0.517-1.156-1.156-1.156s-1.156 0.517-1.156 1.156v6.19c0 0.638 0.517 1.156 1.156 1.156h14.395c0.638 0 1.156-0.517 1.156-1.156v-24.977c0-0.638-0.517-1.156-1.156-1.156h-14.395c-0.638 0-1.156 0.517-1.156 1.156v5.851c0 0.638 0.517 1.156 1.156 1.156s1.156-0.517 1.156-1.156v-4.695h12.084z"></path>
              </symbol>
              <symbol id="icon-search-controls-fill" viewBox="0 0 32 32">
                <title>icon-search-controls-fill</title>
                <path
                  d="M10.147 2.418h-3.556c-0.491 0-0.889 0.398-0.889 0.889v1.754h-3.533c-0.982 0-1.778 0.796-1.778 1.778s0.796 1.778 1.778 1.778h3.533v1.802c0 0.491 0.398 0.889 0.889 0.889h3.556c0.491 0 0.889-0.398 0.889-0.889v-1.802h18.777c0.982 0 1.778-0.796 1.778-1.778s-0.796-1.778-1.778-1.778h-18.777v-1.754c0-0.491-0.398-0.889-0.889-0.889zM26.413 18.384h3.327c0.982 0 1.778-0.796 1.778-1.778s-0.796-1.778-1.778-1.778h-3.327v-1.616c0-0.491-0.398-0.889-0.889-0.889h-3.556c-0.491 0-0.889 0.398-0.889 0.889v1.616h-18.863c-0.982 0-1.778 0.796-1.778 1.778s0.796 1.778 1.778 1.778h18.863v1.939c0 0.491 0.398 0.889 0.889 0.889h3.556c0.491 0 0.889-0.398 0.889-0.889v-1.939zM18.355 28.465h11.47c0.982 0 1.778-0.796 1.778-1.778s-0.796-1.778-1.778-1.778h-11.47v-1.917c0-0.491-0.398-0.889-0.889-0.889h-3.556c-0.491 0-0.889 0.398-0.889 0.889v1.917h-10.79c-0.982 0-1.778 0.796-1.778 1.778s0.796 1.778 1.778 1.778h10.79v1.639c0 0.491 0.398 0.889 0.889 0.889h3.556c0.491 0 0.889-0.398 0.889-0.889v-1.639z"></path>
              </symbol>
              <symbol id="icon-search-controls" viewBox="0 0 32 32">
                <title>icon-search-controls</title>
                <path
                  d="M9.445 8.023v1.932c0 0.638-0.517 1.156-1.156 1.156s-1.156-0.517-1.156-1.156v0-1.932h-5.445c-0.638 0-1.156-0.517-1.156-1.156s0.517-1.156 1.156-1.156v0h5.445v-1.92c0-0.638 0.517-1.156 1.156-1.156s1.156 0.517 1.156 1.156v1.92h20.617c0.638 0 1.156 0.517 1.156 1.156s-0.517 1.156-1.156 1.156h-20.617zM24.921 15.484v-1.794c0-0.638-0.517-1.156-1.156-1.156s-1.156 0.517-1.156 1.156v0 1.794h-20.921c-0.638 0-1.156 0.517-1.156 1.156s0.517 1.156 1.156 1.156v0h20.921v2.060c0 0.638 0.517 1.156 1.156 1.156s1.156-0.517 1.156-1.156v0-2.060h5.143c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156h-5.143zM17.031 25.516v-1.925c0-0.638-0.517-1.156-1.156-1.156s-1.156 0.517-1.156 1.156v0 1.925h-13.031c-0.638 0-1.156 0.517-1.156 1.156s0.517 1.156 1.156 1.156v0h13.031v1.927c0 0.638 0.517 1.156 1.156 1.156s1.156-0.517 1.156-1.156v0-1.927h13.033c0.638 0 1.156-0.517 1.156-1.156s-0.517-1.156-1.156-1.156v0h-13.031z"></path>
              </symbol>
              <symbol id="icon-home" viewBox="0 0 32 32">
                <title>icon-home</title>
                <path d="M10.2875 24.8356C10.1896 24.7994 10.0345 24.7087 9.94476 24.6315C9.81827 24.5272 5.11359 20.2456 1.00464 16.4947C0.625161 16.1545 0.274248 15.8007 0.221203 15.71C-0.0154592 15.3245 -0.00729847 15.6465 0.00494269 8.04031C0.0171838 1.40472 0.0212642 1.01012 0.0947112 0.837766C0.213042 0.561094 0.486428 0.257208 0.735332 0.130211L0.959753 0.0168212L10.4956 0.00321438C17.4935 -0.00585683 20.1008 0.00321438 20.313 0.0440348C20.7823 0.130211 21.1209 0.434097 21.2678 0.896728C21.325 1.07815 21.3331 1.96713 21.3331 8.1673C21.3331 15.8733 21.3494 15.3698 21.0965 15.7418C21.0393 15.8234 19.501 17.2521 17.6812 18.9076C15.8613 20.5676 13.7069 22.5316 12.8949 23.2754C12.0788 24.0147 11.3362 24.6769 11.2342 24.7404C11.0097 24.8901 10.5609 24.9354 10.2875 24.8356ZM14.8208 18.0731L18.9339 14.313V8.51201V2.71097H10.667H2.39605V8.51201V14.313L5.20743 16.8802C6.7539 18.2908 8.61048 19.9871 9.3327 20.6493C10.0549 21.3069 10.6588 21.8421 10.6752 21.8376C10.6915 21.8331 12.5562 20.1368 14.8208 18.0731Z" transform="translate(5.33331 28.4445) scale(1 -1)"/>
              </symbol>
          </defs>
      </svg>
    }
  end
end
