# frozen_string_literal: true
class Views::Doorkeeper::Authorizations::New < ::Views::Base
  needs(:pre_auth)

  def content
    widget(Views::FritoPie::Head::Login, :view_title => 'Workplace Search', :no_referrer => true)
    widget(Views::FritoPie::AuthBody, :view_title => 'Workplace Search') do
      header(:class => 'auth-container__header euiTextAlign euiTextAlign--center') do
        h2(t('.title'), :class => 'euiTitle euiTitle--medium')
      end
      div(:class => 'euiSpacer euiSpacer--l')
      div(:class => 'euiText euiText--medium') do
        div(:class => 'euiTextAlign euiTextAlign--center') do
          p do
            rawtext t('.prompt', client_name: capture { strong(pre_auth.client.name) })
          end
        end
      end

      if http_redirect_uri?
        div(:class => 'euiCallOut euiCallOut--small euiCallOut--danger') do
          div(:class => 'euiCallOutHeader') do
            eui_icon(:close, :class => 'euiIcon euiIcon--medium euiCallOutHeader__icon')
            span(t('.http_redirect_uri'), :class => 'euiCallOutHeader__title')
          end
        end
        div(:class => 'euiSpacer euiSpacer--l')
      end

      if pre_auth.scopes.count > 0
        div(:class => 'euiCallOut euiCallOut--primary') do
          div(:class => 'euiCallOutHeader') do
            eui_icon(:information, :class => 'euiIcon euiIcon--medium euiCallOutHeader__icon')
            span(t('.able_to'), :class => 'euiCallOutHeader__title')
          end
          div(:class => 'euiText euiText--small') do
            ul do
              pre_auth.scopes.each do |scope|
                li t(scope, scope: [:doorkeeper, :scopes])
              end
            end
          end
        end
        div(:class => 'euiSpacer euiSpacer--l')
      end

      div(:class => 'euiFlexGroup euiFlexGroup--gutterMedium') do
        form_tag oauth_authorization_path, method: :delete, class: 'euiFlexItem' do
          hidden_field_tag :client_id, pre_auth.client.uid
          hidden_field_tag :redirect_uri, pre_auth.redirect_uri
          hidden_field_tag :state, pre_auth.state
          hidden_field_tag :response_type, pre_auth.response_type
          hidden_field_tag :scope, pre_auth.scope
          button(:class => 'euiButton euiButton--danger') do
            span(:class => 'euiButtonContent euiButton__content') do
              span(t('doorkeeper.authorizations.buttons.deny'), :class => 'euiButton__text')
            end
          end
        end
        form_tag oauth_authorization_path, method: :post, class: 'euiFlexItem' do
          hidden_field_tag :client_id, pre_auth.client.uid
          hidden_field_tag :redirect_uri, pre_auth.redirect_uri
          hidden_field_tag :state, pre_auth.state
          hidden_field_tag :response_type, pre_auth.response_type
          hidden_field_tag :scope, pre_auth.scope
          button(:class => 'euiButton euiButton--primary euiButton--fill') do
            span(:class => 'euiButtonContent euiButton__content') do
              span(t('doorkeeper.authorizations.buttons.authorize'), :class => 'euiButton__text')
            end
          end
        end
      end
    end
  end

  private

  def http_redirect_uri?
    URI.parse(pre_auth.redirect_uri).scheme == 'http'
  rescue URI::InvalidURIError
    false
  end
end
