/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.ext;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Rack::Handler::Servlet"})
public class Servlet
extends RubyObject {
    static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Servlet(runtime, klass);
        }
    };
    protected IRubyObject app;

    protected Servlet(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(IRubyObject app) {
        if (app.isNil()) {
            throw this.getRuntime().newArgumentError("rack app not found, make sure the rackup file path is correct");
        }
        this.app = app;
        return this;
    }

    @JRubyMethod(name={"get_app"}, alias={"app"})
    public IRubyObject get_app() {
        return this.app;
    }

    @JRubyMethod(required=1)
    public IRubyObject call(ThreadContext context, IRubyObject servlet_env) {
        IRubyObject env = this.callMethod(context, "create_env", servlet_env);
        IRubyObject rack_response = this.app.callMethod(context, "call", env);
        IRubyObject responseClass = this.getMetaClass().callMethod(context, "response");
        return responseClass.callMethod(context, "new", rack_response);
    }

    @JRubyMethod(required=1)
    public RubyHash create_env(ThreadContext context, IRubyObject servlet_env) {
        IRubyObject env = this.getMetaClass().callMethod(context, "env");
        return env.callMethod(context, "create", servlet_env).convertToHash();
    }
}

