/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class Privilege {
    public static final Privilege NONE = new Privilege(Collections.singleton("none"), Automatons.EMPTY);
    public static final Privilege ALL = new Privilege(Collections.singleton("all"), Automatons.MATCH_ALL);
    protected final Set<String> name;
    protected final Automaton automaton;
    protected final Predicate<String> predicate;
    protected final Supplier<Boolean> grantsAll;

    public Privilege(String name, String ... patterns) {
        this(Collections.singleton(name), patterns);
    }

    public Privilege(Set<String> name, String ... patterns) {
        this(name, Automatons.patterns(patterns));
    }

    public Privilege(Set<String> name, Automaton automaton) {
        this.name = name;
        this.automaton = automaton;
        this.predicate = Automatons.predicate(automaton);
        this.grantsAll = CachedSupplier.wrap(() -> Operations.isTotal((Automaton)automaton));
    }

    public Set<String> name() {
        return this.name;
    }

    public Predicate<String> predicate() {
        return this.predicate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return Objects.equals(this.name, privilege.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    static String actionToPattern(String text) {
        return text + "*";
    }

    public String toString() {
        return this.name.toString();
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public boolean grantsAll() {
        return this.grantsAll.get();
    }

    public static <T extends Privilege> SortedMap<String, T> sortByAccessLevel(Map<String, T> privileges) {
        Map subsetCount = Maps.newMapWithExpectedSize((int)privileges.size());
        privileges.forEach((name, priv) -> subsetCount.put(name, privileges.values().stream().filter(p2 -> p2 != priv && Operations.subsetOf((Automaton)priv.automaton, (Automaton)p2.automaton)).count()));
        Comparator<String> compare = Comparator.comparingLong(key -> subsetCount.getOrDefault(key, 0L)).reversed().thenComparing(Comparator.naturalOrder());
        TreeMap<String, T> tree = new TreeMap<String, T>(compare);
        tree.putAll(privileges);
        return Collections.unmodifiableSortedMap(tree);
    }
}

