/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.Collection;
import java.util.LongSummaryStatistics;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datastreams.DataStreamLifecycleFeatureSetUsage;

public class DataStreamLifecycleUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;

    @Inject
    public DataStreamLifecycleUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        super(XPackUsageFeatureAction.DATA_STREAM_LIFECYCLE.name(), transportService, clusterService, threadPool, actionFilters);
        this.globalRetentionSettings = globalRetentionSettings;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Collection<DataStream> dataStreams = state.metadata().dataStreams().values();
        DataStreamLifecycleFeatureSetUsage.LifecycleStats lifecycleStats = DataStreamLifecycleUsageTransportAction.calculateStats(dataStreams, (RolloverConfiguration)this.clusterService.getClusterSettings().get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING), this.globalRetentionSettings.get());
        listener.onResponse((Object)new XPackUsageFeatureResponse(new DataStreamLifecycleFeatureSetUsage(lifecycleStats)));
    }

    public static DataStreamLifecycleFeatureSetUsage.LifecycleStats calculateStats(Collection<DataStream> dataStreams, RolloverConfiguration rolloverConfiguration, DataStreamGlobalRetention globalRetention) {
        long dataStreamsWithLifecycles = 0L;
        long dataStreamsWithDefaultRetention = 0L;
        long dataStreamsWithMaxRetention = 0L;
        LongSummaryStatistics dataRetentionStats = new LongSummaryStatistics();
        LongSummaryStatistics effectiveRetentionStats = new LongSummaryStatistics();
        for (DataStream dataStream : dataStreams) {
            Tuple effectiveDataRetentionWithSource;
            if (dataStream.getDataLifecycle() == null || !dataStream.getDataLifecycle().enabled()) continue;
            ++dataStreamsWithLifecycles;
            if (dataStream.getDataLifecycle().dataRetention() != null) {
                dataRetentionStats.accept(dataStream.getDataLifecycle().dataRetention().getMillis());
            }
            if ((effectiveDataRetentionWithSource = dataStream.getDataLifecycle().getEffectiveDataRetentionWithSource(globalRetention, dataStream.isInternal())).v1() == null) continue;
            effectiveRetentionStats.accept(((TimeValue)effectiveDataRetentionWithSource.v1()).getMillis());
            if (((DataStreamLifecycle.RetentionSource)effectiveDataRetentionWithSource.v2()).equals((Object)DataStreamLifecycle.RetentionSource.DEFAULT_GLOBAL_RETENTION)) {
                ++dataStreamsWithDefaultRetention;
            }
            if (!((DataStreamLifecycle.RetentionSource)effectiveDataRetentionWithSource.v2()).equals((Object)DataStreamLifecycle.RetentionSource.MAX_GLOBAL_RETENTION)) continue;
            ++dataStreamsWithMaxRetention;
        }
        Map<String, DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats> globalRetentionStats = DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats.getGlobalRetentionStats(globalRetention, dataStreamsWithDefaultRetention, dataStreamsWithMaxRetention);
        return new DataStreamLifecycleFeatureSetUsage.LifecycleStats(dataStreamsWithLifecycles, ((RolloverConfiguration)DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING.getDefault(null)).equals((Object)rolloverConfiguration), DataStreamLifecycleFeatureSetUsage.RetentionStats.create(dataRetentionStats), DataStreamLifecycleFeatureSetUsage.RetentionStats.create(effectiveRetentionStats), globalRetentionStats);
    }
}

