/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.BlockLoaderTestCase;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TestBlock;
import org.elasticsearch.plugins.internal.XContentMeteringParserDecorator;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class BlockLoaderTestRunner {
    private final BlockLoaderTestCase.Params params;

    public BlockLoaderTestRunner(BlockLoaderTestCase.Params params) {
        this.params = params;
    }

    public void runTest(MapperService mapperService, Map<String, Object> document, Object expected, String blockLoaderFieldName) throws IOException {
        XContentBuilder documentXContent = XContentBuilder.builder((XContent)XContentType.JSON.xContent()).map(document);
        Object blockLoaderResult = this.setupAndInvokeBlockLoader(mapperService, documentXContent, blockLoaderFieldName);
        MatcherAssert.assertThat((Object)blockLoaderResult, PrettyEqual.prettyEqualTo(expected));
    }

    private Object setupAndInvokeBlockLoader(MapperService mapperService, XContentBuilder document, String fieldName) throws IOException {
        try (BaseDirectoryWrapper directory = LuceneTestCase.newDirectory();){
            Object object;
            block12: {
                RandomIndexWriter iw = new RandomIndexWriter(LuceneTestCase.random(), (Directory)directory);
                SourceToParse source = new SourceToParse("1", BytesReference.bytes((XContentBuilder)document), XContentType.JSON, null, Map.of(), true, XContentMeteringParserDecorator.NOOP);
                LuceneDocument doc = mapperService.documentMapper().parse(source).rootDoc();
                iw.addDocuments(List.of(List.of(), doc, List.of()));
                iw.close();
                DirectoryReader reader = DirectoryReader.open((Directory)directory);
                try {
                    LeafReaderContext context = (LeafReaderContext)reader.leaves().get(0);
                    object = this.load(this.createBlockLoader(mapperService, fieldName), context, mapperService);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return object;
        }
    }

    private Object load(BlockLoader blockLoader, LeafReaderContext context, MapperService mapperService) throws IOException {
        BlockLoader.ColumnAtATimeReader columnAtATimeReader = blockLoader.columnAtATimeReader(context);
        if (columnAtATimeReader != null) {
            int offset;
            int[] docArray;
            if (ESTestCase.randomBoolean()) {
                docArray = new int[]{1};
                offset = 0;
            } else {
                docArray = new int[ESTestCase.between(2, 10)];
                offset = ESTestCase.between(0, docArray.length - 1);
                for (int i = 0; i < docArray.length; ++i) {
                    docArray[i] = i < offset ? 0 : (i == offset ? 1 : 2);
                }
            }
            BlockLoader.Docs docs = TestBlock.docs(docArray);
            TestBlock block = (TestBlock)columnAtATimeReader.read(TestBlock.factory(), docs, offset);
            MatcherAssert.assertThat((Object)block.size(), (Matcher)Matchers.equalTo((Object)(docArray.length - offset)));
            return block.get(0);
        }
        StoredFieldsSpec storedFieldsSpec = blockLoader.rowStrideStoredFieldSpec();
        SourceLoader.Leaf leafSourceLoader = null;
        if (storedFieldsSpec.requiresSource()) {
            SourceLoader sourceLoader = mapperService.mappingLookup().newSourceLoader(null, SourceFieldMetrics.NOOP);
            leafSourceLoader = sourceLoader.leaf(context.reader(), null);
            storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(true, storedFieldsSpec.requiresMetadata(), sourceLoader.requiredStoredFields()));
        }
        BlockLoaderStoredFieldsFromLeafLoader storedFieldsLoader = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec).getLoader(context, null), leafSourceLoader);
        storedFieldsLoader.advanceTo(1);
        BlockLoader.Builder builder = blockLoader.builder(TestBlock.factory(), 1);
        blockLoader.rowStrideReader(context).read(1, (BlockLoader.StoredFields)storedFieldsLoader, builder);
        TestBlock block = (TestBlock)builder.build();
        MatcherAssert.assertThat((Object)block.size(), (Matcher)Matchers.equalTo((Object)1));
        return block.get(0);
    }

    private BlockLoader createBlockLoader(final MapperService mapperService, String fieldName) {
        final SearchLookup searchLookup = new SearchLookup(arg_0 -> ((FieldTypeLookup)mapperService.mappingLookup().fieldTypesLookup()).get(arg_0), null, null);
        return mapperService.fieldType(fieldName).blockLoader(new MappedFieldType.BlockLoaderContext(){

            public String indexName() {
                return mapperService.getIndexSettings().getIndex().getName();
            }

            public IndexSettings indexSettings() {
                return mapperService.getIndexSettings();
            }

            public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
                return BlockLoaderTestRunner.this.params.preference();
            }

            public SearchLookup lookup() {
                return searchLookup;
            }

            public Set<String> sourcePaths(String name) {
                return mapperService.mappingLookup().sourcePaths(name);
            }

            public String parentField(String field) {
                return mapperService.mappingLookup().parentField(field);
            }

            public FieldNamesFieldMapper.FieldNamesFieldType fieldNames() {
                return (FieldNamesFieldMapper.FieldNamesFieldType)mapperService.fieldType("_field_names");
            }
        });
    }

    static class PrettyEqual<T>
    extends BaseMatcher<T> {
        private final Object expectedValue;

        PrettyEqual(T equalArg) {
            this.expectedValue = equalArg;
        }

        public boolean matches(Object actualValue) {
            return PrettyEqual.areEqual(actualValue, this.expectedValue);
        }

        public void describeTo(Description description) {
            description.appendValue(PrettyEqual.attemptMakeReadable(this.expectedValue));
        }

        public void describeMismatch(Object item, Description description) {
            super.describeMismatch(PrettyEqual.attemptMakeReadable(item), description);
        }

        private static boolean areEqual(Object actual, Object expected) {
            if (actual == null) {
                return expected == null;
            }
            if (expected != null && PrettyEqual.isArray(actual)) {
                return PrettyEqual.isArray(expected) && PrettyEqual.areArraysEqual(actual, expected);
            }
            return actual.equals(expected);
        }

        private static boolean areArraysEqual(Object actualArray, Object expectedArray) {
            return PrettyEqual.areArrayLengthsEqual(actualArray, expectedArray) && PrettyEqual.areArrayElementsEqual(actualArray, expectedArray);
        }

        private static boolean areArrayLengthsEqual(Object actualArray, Object expectedArray) {
            return Array.getLength(actualArray) == Array.getLength(expectedArray);
        }

        private static boolean areArrayElementsEqual(Object actualArray, Object expectedArray) {
            for (int i = 0; i < Array.getLength(actualArray); ++i) {
                if (PrettyEqual.areEqual(Array.get(actualArray, i), Array.get(expectedArray, i))) continue;
                return false;
            }
            return true;
        }

        private static boolean isArray(Object o) {
            return o.getClass().isArray();
        }

        static Object attemptMakeReadable(Object expected) {
            try {
                List list;
                if (expected instanceof BytesRef) {
                    BytesRef bytesRef = (BytesRef)expected;
                    expected = bytesRef.utf8ToString();
                } else if (expected instanceof List && !(list = (List)expected).isEmpty() && list.get(0) instanceof BytesRef) {
                    ArrayList<String> expectedList = new ArrayList<String>(list.size());
                    for (Object e : list) {
                        expectedList.add(((BytesRef)e).utf8ToString());
                    }
                    expected = expectedList;
                }
                return expected;
            }
            catch (AssertionError | Exception e) {
                return expected;
            }
        }

        public static <T> Matcher<T> prettyEqualTo(T operand) {
            return new PrettyEqual<T>(operand);
        }
    }
}

