/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers;

import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datageneration.matchers.ArrayEqualMatcher;
import org.elasticsearch.datageneration.matchers.ListEqualMatcher;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.Matcher;
import org.elasticsearch.datageneration.matchers.Messages;
import org.elasticsearch.datageneration.matchers.ObjectMatcher;
import org.elasticsearch.xcontent.XContentBuilder;

public class GenericEqualsMatcher<T>
extends Matcher {
    protected final XContentBuilder actualMappings;
    protected final Settings.Builder actualSettings;
    protected final XContentBuilder expectedMappings;
    protected final Settings.Builder expectedSettings;
    protected final T actual;
    protected final T expected;
    protected final boolean ignoringSort;

    protected GenericEqualsMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings, T actual, T expected, boolean ignoringSort) {
        this.actualMappings = actualMappings;
        this.actualSettings = actualSettings;
        this.expectedMappings = expectedMappings;
        this.expectedSettings = expectedSettings;
        this.actual = actual;
        this.expected = expected;
        this.ignoringSort = ignoringSort;
    }

    public MatchResult match() {
        if (this.actual == null) {
            if (this.expected == null) {
                return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Both 'actual' and 'expected' are null"));
            }
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Expected is null but actual is not"));
        }
        if (this.expected == null) {
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Actual is null but expected is not"));
        }
        if (!this.actual.getClass().equals(this.expected.getClass())) {
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Unable to match " + this.actual.getClass().getSimpleName() + " to " + this.expected.getClass().getSimpleName()));
        }
        if (this.actual.getClass().isArray()) {
            return new ArrayEqualMatcher(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, (Object[])this.actual, (Object[])this.expected, this.ignoringSort).match();
        }
        T t = this.actual;
        if (t instanceof List) {
            List act = (List)t;
            t = this.expected;
            if (t instanceof List) {
                List exp = (List)t;
                return new ListEqualMatcher(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, act, exp, this.ignoringSort).match();
            }
        }
        return new ObjectMatcher(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, this.actual, this.expected).match();
    }
}

