/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.Features;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.Prerequisites;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.junit.AssumptionViolatedException;

public class PrerequisiteSection {
    public static final PrerequisiteSection EMPTY = new PrerequisiteSection();
    private final List<Predicate<ClientYamlTestExecutionContext>> skipCriteriaList;
    private final List<Predicate<ClientYamlTestExecutionContext>> requiresCriteriaList;
    private final List<String> yamlRunnerFeatures;
    final String skipReason;
    final String requireReason;

    public static PrerequisiteSection parseIfNext(XContentParser parser) throws IOException {
        return PrerequisiteSection.parseInternal(parser).build();
    }

    private static void maybeAdvanceToNextField(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null && token != XContentParser.Token.END_ARRAY) {
            ParserUtils.advanceToFieldName(parser);
        }
    }

    static PrerequisiteSectionBuilder parseInternal(XContentParser parser) throws IOException {
        PrerequisiteSectionBuilder builder = new PrerequisiteSectionBuilder();
        boolean hasPrerequisiteSection = false;
        boolean unknownFieldName = false;
        ParserUtils.advanceToFieldName(parser);
        while (!unknownFieldName) {
            if ("skip".equals(parser.currentName())) {
                PrerequisiteSection.parseSkipSection(parser, builder);
                hasPrerequisiteSection = true;
                PrerequisiteSection.maybeAdvanceToNextField(parser);
                continue;
            }
            if ("requires".equals(parser.currentName())) {
                PrerequisiteSection.parseRequiresSection(parser, builder);
                hasPrerequisiteSection = true;
                PrerequisiteSection.maybeAdvanceToNextField(parser);
                continue;
            }
            unknownFieldName = true;
        }
        if (hasPrerequisiteSection) {
            builder.validate(parser.getTokenLocation());
        }
        return builder;
    }

    private static void parseFeatureField(String feature, PrerequisiteSectionBuilder builder) {
        if (feature.equals("xpack")) {
            builder.requireXPack();
        } else if (feature.equals("no_xpack")) {
            builder.skipIfXPack();
        } else {
            builder.requireYamlRunnerFeature(feature);
        }
    }

    static void parseSkipSection(XContentParser parser, PrerequisiteSectionBuilder builder) throws IOException {
        PrerequisiteSection.requireStartObject("skip", parser.nextToken());
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) continue;
            boolean valid = false;
            if (parser.currentToken().isValue()) {
                valid = switch (parser.currentName()) {
                    case "version" -> PrerequisiteSection.parseRestCompatVersion(parser, builder);
                    case "reason" -> PrerequisiteSection.parseString(parser, builder::setSkipReason);
                    case "features" -> PrerequisiteSection.parseString(parser, f -> PrerequisiteSection.parseFeatureField(f, builder));
                    case "os" -> PrerequisiteSection.parseString(parser, builder::skipIfOs);
                    case "cluster_features" -> PrerequisiteSection.parseString(parser, builder::skipIfClusterFeature);
                    case "awaits_fix" -> PrerequisiteSection.parseString(parser, builder::skipIfAwaitsFix);
                    default -> false;
                };
            } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                switch (parser.currentName()) {
                    case "features": {
                        boolean bl = PrerequisiteSection.parseStrings(parser, f -> PrerequisiteSection.parseFeatureField(f, builder));
                        break;
                    }
                    case "os": {
                        boolean bl = PrerequisiteSection.parseStrings(parser, builder::skipIfOs);
                        break;
                    }
                    case "cluster_features": {
                        boolean bl = PrerequisiteSection.parseStrings(parser, builder::skipIfClusterFeature);
                        break;
                    }
                    case "known_issues": {
                        boolean bl = PrerequisiteSection.parseArray(parser, PrerequisiteSection::parseKnownIssue, builder::skipKnownIssue);
                        break;
                    }
                    case "capabilities": {
                        boolean bl = PrerequisiteSection.parseArray(parser, PrerequisiteSection::parseCapabilities, builder::skipIfCapabilities);
                        break;
                    }
                    default: {
                        boolean bl = valid = false;
                    }
                }
            }
            if (valid) continue;
            PrerequisiteSection.throwUnexpectedField("skip", parser);
        }
        parser.nextToken();
    }

    private static boolean parseRestCompatVersion(XContentParser parser, PrerequisiteSectionBuilder builder) throws IOException {
        if ("true".equals(System.getProperty("tests.restCompat"))) {
            return PrerequisiteSection.parseString(parser, builder::skipIfVersion);
        }
        throw new IllegalArgumentException("Skipping by version is no longer supported, please skip based on cluster features. Please check the docs: \nhttps://github.com/elastic/elasticsearch/tree/main/rest-api-spec/src/yamlRestTest/resources/rest-api-spec/test#skipping-tests");
    }

    private static void throwUnexpectedField(String section, XContentParser parser) throws IOException {
        throw new ParsingException(parser.getTokenLocation(), Strings.format((String)"field [%s] of type [%s] not supported within %s section", (Object[])new Object[]{parser.currentName(), parser.currentToken(), section}), new Object[0]);
    }

    private static void requireStartObject(String section, XContentParser.Token token) throws IOException {
        if (token != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException(Strings.format((String)"Expected [%s], found [%s], the %s section is not properly indented", (Object[])new Object[]{XContentParser.Token.START_OBJECT, token, section}));
        }
    }

    private static boolean parseString(XContentParser parser, Consumer<String> consumer) throws IOException {
        consumer.accept(parser.text());
        return true;
    }

    private static boolean parseStrings(XContentParser parser, Consumer<String> consumer) throws IOException {
        return PrerequisiteSection.parseArray(parser, XContentParser::text, consumer);
    }

    private static <T> boolean parseArray(XContentParser parser, CheckedFunction<XContentParser, T, IOException> item, Consumer<T> consumer) throws IOException {
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            consumer.accept(item.apply((Object)parser));
        }
        return true;
    }

    private static KnownIssue parseKnownIssue(XContentParser parser) throws IOException {
        Map fields = parser.mapStrings();
        if (!fields.keySet().equals(KnownIssue.FIELD_NAMES)) {
            throw new ParsingException(parser.getTokenLocation(), Strings.format((String)"Expected all of %s, but got %s", (Object[])new Object[]{KnownIssue.FIELD_NAMES, fields.keySet()}), new Object[0]);
        }
        return new KnownIssue((String)fields.get("cluster_feature"), (String)fields.get("fixed_by"));
    }

    private static CapabilitiesCheck parseCapabilities(XContentParser parser) throws IOException {
        Map fields = parser.map();
        if (!CapabilitiesCheck.FIELD_NAMES.containsAll(fields.keySet())) {
            throw new ParsingException(parser.getTokenLocation(), Strings.format((String)"Expected some of %s, but got %s", (Object[])new Object[]{CapabilitiesCheck.FIELD_NAMES, fields.keySet()}), new Object[0]);
        }
        Object path = fields.get("path");
        if (path == null) {
            throw new ParsingException(parser.getTokenLocation(), "path is required", new Object[0]);
        }
        return new CapabilitiesCheck(PrerequisiteSection.ensureString(PrerequisiteSection.ensureString(fields.getOrDefault("method", "GET"))), PrerequisiteSection.ensureString(path), PrerequisiteSection.stringArrayAsParamString("parameters", fields), PrerequisiteSection.stringArrayAsParamString("capabilities", fields));
    }

    private static String ensureString(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str;
        }
        throw new IllegalArgumentException("Expected STRING, but got: " + String.valueOf(obj));
    }

    private static String stringArrayAsParamString(String name, Map<String, Object> fields) {
        Object value = fields.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            return values.stream().map(PrerequisiteSection::ensureString).collect(Collectors.joining(","));
        }
        return PrerequisiteSection.ensureString(value);
    }

    static void parseRequiresSection(XContentParser parser, PrerequisiteSectionBuilder builder) throws IOException {
        PrerequisiteSection.requireStartObject("requires", parser.nextToken());
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) continue;
            boolean valid = false;
            if (parser.currentToken().isValue()) {
                valid = switch (parser.currentName()) {
                    case "reason" -> PrerequisiteSection.parseString(parser, builder::setRequiresReason);
                    case "test_runner_features" -> PrerequisiteSection.parseString(parser, f -> PrerequisiteSection.parseFeatureField(f, builder));
                    case "cluster_features" -> PrerequisiteSection.parseString(parser, builder::requireClusterFeature);
                    default -> false;
                };
            } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                switch (parser.currentName()) {
                    case "test_runner_features": {
                        boolean bl = PrerequisiteSection.parseStrings(parser, f -> PrerequisiteSection.parseFeatureField(f, builder));
                        break;
                    }
                    case "cluster_features": {
                        boolean bl = PrerequisiteSection.parseStrings(parser, builder::requireClusterFeature);
                        break;
                    }
                    case "capabilities": {
                        boolean bl = PrerequisiteSection.parseArray(parser, PrerequisiteSection::parseCapabilities, builder::requireCapabilities);
                        break;
                    }
                    default: {
                        boolean bl = valid = false;
                    }
                }
            }
            if (valid) continue;
            PrerequisiteSection.throwUnexpectedField("requires", parser);
        }
        parser.nextToken();
    }

    private PrerequisiteSection() {
        this.skipCriteriaList = Collections.emptyList();
        this.requiresCriteriaList = Collections.emptyList();
        this.yamlRunnerFeatures = Collections.emptyList();
        this.skipReason = null;
        this.requireReason = null;
    }

    PrerequisiteSection(List<Predicate<ClientYamlTestExecutionContext>> skipCriteriaList, String skipReason, List<Predicate<ClientYamlTestExecutionContext>> requiresCriteriaList, String requireReason, List<String> yamlRunnerFeatures) {
        this.skipCriteriaList = skipCriteriaList;
        this.requiresCriteriaList = requiresCriteriaList;
        this.yamlRunnerFeatures = yamlRunnerFeatures;
        this.skipReason = skipReason;
        this.requireReason = requireReason;
    }

    public boolean hasYamlRunnerFeature(String feature) {
        return this.yamlRunnerFeatures.contains(feature);
    }

    boolean skipCriteriaMet(ClientYamlTestExecutionContext context) {
        return this.skipCriteriaList.stream().anyMatch(c -> c.test(context));
    }

    boolean requiresCriteriaMet(ClientYamlTestExecutionContext context) {
        return this.requiresCriteriaList.stream().allMatch(c -> c.test(context));
    }

    public void evaluate(ClientYamlTestExecutionContext context, String testCandidateDescription) {
        if (this.isEmpty()) {
            return;
        }
        if (!this.requiresCriteriaMet(context)) {
            throw new AssumptionViolatedException(this.buildMessage(testCandidateDescription, false));
        }
        if (this.skipCriteriaMet(context)) {
            throw new AssumptionViolatedException(this.buildMessage(testCandidateDescription, true));
        }
    }

    boolean isEmpty() {
        return this.skipCriteriaList.isEmpty() && this.requiresCriteriaList.isEmpty() && this.yamlRunnerFeatures.isEmpty();
    }

    String buildMessage(String description, boolean isSkip) {
        String reason;
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("[").append(description).append("] skipped,");
        String string = reason = isSkip ? this.skipReason : this.requireReason;
        if (!Strings.isNullOrEmpty((String)reason)) {
            messageBuilder.append(" reason: [").append(reason).append("]");
        }
        if (!this.yamlRunnerFeatures.isEmpty()) {
            messageBuilder.append(" unsupported features ").append(this.yamlRunnerFeatures);
        }
        return messageBuilder.toString();
    }

    boolean hasCapabilitiesCheck() {
        return Stream.concat(this.skipCriteriaList.stream(), this.requiresCriteriaList.stream()).anyMatch(p -> p instanceof Prerequisites.CapabilitiesPredicate);
    }

    static class PrerequisiteSectionBuilder {
        String skipReason = null;
        String skipVersionRange = null;
        List<String> skipOperatingSystems = new ArrayList<String>();
        List<KnownIssue> skipKnownIssues = new ArrayList<KnownIssue>();
        String skipAwaitsFix = null;
        Set<String> skipClusterFeatures = new HashSet<String>();
        List<CapabilitiesCheck> skipCapabilities = new ArrayList<CapabilitiesCheck>();
        String requiresReason = null;
        List<String> requiredYamlRunnerFeatures = new ArrayList<String>();
        Set<String> requiredClusterFeatures = new HashSet<String>();
        List<CapabilitiesCheck> requiredCapabilities = new ArrayList<CapabilitiesCheck>();
        XPackRequired xpackRequired = XPackRequired.NOT_SPECIFIED;

        PrerequisiteSectionBuilder() {
        }

        public PrerequisiteSectionBuilder skipIfAwaitsFix(String bugUrl) {
            this.skipAwaitsFix = bugUrl;
            return this;
        }

        public PrerequisiteSectionBuilder skipIfVersion(String skipVersionRange) {
            this.skipVersionRange = skipVersionRange;
            return this;
        }

        public PrerequisiteSectionBuilder setSkipReason(String skipReason) {
            this.skipReason = skipReason;
            return this;
        }

        public PrerequisiteSectionBuilder setRequiresReason(String requiresReason) {
            this.requiresReason = requiresReason;
            return this;
        }

        public PrerequisiteSectionBuilder requireYamlRunnerFeature(String featureName) {
            this.requiredYamlRunnerFeatures.add(featureName);
            return this;
        }

        public PrerequisiteSectionBuilder requireXPack() {
            this.xpackRequired = this.xpackRequired == XPackRequired.NO ? XPackRequired.MISMATCHED : XPackRequired.YES;
            return this;
        }

        public PrerequisiteSectionBuilder skipIfXPack() {
            this.xpackRequired = this.xpackRequired == XPackRequired.YES ? XPackRequired.MISMATCHED : XPackRequired.NO;
            return this;
        }

        public PrerequisiteSectionBuilder skipIfClusterFeature(String featureName) {
            this.skipClusterFeatures.add(featureName);
            return this;
        }

        public PrerequisiteSectionBuilder skipKnownIssue(KnownIssue knownIssue) {
            this.skipKnownIssues.add(knownIssue);
            return this;
        }

        public PrerequisiteSectionBuilder skipIfCapabilities(CapabilitiesCheck capabilitiesCheck) {
            this.skipCapabilities.add(capabilitiesCheck);
            return this;
        }

        public PrerequisiteSectionBuilder requireClusterFeature(String featureName) {
            this.requiredClusterFeatures.add(featureName);
            return this;
        }

        public PrerequisiteSectionBuilder requireCapabilities(CapabilitiesCheck capabilitiesCheck) {
            this.requiredCapabilities.add(capabilitiesCheck);
            return this;
        }

        public PrerequisiteSectionBuilder skipIfOs(String osName) {
            this.skipOperatingSystems.add(osName);
            return this;
        }

        void validate(XContentLocation contentLocation) {
            if (Strings.isEmpty((CharSequence)this.skipVersionRange) && this.skipOperatingSystems.isEmpty() && this.skipClusterFeatures.isEmpty() && this.skipCapabilities.isEmpty() && this.skipKnownIssues.isEmpty() && Strings.isEmpty((CharSequence)this.skipAwaitsFix) && this.xpackRequired == XPackRequired.NOT_SPECIFIED && this.requiredYamlRunnerFeatures.isEmpty() && this.requiredCapabilities.isEmpty() && this.requiredClusterFeatures.isEmpty()) {
                throw new ParsingException(contentLocation, "at least one predicate is mandatory within a skip or requires section", new Object[0]);
            }
            if (Strings.isEmpty((CharSequence)this.skipReason) && !(Strings.isEmpty((CharSequence)this.skipVersionRange) && this.skipOperatingSystems.isEmpty() && this.skipClusterFeatures.isEmpty() && this.skipCapabilities.isEmpty() && this.skipKnownIssues.isEmpty())) {
                throw new ParsingException(contentLocation, "reason is mandatory within this skip section", new Object[0]);
            }
            if (Strings.isEmpty((CharSequence)this.requiresReason) && !(this.requiredClusterFeatures.isEmpty() && this.requiredCapabilities.isEmpty())) {
                throw new ParsingException(contentLocation, "reason is mandatory within this requires section", new Object[0]);
            }
            if (!this.skipOperatingSystems.isEmpty() && !this.requiredYamlRunnerFeatures.contains("skip_os")) {
                throw new ParsingException(contentLocation, "if os is specified, test runner feature [skip_os] must be set", new Object[0]);
            }
            if (this.xpackRequired == XPackRequired.MISMATCHED) {
                throw new ParsingException(contentLocation, "either [xpack] or [no_xpack] can be present, not both", new Object[0]);
            }
            if (Sets.haveNonEmptyIntersection(this.skipClusterFeatures, this.requiredClusterFeatures)) {
                throw new ParsingException(contentLocation, "a cluster feature can be specified either in [requires] or [skip], not both", new Object[0]);
            }
        }

        public PrerequisiteSection build() {
            if (!Features.areAllSupported(this.requiredYamlRunnerFeatures)) {
                return new PrerequisiteSection(Collections.emptyList(), this.skipReason, List.of(Prerequisites.FALSE), this.requiresReason, this.requiredYamlRunnerFeatures);
            }
            if (Strings.hasLength((String)this.skipAwaitsFix)) {
                return new PrerequisiteSection(List.of(Prerequisites.TRUE), this.skipReason, Collections.emptyList(), this.requiresReason, this.requiredYamlRunnerFeatures);
            }
            ArrayList<Predicate<ClientYamlTestExecutionContext>> skipCriteriaList = new ArrayList<Predicate<ClientYamlTestExecutionContext>>();
            ArrayList<Predicate<ClientYamlTestExecutionContext>> requiresCriteriaList = new ArrayList<Predicate<ClientYamlTestExecutionContext>>();
            if (this.xpackRequired == XPackRequired.YES) {
                requiresCriteriaList.add(Prerequisites.hasXPack());
            }
            if (!this.requiredClusterFeatures.isEmpty()) {
                requiresCriteriaList.add(Prerequisites.requireClusterFeatures(this.requiredClusterFeatures));
            }
            if (!this.requiredCapabilities.isEmpty()) {
                requiresCriteriaList.add(Prerequisites.requireCapabilities(this.requiredCapabilities));
            }
            if (this.xpackRequired == XPackRequired.NO) {
                skipCriteriaList.add(Prerequisites.hasXPack());
            }
            if (Strings.hasLength((String)this.skipVersionRange)) {
                skipCriteriaList.add(Prerequisites.skipOnVersionRange(this.skipVersionRange));
            }
            if (!this.skipOperatingSystems.isEmpty()) {
                skipCriteriaList.add(Prerequisites.skipOnOsList(this.skipOperatingSystems));
            }
            if (!this.skipClusterFeatures.isEmpty()) {
                skipCriteriaList.add(Prerequisites.skipOnClusterFeatures(this.skipClusterFeatures));
            }
            if (!this.skipCapabilities.isEmpty()) {
                skipCriteriaList.add(Prerequisites.skipCapabilities(this.skipCapabilities));
            }
            if (!this.skipKnownIssues.isEmpty()) {
                skipCriteriaList.add(Prerequisites.skipOnKnownIssue(this.skipKnownIssues));
            }
            return new PrerequisiteSection(skipCriteriaList, this.skipReason, requiresCriteriaList, this.requiresReason, this.requiredYamlRunnerFeatures);
        }

        static enum XPackRequired {
            NOT_SPECIFIED,
            YES,
            NO,
            MISMATCHED;

        }
    }

    record KnownIssue(String clusterFeature, String fixedBy) {
        private static final Set<String> FIELD_NAMES = Set.of("cluster_feature", "fixed_by");
    }

    record CapabilitiesCheck(String method, String path, String parameters, String capabilities) {
        private static final Set<String> FIELD_NAMES = Set.of("method", "path", "parameters", "capabilities");
    }
}

