/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    private final IndicesService indicesService;
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/get", transportService, clusterService, threadPool, actionFilters, GetIndexRequest::new, indexNameExpressionResolver, GetIndexResponse::new);
        this.indicesService = indicesService;
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected void doMasterOperation(Task task, GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) {
        Map<String, MappingMetadata> mappingsResult = ImmutableOpenMap.of();
        Map<String, List<AliasMetadata>> aliasesResult = Map.of();
        Map<String, Settings> settings = Map.of();
        Map<String, Settings> defaultSettings = Map.of();
        Map<String, String> dataStreams = Map.copyOf(state.metadata().findDataStreams(concreteIndices).entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, v -> ((DataStream)v.getValue()).getName())));
        GetIndexRequest.Feature[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        block5: for (GetIndexRequest.Feature feature : features) {
            TransportGetIndexAction.checkCancellation(task);
            switch (feature) {
                case MAPPINGS: {
                    if (doneMappings) continue block5;
                    mappingsResult = state.metadata().findMappings(concreteIndices, this.indicesService.getFieldFilter(), () -> TransportGetIndexAction.checkCancellation(task));
                    doneMappings = true;
                    continue block5;
                }
                case ALIASES: {
                    if (doneAliases) continue block5;
                    aliasesResult = state.metadata().findAllAliases(concreteIndices);
                    doneAliases = true;
                    continue block5;
                }
                case SETTINGS: {
                    if (doneSettings) continue block5;
                    HashMap<String, Settings> settingsMapBuilder = new HashMap<String, Settings>();
                    HashMap<String, Settings> defaultSettingsMapBuilder = new HashMap<String, Settings>();
                    for (String index : concreteIndices) {
                        TransportGetIndexAction.checkCancellation(task);
                        Settings indexSettings = state.metadata().index(index).getSettings();
                        if (request.humanReadable()) {
                            indexSettings = IndexMetadata.addHumanReadableSettings(indexSettings);
                        }
                        settingsMapBuilder.put(index, indexSettings);
                        if (!request.includeDefaults()) continue;
                        Settings defaultIndexSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
                        defaultSettingsMapBuilder.put(index, defaultIndexSettings);
                    }
                    settings = Collections.unmodifiableMap(settingsMapBuilder);
                    defaultSettings = Collections.unmodifiableMap(defaultSettingsMapBuilder);
                    doneSettings = true;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("feature [" + String.valueOf((Object)feature) + "] is not valid");
                }
            }
        }
        listener.onResponse(new GetIndexResponse(concreteIndices, mappingsResult, aliasesResult, settings, defaultSettings, dataStreams));
    }

    private static void checkCancellation(Task task) {
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.ensureNotCancelled();
        }
    }
}

