/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;

public class GetSnapshotsResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final List<SnapshotInfo> snapshots;
    private final Map<String, ElasticsearchException> failures;
    @Nullable
    private final String next;
    private final int total;
    private final int remaining;

    public GetSnapshotsResponse(List<SnapshotInfo> snapshots, Map<String, ElasticsearchException> failures, @Nullable String next, int total, int remaining) {
        this.snapshots = List.copyOf(snapshots);
        this.failures = failures == null ? Map.of() : Map.copyOf(failures);
        this.next = next;
        this.total = total;
        this.remaining = remaining;
    }

    public GetSnapshotsResponse(StreamInput in) throws IOException {
        this.snapshots = in.readCollectionAsImmutableList(SnapshotInfo::readFrom);
        this.failures = Collections.unmodifiableMap(in.readMap(StreamInput::readException));
        this.next = in.readOptionalString();
        this.total = in.readVInt();
        this.remaining = in.readVInt();
    }

    public List<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    public Map<String, ElasticsearchException> getFailures() {
        return this.failures;
    }

    @Nullable
    public String next() {
        return this.next;
    }

    public boolean isFailed() {
        return !this.failures.isEmpty();
    }

    public int totalCount() {
        return this.total;
    }

    public int remaining() {
        return this.remaining;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.snapshots);
        out.writeMap(this.failures, StreamOutput::writeException);
        out.writeOptionalString(this.next);
        out.writeVInt(this.total);
        out.writeVInt(this.remaining);
    }

    public Iterator<ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((b, p) -> {
            b.startObject();
            b.startArray("snapshots");
            return b;
        }), Iterators.map(this.getSnapshots().iterator(), snapshotInfo -> snapshotInfo::toXContentExternal), Iterators.single((b, p) -> {
            b.endArray();
            if (!this.failures.isEmpty()) {
                b.startObject("failures");
                for (Map.Entry<String, ElasticsearchException> error : this.failures.entrySet()) {
                    b.field(error.getKey(), (bb, pa) -> {
                        bb.startObject();
                        ((ElasticsearchException)error.getValue()).toXContent(bb, pa);
                        bb.endObject();
                        return bb;
                    });
                }
                b.endObject();
            }
            if (this.next != null) {
                b.field("next", this.next);
            }
            if (this.total >= 0) {
                b.field("total", this.total);
            }
            if (this.remaining >= 0) {
                b.field("remaining", this.remaining);
            }
            b.endObject();
            return b;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotsResponse that = (GetSnapshotsResponse)o;
        return Objects.equals(this.snapshots, that.snapshots) && Objects.equals(this.failures, that.failures) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.snapshots, this.failures, this.next);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

