/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.allocator.ClusterBalanceStats;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceStats;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DesiredBalanceResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private static final TransportVersion CLUSTER_BALANCE_STATS_VERSION = TransportVersions.V_8_7_0;
    private static final TransportVersion CLUSTER_INFO_VERSION = TransportVersions.V_8_8_0;
    private final DesiredBalanceStats stats;
    private final ClusterBalanceStats clusterBalanceStats;
    private final Map<String, Map<Integer, DesiredShards>> routingTable;
    private final ClusterInfo clusterInfo;

    public DesiredBalanceResponse(DesiredBalanceStats stats, ClusterBalanceStats clusterBalanceStats, Map<String, Map<Integer, DesiredShards>> routingTable, ClusterInfo clusterInfo) {
        this.stats = stats;
        this.clusterBalanceStats = clusterBalanceStats;
        this.routingTable = routingTable;
        this.clusterInfo = clusterInfo;
    }

    public static DesiredBalanceResponse from(StreamInput in) throws IOException {
        return new DesiredBalanceResponse(DesiredBalanceStats.readFrom(in), in.getTransportVersion().onOrAfter(CLUSTER_BALANCE_STATS_VERSION) ? ClusterBalanceStats.readFrom(in) : ClusterBalanceStats.EMPTY, in.readImmutableMap(v -> v.readImmutableMap(StreamInput::readVInt, DesiredShards::from)), in.getTransportVersion().onOrAfter(CLUSTER_INFO_VERSION) ? new ClusterInfo(in) : ClusterInfo.EMPTY);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        if (out.getTransportVersion().onOrAfter(CLUSTER_BALANCE_STATS_VERSION)) {
            out.writeWriteable(this.clusterBalanceStats);
        }
        out.writeMap(this.routingTable, (shardsOut, shards) -> shardsOut.writeMap(shards, StreamOutput::writeVInt, StreamOutput::writeWriteable));
        if (out.getTransportVersion().onOrAfter(CLUSTER_INFO_VERSION)) {
            out.writeWriteable(this.clusterInfo);
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.singleChunk((builder, p) -> builder.startObject().field("stats", (ToXContent)this.stats).field("cluster_balance_stats", (ToXContent)this.clusterBalanceStats).startObject("routing_table")), Iterators.flatMap(this.routingTable.entrySet().iterator(), indexEntry -> Iterators.concat(ChunkedToXContentHelper.startObject((String)indexEntry.getKey()), Iterators.flatMap(((Map)indexEntry.getValue()).entrySet().iterator(), shardEntry -> Iterators.concat(ChunkedToXContentHelper.singleChunk((builder, p) -> builder.field(String.valueOf(shardEntry.getKey()))), ((DesiredShards)shardEntry.getValue()).toXContentChunked(params))), ChunkedToXContentHelper.endObject())), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject().startObject("cluster_info")), this.clusterInfo.toXContentChunked(params), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject().endObject()));
    }

    public DesiredBalanceStats getStats() {
        return this.stats;
    }

    public ClusterBalanceStats getClusterBalanceStats() {
        return this.clusterBalanceStats;
    }

    public Map<String, Map<Integer, DesiredShards>> getRoutingTable() {
        return this.routingTable;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesiredBalanceResponse)) return false;
        DesiredBalanceResponse that = (DesiredBalanceResponse)o;
        if (!Objects.equals(this.stats, that.stats)) return false;
        if (!Objects.equals(this.clusterBalanceStats, that.clusterBalanceStats)) return false;
        if (!Objects.equals(this.routingTable, that.routingTable)) return false;
        if (!Objects.equals(this.clusterInfo, that.clusterInfo)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.clusterBalanceStats, this.routingTable, this.clusterInfo);
    }

    public String toString() {
        return "DesiredBalanceResponse{stats=" + String.valueOf(this.stats) + ", clusterBalanceStats=" + String.valueOf(this.clusterBalanceStats) + ", routingTable=" + String.valueOf(this.routingTable) + ", clusterInfo=" + String.valueOf(this.clusterInfo) + "}";
    }

    public record DesiredShards(List<ShardView> current, ShardAssignmentView desired) implements Writeable,
    ChunkedToXContentObject
    {
        public static DesiredShards from(StreamInput in) throws IOException {
            return new DesiredShards(in.readCollectionAsList(ShardView::from), ShardAssignmentView.from(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.current);
            this.desired.writeTo(out);
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(ChunkedToXContentHelper.singleChunk((builder, p) -> builder.startObject().startArray("current")), this.current().iterator(), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endArray().field("desired").value((ToXContent)this.desired, p).endObject()));
        }
    }

    public record ShardAssignmentView(Set<String> nodeIds, int total, int unassigned, int ignored) implements Writeable,
    ToXContentObject
    {
        public static final ShardAssignmentView EMPTY = new ShardAssignmentView(Set.of(), 0, 0, 0);

        public static ShardAssignmentView from(StreamInput in) throws IOException {
            Set<String> nodeIds = in.readCollectionAsSet(StreamInput::readString);
            int total = in.readVInt();
            int unassigned = in.readVInt();
            int ignored = in.readVInt();
            if (nodeIds.isEmpty() && total == 0 && unassigned == 0 && ignored == 0) {
                return EMPTY;
            }
            return new ShardAssignmentView(nodeIds, total, unassigned, ignored);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.nodeIds);
            out.writeVInt(this.total);
            out.writeVInt(this.unassigned);
            out.writeVInt(this.ignored);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().array("node_ids", (String[])this.nodeIds.toArray(String[]::new)).field("total", this.total).field("unassigned", this.unassigned).field("ignored", this.ignored).endObject();
        }
    }

    public record ShardView(ShardRoutingState state, boolean primary, String node, boolean nodeIsDesired, @Nullable String relocatingNode, @Nullable Boolean relocatingNodeIsDesired, int shardId, String index, @Nullable Double forecastWriteLoad, @Nullable Long forecastShardSizeInBytes, List<String> tierPreference) implements Writeable,
    ToXContentObject
    {
        private static final TransportVersion ADD_FORECASTS_VERSION = TransportVersions.V_8_7_0;
        private static final TransportVersion ADD_TIER_PREFERENCE = TransportVersions.V_8_8_0;
        private static final TransportVersion NULLABLE_RELOCATING_NODE_IS_DESIRED = TransportVersions.V_8_8_0;

        public ShardView {
            assert (relocatingNode == null == (relocatingNodeIsDesired == null)) : "relocatingNodeIsDesired should only be set when relocatingNode is set";
        }

        public static ShardView from(StreamInput in) throws IOException {
            Long forecastShardSizeInBytes;
            Boolean relocatingNodeIsDesired;
            ShardRoutingState state = ShardRoutingState.fromValue(in.readByte());
            boolean primary = in.readBoolean();
            String node = in.readOptionalString();
            boolean nodeIsDesired = in.readBoolean();
            String relocatingNode = in.readOptionalString();
            if (in.getTransportVersion().onOrAfter(NULLABLE_RELOCATING_NODE_IS_DESIRED)) {
                relocatingNodeIsDesired = in.readOptionalBoolean();
            } else {
                boolean wireRelocatingNodeIsDesired = in.readBoolean();
                relocatingNodeIsDesired = relocatingNode == null ? null : Boolean.valueOf(wireRelocatingNodeIsDesired);
            }
            int shardId = in.readVInt();
            String index = in.readString();
            Double forecastWriteLoad = in.getTransportVersion().onOrAfter(ADD_FORECASTS_VERSION) ? in.readOptionalDouble() : null;
            Long l = forecastShardSizeInBytes = in.getTransportVersion().onOrAfter(ADD_FORECASTS_VERSION) ? in.readOptionalLong() : null;
            if (!in.getTransportVersion().onOrAfter(ADD_FORECASTS_VERSION)) {
                in.readOptionalWriteable(AllocationId::new);
            }
            List<String> tierPreference = in.getTransportVersion().onOrAfter(ADD_TIER_PREFERENCE) ? in.readStringCollectionAsList() : List.of();
            return new ShardView(state, primary, node, nodeIsDesired, relocatingNode, relocatingNodeIsDesired, shardId, index, forecastWriteLoad, forecastShardSizeInBytes, tierPreference);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.state.value());
            out.writeBoolean(this.primary);
            out.writeOptionalString(this.node);
            out.writeBoolean(this.nodeIsDesired);
            out.writeOptionalString(this.relocatingNode);
            if (out.getTransportVersion().onOrAfter(NULLABLE_RELOCATING_NODE_IS_DESIRED)) {
                out.writeOptionalBoolean(this.relocatingNodeIsDesired);
            } else {
                out.writeBoolean(this.relocatingNodeIsDesired != null && this.relocatingNodeIsDesired != false);
            }
            out.writeVInt(this.shardId);
            out.writeString(this.index);
            if (out.getTransportVersion().onOrAfter(ADD_FORECASTS_VERSION)) {
                out.writeOptionalDouble(this.forecastWriteLoad);
                out.writeOptionalLong(this.forecastShardSizeInBytes);
            } else {
                out.writeMissingWriteable(AllocationId.class);
            }
            if (out.getTransportVersion().onOrAfter(ADD_TIER_PREFERENCE)) {
                out.writeStringCollection(this.tierPreference);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("index", this.index).field("shard_id", this.shardId).field("state", this.state.toString()).field("primary", this.primary).field("node", this.node).field("node_is_desired", this.nodeIsDesired).field("relocating_node", this.relocatingNode).field("relocating_node_is_desired", this.relocatingNodeIsDesired).field("forecast_write_load", this.forecastWriteLoad).field("forecast_shard_size_in_bytes", this.forecastShardSizeInBytes).field("tier_preference", this.tierPreference).endObject();
        }
    }
}

