/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public abstract class YARNDelegationTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto.newBuilder();

    public YARNDelegationTokenIdentifier() {
    }

    public YARNDelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    public YARNDelegationTokenIdentifier(YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto.Builder builder) {
        this.builder = builder;
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.builder.mergeFrom((DataInputStream)in);
        if (this.builder.getOwner() != null) {
            this.setOwner(new Text(this.builder.getOwner()));
        }
        if (this.builder.getRenewer() != null) {
            this.setRenewer(new Text(this.builder.getRenewer()));
        }
        if (this.builder.getRealUser() != null) {
            this.setRealUser(new Text(this.builder.getRealUser()));
        }
        this.setIssueDate(this.builder.getIssueDate());
        this.setMaxDate(this.builder.getMaxDate());
        this.setSequenceNumber(this.builder.getSequenceNumber());
        this.setMasterKeyId(this.builder.getMasterKeyId());
    }

    public synchronized void readFieldsInOldFormat(DataInput in) throws IOException {
        super.readFields(in);
    }

    private void setBuilderFields() {
        if (this.builder.getOwner() != null && !this.builder.getOwner().equals(this.getOwner().toString())) {
            this.builder.setOwner(this.getOwner().toString());
        }
        if (this.builder.getRenewer() != null && !this.builder.getRenewer().equals(this.getRenewer().toString())) {
            this.builder.setRenewer(this.getRenewer().toString());
        }
        if (this.builder.getRealUser() != null && !this.builder.getRealUser().equals(this.getRealUser().toString())) {
            this.builder.setRealUser(this.getRealUser().toString());
        }
        if (this.builder.getIssueDate() != this.getIssueDate()) {
            this.builder.setIssueDate(this.getIssueDate());
        }
        if (this.builder.getMaxDate() != this.getMaxDate()) {
            this.builder.setMaxDate(this.getMaxDate());
        }
        if (this.builder.getSequenceNumber() != this.getSequenceNumber()) {
            this.builder.setSequenceNumber(this.getSequenceNumber());
        }
        if (this.builder.getMasterKeyId() != this.getMasterKeyId()) {
            this.builder.setMasterKeyId(this.getMasterKeyId());
        }
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        this.setBuilderFields();
        this.builder.build().writeTo((DataOutputStream)out);
    }

    @VisibleForTesting
    public synchronized void writeInOldFormat(DataOutput out) throws IOException {
        super.write(out);
    }

    public YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto getProto() {
        this.setBuilderFields();
        return this.builder.build();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static YARNDelegationTokenIdentifier newInstance(Text owner, Text renewer, Text realUser) {
        YARNDelegationTokenIdentifier policy = Records.newRecord(YARNDelegationTokenIdentifier.class);
        policy.setOwner(owner);
        policy.setRenewer(renewer);
        policy.setRenewer(realUser);
        return policy;
    }
}

