/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl.action;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class GetCertificateInfoAction
extends ActionType<Response> {
    public static final GetCertificateInfoAction INSTANCE = new GetCertificateInfoAction();
    public static final String NAME = "cluster:monitor/xpack/ssl/certificates/get";

    private GetCertificateInfoAction() {
        super(NAME);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, INSTANCE, new Request());
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Collection<CertificateInfo> certificates;

        public Response(Collection<CertificateInfo> certificates) {
            this.certificates = certificates;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (CertificateInfo cert : this.certificates) {
                cert.toXContent(builder, params);
            }
            return builder.endArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.certificates.size());
            for (CertificateInfo cert : this.certificates) {
                cert.writeTo(out);
            }
        }
    }

    public static class Request
    extends LegacyActionRequest {
        Request() {
        }

        Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

