/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public record ChatCompletionResults(List<Result> results) implements InferenceServiceResults
{
    public static final String NAME = "chat_completion_service_results";
    public static final String COMPLETION = TaskType.COMPLETION.name().toLowerCase(Locale.ROOT);

    public ChatCompletionResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Result::new));
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).array(COMPLETION, this.results.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.results);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.results;
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException();
    }

    public List<Result> getResults() {
        return this.results;
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(COMPLETION, this.results.stream().map(Result::asMap).collect(Collectors.toList()));
        return map;
    }

    public record Result(String content) implements InferenceResults,
    Writeable
    {
        public static final String RESULT = "result";

        public Result(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.content);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RESULT, this.content);
            builder.endObject();
            return builder;
        }

        @Override
        public String getResultsField() {
            return RESULT;
        }

        @Override
        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(RESULT, this.content);
            return map;
        }

        @Override
        public Map<String, Object> asMap(String outputField) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(outputField, this.content);
            return map;
        }

        @Override
        public Object predictedValue() {
            return this.content;
        }

        @Override
        public String getWriteableName() {
            return ChatCompletionResults.NAME;
        }
    }
}

