/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;

public class ExecuteEnrichPolicyAction
extends ActionType<Response> {
    public static final ExecuteEnrichPolicyAction INSTANCE = new ExecuteEnrichPolicyAction();
    public static final String NAME = "cluster:admin/xpack/enrich/execute";

    private ExecuteEnrichPolicyAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final TaskId taskId;
        private final ExecuteEnrichPolicyStatus status;

        public Response(ExecuteEnrichPolicyStatus status) {
            this.taskId = null;
            this.status = status;
        }

        public Response(TaskId taskId) {
            this.taskId = taskId;
            this.status = null;
        }

        public TaskId getTaskId() {
            return this.taskId;
        }

        public ExecuteEnrichPolicyStatus getStatus() {
            return this.status;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.status = new ExecuteEnrichPolicyStatus(in);
                this.taskId = null;
            } else {
                this.taskId = TaskId.readFromStream(in);
                this.status = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            boolean waitedForCompletion = this.status != null;
            out.writeBoolean(waitedForCompletion);
            if (waitedForCompletion) {
                this.status.writeTo(out);
            } else {
                this.taskId.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.taskId != null) {
                builder.field("task", this.taskId.getNodeId() + ":" + this.taskId.getId());
            } else {
                builder.field("status", this.status);
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String name;
        private boolean waitForCompletion;

        public Request(TimeValue masterNodeTimeout, String name) {
            super(masterNodeTimeout);
            this.name = Objects.requireNonNull(name, "name cannot be null");
            this.waitForCompletion = true;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.waitForCompletion = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeBoolean(this.waitForCompletion);
        }

        public String getName() {
            return this.name;
        }

        public boolean isWaitForCompletion() {
            return this.waitForCompletion;
        }

        public Request setWaitForCompletion(boolean waitForCompletion) {
            this.waitForCompletion = waitForCompletion;
            return this;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.waitForCompletion == request.waitForCompletion && Objects.equals(this.name, request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.waitForCompletion);
        }
    }
}

