/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.elasticsearch.index.codec.FilterDocValuesProducer;
import org.elasticsearch.index.codec.perfield.XPerFieldDocValuesFormat;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesProducer;

class DocValuesConsumerUtil {
    static final MergeStats UNSUPPORTED = new MergeStats(false, -1L, -1, -1, -1);

    DocValuesConsumerUtil() {
    }

    static MergeStats compatibleWithOptimizedMerge(boolean optimizedMergeEnabled, MergeState mergeState, FieldInfo fieldInfo) {
        if (!optimizedMergeEnabled || !mergeState.needsIndexSort) {
            return UNSUPPORTED;
        }
        for (int i = 0; i < mergeState.liveDocs.length; ++i) {
            if (mergeState.liveDocs[i] == null) continue;
            return UNSUPPORTED;
        }
        long sumNumValues = 0L;
        int sumNumDocsWithField = 0;
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        block8: for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
            DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
            if (docValuesProducer instanceof FilterDocValuesProducer) {
                FilterDocValuesProducer filterDocValuesProducer = (FilterDocValuesProducer)docValuesProducer;
                docValuesProducer = filterDocValuesProducer.getIn();
            }
            if (docValuesProducer instanceof XPerFieldDocValuesFormat.FieldsReader) {
                XPerFieldDocValuesFormat.FieldsReader perFieldReader = (XPerFieldDocValuesFormat.FieldsReader)docValuesProducer;
                DocValuesProducer wrapped = perFieldReader.getDocValuesProducer(fieldInfo);
                if (wrapped == null) continue;
                if (wrapped instanceof ES819TSDBDocValuesProducer) {
                    ES819TSDBDocValuesProducer tsdbDocValuesProducer = (ES819TSDBDocValuesProducer)wrapped;
                    switch (fieldInfo.getDocValuesType()) {
                        case NUMERIC: {
                            Object entry = tsdbDocValuesProducer.numerics.get(fieldInfo.number);
                            if (entry == null) continue block8;
                            sumNumValues += ((ES819TSDBDocValuesProducer.NumericEntry)entry).numValues;
                            sumNumDocsWithField += ((ES819TSDBDocValuesProducer.NumericEntry)entry).numDocsWithField;
                            continue block8;
                        }
                        case SORTED_NUMERIC: {
                            Object entry = tsdbDocValuesProducer.sortedNumerics.get(fieldInfo.number);
                            if (entry == null) continue block8;
                            sumNumValues += ((ES819TSDBDocValuesProducer.SortedNumericEntry)entry).numValues;
                            sumNumDocsWithField += ((ES819TSDBDocValuesProducer.SortedNumericEntry)entry).numDocsWithField;
                            continue block8;
                        }
                        case SORTED: {
                            Object entry = tsdbDocValuesProducer.sorted.get(fieldInfo.number);
                            if (entry == null) continue block8;
                            sumNumValues += ((ES819TSDBDocValuesProducer.SortedEntry)entry).ordsEntry.numValues;
                            sumNumDocsWithField += ((ES819TSDBDocValuesProducer.SortedEntry)entry).ordsEntry.numDocsWithField;
                            continue block8;
                        }
                        case SORTED_SET: {
                            Object entry = tsdbDocValuesProducer.sortedSets.get(fieldInfo.number);
                            if (entry == null) continue block8;
                            if (((ES819TSDBDocValuesProducer.SortedSetEntry)entry).singleValueEntry != null) {
                                sumNumValues += ((ES819TSDBDocValuesProducer.SortedSetEntry)entry).singleValueEntry.ordsEntry.numValues;
                                sumNumDocsWithField += ((ES819TSDBDocValuesProducer.SortedSetEntry)entry).singleValueEntry.ordsEntry.numDocsWithField;
                                continue block8;
                            }
                            sumNumValues += ((ES819TSDBDocValuesProducer.SortedSetEntry)entry).ordsEntry.numValues;
                            sumNumDocsWithField += ((ES819TSDBDocValuesProducer.SortedSetEntry)entry).ordsEntry.numDocsWithField;
                            continue block8;
                        }
                        case BINARY: {
                            Object entry = tsdbDocValuesProducer.binaries.get(fieldInfo.number);
                            if (entry == null) continue block8;
                            sumNumDocsWithField += ((ES819TSDBDocValuesProducer.BinaryEntry)entry).numDocsWithField;
                            minLength = Math.min(minLength, ((ES819TSDBDocValuesProducer.BinaryEntry)entry).minLength);
                            maxLength = Math.max(maxLength, ((ES819TSDBDocValuesProducer.BinaryEntry)entry).maxLength);
                            continue block8;
                        }
                        default: {
                            throw new IllegalStateException("unexpected doc values producer type: " + String.valueOf((Object)fieldInfo.getDocValuesType()));
                        }
                    }
                }
                return UNSUPPORTED;
            }
            return UNSUPPORTED;
        }
        return new MergeStats(true, sumNumValues, sumNumDocsWithField, minLength, maxLength);
    }

    record MergeStats(boolean supported, long sumNumValues, int sumNumDocsWithField, int minLength, int maxLength) {
    }
}

