/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.elasticsearch.common.util.AbstractPagedHashMap;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;

public final class ObjectObjectPagedHashMap<K, V>
extends AbstractPagedHashMap
implements Iterable<Cursor<K, V>> {
    private ObjectArray<K> keys;
    private ObjectArray<V> values;

    public ObjectObjectPagedHashMap(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectObjectPagedHashMap(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        this.keys = bigArrays.newObjectArray(this.capacity());
        boolean success = false;
        try {
            this.values = bigArrays.newObjectArray(this.capacity());
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public V get(K key) {
        long slot;
        long index = slot = ObjectObjectPagedHashMap.slot(key.hashCode(), this.mask);
        V value;
        while ((value = this.values.get(index)) != null) {
            if (this.keys.get(index).equals(key)) {
                return value;
            }
            index = ObjectObjectPagedHashMap.nextSlot(index, this.mask);
        }
        return null;
    }

    public V put(K key, V value) {
        assert (value != null) : "Null values are not supported";
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, key.hashCode(), value);
    }

    public V remove(K key) {
        long slot;
        long index = slot = ObjectObjectPagedHashMap.slot(key.hashCode(), this.mask);
        V previous;
        while ((previous = this.values.getAndSet(index, null)) != null) {
            if (this.keys.get(index).equals(key)) {
                --this.size;
                long j = ObjectObjectPagedHashMap.nextSlot(index, this.mask);
                while (this.used(j)) {
                    this.removeAndAdd(j);
                    j = ObjectObjectPagedHashMap.nextSlot(j, this.mask);
                }
                return previous;
            }
            this.values.set(index, previous);
            index = ObjectObjectPagedHashMap.nextSlot(index, this.mask);
        }
        return null;
    }

    private V set(K key, int code, V value) {
        long slot;
        assert (key.hashCode() == code);
        assert (this.size < this.maxSize);
        long index = slot = ObjectObjectPagedHashMap.slot(code, this.mask);
        while (true) {
            V previous;
            if ((previous = this.values.getAndSet(index, value)) == null) {
                this.keys.set(index, key);
                ++this.size;
                return null;
            }
            if (key.equals(this.keys.get(index))) {
                return previous;
            }
            this.values.set(index, previous);
            index = ObjectObjectPagedHashMap.nextSlot(index, this.mask);
        }
    }

    @Override
    public Iterator<Cursor<K, V>> iterator() {
        return new Iterator<Cursor<K, V>>(){
            boolean cached;
            final Cursor<K, V> cursor = new Cursor();
            {
                this.cursor.index = -1L;
                this.cached = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.cached) {
                    block2: {
                        do {
                            ++this.cursor.index;
                            if (this.cursor.index >= ObjectObjectPagedHashMap.this.capacity()) break block2;
                        } while (!ObjectObjectPagedHashMap.this.used(this.cursor.index));
                        this.cursor.key = ObjectObjectPagedHashMap.this.keys.get(this.cursor.index);
                        this.cursor.value = ObjectObjectPagedHashMap.this.values.get(this.cursor.index);
                    }
                    this.cached = true;
                }
                return this.cursor.index < ObjectObjectPagedHashMap.this.capacity();
            }

            @Override
            public Cursor<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cached = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        Releasables.close(this.keys, this.values);
    }

    @Override
    protected void resize(long capacity) {
        this.keys = this.bigArrays.resize(this.keys, capacity);
        this.values = this.bigArrays.resize(this.values, capacity);
    }

    @Override
    protected boolean used(long bucket) {
        return this.values.get(bucket) != null;
    }

    @Override
    protected void removeAndAdd(long index) {
        K key = this.keys.get(index);
        V value = this.values.getAndSet(index, null);
        this.reset(key, value);
    }

    private void reset(K key, V value) {
        long slot;
        ObjectArray<V> values = this.values;
        long mask = this.mask;
        long index = slot = ObjectObjectPagedHashMap.slot(key.hashCode(), mask);
        while (true) {
            V previous;
            if ((previous = values.get(index)) == null) break;
            index = ObjectObjectPagedHashMap.nextSlot(index, mask);
        }
        values.set(index, value);
        this.keys.set(index, key);
    }

    public static final class Cursor<K, V> {
        public long index;
        public K key;
        public V value;
    }
}

