/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalMasterServiceTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.ApplyCommitRequest;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.ClusterFormationFailureHelper;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.ElectionSchedulerFactory;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.FollowersChecker;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.JoinHelper;
import org.elasticsearch.cluster.coordination.JoinReasonService;
import org.elasticsearch.cluster.coordination.JoinRequest;
import org.elasticsearch.cluster.coordination.JoinValidationService;
import org.elasticsearch.cluster.coordination.LagDetector;
import org.elasticsearch.cluster.coordination.LeaderChecker;
import org.elasticsearch.cluster.coordination.LeaderHeartbeatService;
import org.elasticsearch.cluster.coordination.NoMasterBlockService;
import org.elasticsearch.cluster.coordination.NodeJoinExecutor;
import org.elasticsearch.cluster.coordination.NodeLeftExecutor;
import org.elasticsearch.cluster.coordination.PendingClusterStateStats;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.coordination.Publication;
import org.elasticsearch.cluster.coordination.PublicationTransportHandler;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishResponse;
import org.elasticsearch.cluster.coordination.PublishWithJoinResponse;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.ConfiguredHostsResolver;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.discovery.HandshakingTransportAddressConnector;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.SeedHostsResolver;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.discovery.TransportAddressConnector;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.json.JsonXContent;

public class Coordinator
extends AbstractLifecycleComponent
implements ClusterStatePublisher {
    private static final Logger logger = LogManager.getLogger(Coordinator.class);
    public static final Setting<TimeValue> PUBLISH_INFO_TIMEOUT_SETTING = Setting.timeSetting("cluster.publish.info_timeout", TimeValue.timeValueMillis(10000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PUBLISH_TIMEOUT_SETTING = Setting.timeSetting("cluster.publish.timeout", TimeValue.timeValueMillis(30000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> SINGLE_NODE_CLUSTER_SEED_HOSTS_CHECK_INTERVAL_SETTING = Setting.timeSetting("cluster.discovery_configuration_check.interval", TimeValue.timeValueMillis(30000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final String COMMIT_STATE_ACTION_NAME = "internal:cluster/coordination/commit_state";
    private final Settings settings;
    private final boolean singleNodeDiscovery;
    private final ElectionStrategy electionStrategy;
    private final TransportService transportService;
    private final Executor clusterCoordinationExecutor;
    private final MasterService masterService;
    private final AllocationService allocationService;
    private final JoinHelper joinHelper;
    private final JoinValidationService joinValidationService;
    private final MasterServiceTaskQueue<NodeLeftExecutor.Task> nodeLeftQueue;
    private final Supplier<CoordinationState.PersistedState> persistedStateSupplier;
    private final NoMasterBlockService noMasterBlockService;
    final Object mutex = new Object();
    private final SetOnce<CoordinationState> coordinationState = new SetOnce();
    private volatile ClusterState applierState;
    private final PeerFinder peerFinder;
    private final PreVoteCollector preVoteCollector;
    private final Random random;
    private final ElectionSchedulerFactory electionSchedulerFactory;
    private final SeedHostsResolver configuredHostsResolver;
    private final TimeValue publishTimeout;
    private final TimeValue publishInfoTimeout;
    private final TimeValue singleNodeClusterSeedHostsCheckInterval;
    @Nullable
    private Scheduler.Cancellable singleNodeClusterChecker = null;
    private final PublicationTransportHandler publicationHandler;
    private final LeaderChecker leaderChecker;
    private final FollowersChecker followersChecker;
    private final ClusterApplier clusterApplier;
    private final Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators;
    @Nullable
    private volatile Releasable electionScheduler;
    @Nullable
    private Releasable prevotingRound;
    private long maxTermSeen;
    private final Reconfigurator reconfigurator;
    private final ClusterBootstrapService clusterBootstrapService;
    private final LagDetector lagDetector;
    private final ClusterFormationFailureHelper clusterFormationFailureHelper;
    private final JoinReasonService joinReasonService;
    private final CompatibilityVersions compatibilityVersions;
    private Mode mode;
    private Optional<DiscoveryNode> lastKnownLeader;
    private Optional<Join> lastJoin;
    private JoinHelper.JoinAccumulator joinAccumulator;
    private Optional<CoordinatorPublication> currentPublication = Optional.empty();
    private final NodeHealthService nodeHealthService;
    private final List<PeerFinderListener> peerFinderListeners;
    private final LeaderHeartbeatService leaderHeartbeatService;
    private final AtomicBoolean reconfigurationTaskScheduled = new AtomicBoolean();

    public Coordinator(String nodeName, Settings settings, ClusterSettings clusterSettings, TransportService transportService, Client client, NamedWriteableRegistry namedWriteableRegistry, AllocationService allocationService, MasterService masterService, Supplier<CoordinationState.PersistedState> persistedStateSupplier, SeedHostsProvider seedHostsProvider, ClusterApplier clusterApplier, Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators, Random random, RerouteService rerouteService, ElectionStrategy electionStrategy, NodeHealthService nodeHealthService, CircuitBreakerService circuitBreakerService, Reconfigurator reconfigurator, LeaderHeartbeatService leaderHeartbeatService, PreVoteCollector.Factory preVoteCollectorFactory, CompatibilityVersions compatibilityVersions, FeatureService featureService) {
        this.settings = settings;
        this.transportService = transportService;
        this.clusterCoordinationExecutor = transportService.getThreadPool().executor("cluster_coordination");
        this.masterService = masterService;
        this.allocationService = allocationService;
        this.onJoinValidators = NodeJoinExecutor.addBuiltInJoinValidators(onJoinValidators);
        this.singleNodeDiscovery = DiscoveryModule.isSingleNodeDiscovery(settings);
        this.electionStrategy = electionStrategy;
        this.joinReasonService = new JoinReasonService(transportService.getThreadPool().relativeTimeInMillisSupplier());
        this.joinHelper = new JoinHelper(allocationService, masterService, clusterApplier, transportService, this::getCurrentTerm, this::handleJoinRequest, this::joinLeaderInTerm, rerouteService, nodeHealthService, this.joinReasonService, circuitBreakerService, reconfigurator::maybeReconfigureAfterNewMasterIsElected, this::getLatestStoredStateAfterWinningAnElection, compatibilityVersions, featureService);
        this.joinValidationService = new JoinValidationService(settings, transportService, this::getStateForJoinValidationService, () -> this.getLastAcceptedState().metadata(), this.onJoinValidators);
        this.persistedStateSupplier = persistedStateSupplier;
        this.noMasterBlockService = new NoMasterBlockService(settings, clusterSettings);
        this.lastKnownLeader = Optional.empty();
        this.lastJoin = Optional.empty();
        this.joinAccumulator = new JoinHelper.InitialJoinAccumulator();
        this.publishTimeout = PUBLISH_TIMEOUT_SETTING.get(settings);
        this.publishInfoTimeout = PUBLISH_INFO_TIMEOUT_SETTING.get(settings);
        this.singleNodeClusterSeedHostsCheckInterval = SINGLE_NODE_CLUSTER_SEED_HOSTS_CHECK_INTERVAL_SETTING.get(settings);
        this.random = random;
        this.electionSchedulerFactory = new ElectionSchedulerFactory(settings, random, transportService.getThreadPool());
        this.preVoteCollector = preVoteCollectorFactory.create(transportService, this::startElection, this::updateMaxTermSeen, electionStrategy, nodeHealthService, leaderHeartbeatService);
        this.configuredHostsResolver = new SeedHostsResolver(nodeName, settings, transportService, seedHostsProvider);
        this.peerFinder = new CoordinatorPeerFinder(settings, transportService, new HandshakingTransportAddressConnector(settings, transportService), this.configuredHostsResolver);
        transportService.registerRequestHandler(COMMIT_STATE_ACTION_NAME, this.clusterCoordinationExecutor, false, false, ApplyCommitRequest::new, (request, channel, task) -> this.handleApplyCommit((ApplyCommitRequest)request, new ChannelActionListener<TransportResponse>(channel).map(r -> ActionResponse.Empty.INSTANCE)));
        this.publicationHandler = new PublicationTransportHandler(transportService, namedWriteableRegistry, this::handlePublishRequest);
        this.leaderChecker = new LeaderChecker(settings, transportService, this::onLeaderFailure, nodeHealthService);
        this.followersChecker = new FollowersChecker(settings, transportService, this::onFollowerCheckRequest, this::removeNode, nodeHealthService);
        this.nodeLeftQueue = masterService.createTaskQueue("node-left", Priority.IMMEDIATE, new NodeLeftExecutor(allocationService));
        this.clusterApplier = clusterApplier;
        masterService.setClusterStateSupplier(this::getStateForMasterService);
        this.reconfigurator = reconfigurator;
        this.clusterBootstrapService = new ClusterBootstrapService(settings, transportService, this::getFoundPeers, this::isInitialConfigurationSet, this::setInitialConfiguration);
        this.lagDetector = new LagDetector(settings, transportService.getThreadPool(), new LagDetector.HotThreadsLoggingLagListener(transportService, client, (node, appliedVersion, expectedVersion) -> this.removeNode(node, "lagging")), transportService::getLocalNode);
        this.clusterFormationFailureHelper = new ClusterFormationFailureHelper(settings, this::getClusterFormationState, transportService.getThreadPool(), this.joinHelper::logLastFailedJoinAttempt);
        this.nodeHealthService = nodeHealthService;
        this.peerFinderListeners = new CopyOnWriteArrayList<PeerFinderListener>();
        this.peerFinderListeners.add(this.clusterBootstrapService);
        this.leaderHeartbeatService = leaderHeartbeatService;
        this.compatibilityVersions = compatibilityVersions;
    }

    public ClusterFormationFailureHelper.ClusterFormationState getClusterFormationState() {
        return new ClusterFormationFailureHelper.ClusterFormationState(this.settings, this.getLastAcceptedState(), this.peerFinder.getLastResolvedAddresses(), Stream.concat(Stream.of(this.getLocalNode()), StreamSupport.stream(this.peerFinder.getFoundPeers().spliterator(), false)).toList(), this.peerFinder.getMastersOfPeers(), this.getCurrentTerm(), this.electionStrategy, this.nodeHealthService.getHealth(), this.joinHelper.getInFlightJoinStatuses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLeaderFailure(Supplier<String> message, Exception e) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode != Mode.CANDIDATE) {
                assert (this.lastKnownLeader.isPresent());
                if (logger.isDebugEnabled()) {
                    logger.info(() -> message.get(), (Throwable)e);
                } else {
                    logger.info(() -> message.get());
                }
            }
            this.becomeCandidate("onLeaderFailure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(DiscoveryNode discoveryNode, String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode == Mode.LEADER) {
                NodeLeftExecutor.Task task = new NodeLeftExecutor.Task(discoveryNode, reason, () -> this.joinReasonService.onNodeRemoved(discoveryNode, reason));
                this.nodeLeftQueue.submitTask("node-left", task, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFollowerCheckRequest(FollowersChecker.FollowerCheckRequest followerCheckRequest) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensureTermAtLeast(followerCheckRequest.getSender(), followerCheckRequest.getTerm());
            if (this.getCurrentTerm() != followerCheckRequest.getTerm()) {
                logger.trace("onFollowerCheckRequest: current term is [{}], rejecting {}", (Object)this.getCurrentTerm(), (Object)followerCheckRequest);
                throw new CoordinationStateRejectedException("onFollowerCheckRequest: current term is [" + this.getCurrentTerm() + "], rejecting " + String.valueOf(followerCheckRequest), new Object[0]);
            }
            if (this.getLastAcceptedState().term() < this.getCurrentTerm()) {
                this.becomeFollower("onFollowerCheckRequest", followerCheckRequest.getSender());
            } else if (this.mode == Mode.FOLLOWER) {
                logger.trace("onFollowerCheckRequest: responding successfully to {}", (Object)followerCheckRequest);
            } else if (this.joinHelper.isJoinPending()) {
                logger.trace("onFollowerCheckRequest: rejoining master, responding successfully to {}", (Object)followerCheckRequest);
            } else {
                logger.trace("onFollowerCheckRequest: received check from faulty master, rejecting {}", (Object)followerCheckRequest);
                throw new CoordinationStateRejectedException("onFollowerCheckRequest: received check from faulty master, rejecting " + String.valueOf(followerCheckRequest), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyCommit(ApplyCommitRequest applyCommitRequest, ActionListener<Void> applyListener) {
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("handleApplyCommit: applying commit {}", (Object)applyCommitRequest);
            this.coordinationState.get().handleCommit(applyCommitRequest);
            ClusterState committedState = ClusterStateUpdaters.hideStateIfNotRecovered(this.coordinationState.get().getLastAcceptedState());
            this.applierState = this.mode == Mode.CANDIDATE ? this.clusterStateWithNoMasterBlock(committedState) : committedState;
            this.updateSingleNodeClusterChecker();
            if (applyCommitRequest.getSourceNode().equals(this.getLocalNode())) {
                applyListener.onResponse(null);
            } else {
                this.clusterApplier.onNewClusterState(applyCommitRequest.toString(), () -> this.applierState, applyListener.map(r -> {
                    this.onClusterStateApplied();
                    return r;
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClusterStateApplied() {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode != Mode.CANDIDATE) {
                this.joinHelper.onClusterStateApplied();
                this.closeElectionScheduler();
                this.peerFinder.closePeers();
            }
        }
        if (this.getLocalNode().isMasterNode()) {
            this.joinReasonService.onClusterStateApplied(this.applierState.nodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublishWithJoinResponse handlePublishRequest(PublishRequest publishRequest) {
        assert (ThreadPool.assertCurrentThreadPool("cluster_coordination"));
        assert (publishRequest.getAcceptedState().nodes().getLocalNode().equals(this.getLocalNode())) : String.valueOf(publishRequest.getAcceptedState().nodes().getLocalNode()) + " != " + String.valueOf(this.getLocalNode());
        ClusterState newClusterState = publishRequest.getAcceptedState();
        if (!newClusterState.nodes().isLocalNodeElectedMaster()) {
            newClusterState.initializeAsync(this.transportService.getThreadPool().generic());
        }
        Object object = this.mutex;
        synchronized (object) {
            DiscoveryNode sourceNode = newClusterState.nodes().getMasterNode();
            logger.trace("handlePublishRequest: handling [{}] from [{}]", (Object)publishRequest, (Object)sourceNode);
            if (sourceNode.equals(this.getLocalNode()) && this.mode != Mode.LEADER) {
                throw new CoordinationStateRejectedException("no longer leading this publication's term: " + String.valueOf(publishRequest), new Object[0]);
            }
            ClusterState localState = this.coordinationState.get().getLastAcceptedState();
            if (localState.metadata().clusterUUIDCommitted() && !localState.metadata().clusterUUID().equals(newClusterState.metadata().clusterUUID())) {
                logger.warn("received cluster state from {} with a different cluster uuid {} than local cluster uuid {}, rejecting", (Object)sourceNode, (Object)newClusterState.metadata().clusterUUID(), (Object)localState.metadata().clusterUUID());
                throw new CoordinationStateRejectedException("received cluster state from " + String.valueOf(sourceNode) + " with a different cluster uuid " + newClusterState.metadata().clusterUUID() + " than local cluster uuid " + localState.metadata().clusterUUID() + ", rejecting", new Object[0]);
            }
            if (newClusterState.term() > localState.term()) {
                this.onJoinValidators.forEach(a -> a.accept(this.getLocalNode(), newClusterState));
            }
            this.ensureTermAtLeast(sourceNode, newClusterState.term());
            PublishResponse publishResponse = this.coordinationState.get().handlePublishRequest(publishRequest);
            if (sourceNode.equals(this.getLocalNode())) {
                this.preVoteCollector.update(this.getPreVoteResponse(), this.getLocalNode());
            } else {
                this.becomeFollower("handlePublishRequest", sourceNode);
            }
            return new PublishWithJoinResponse(publishResponse, Coordinator.joinWithDestination(this.lastJoin, sourceNode, newClusterState.term()));
        }
    }

    private static Optional<Join> joinWithDestination(Optional<Join> lastJoin, DiscoveryNode leader, long term) {
        if (lastJoin.isPresent() && lastJoin.get().masterCandidateMatches(leader) && lastJoin.get().term() == term) {
            return lastJoin;
        }
        return Optional.empty();
    }

    private void closePrevotingRound() {
        if (this.prevotingRound != null) {
            this.prevotingRound.close();
            this.prevotingRound = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxTermSeen(long term) {
        Object object = this.mutex;
        synchronized (object) {
            this.maxTermSeen = Math.max(this.maxTermSeen, term);
            long currentTerm = this.getCurrentTerm();
            if (this.mode == Mode.LEADER && this.maxTermSeen > currentTerm) {
                if (this.publicationInProgress()) {
                    logger.debug("updateMaxTermSeen: maxTermSeen = {} > currentTerm = {}, enqueueing term bump", (Object)this.maxTermSeen, (Object)currentTerm);
                } else {
                    try {
                        logger.debug("updateMaxTermSeen: maxTermSeen = {} > currentTerm = {}, bumping term", (Object)this.maxTermSeen, (Object)currentTerm);
                        this.ensureTermAtLeast(this.getLocalNode(), this.maxTermSeen);
                        this.startElection();
                    }
                    catch (Exception e) {
                        logger.warn(() -> Strings.format("failed to bump term to %s", this.maxTermSeen), (Throwable)e);
                        this.becomeCandidate("updateMaxTermSeen");
                    }
                }
            }
        }
    }

    private long getTermForNewElection() {
        assert (Thread.holdsLock(this.mutex));
        return Math.max(this.getCurrentTerm(), this.maxTermSeen) + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startElection() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode == Mode.CANDIDATE) {
                ElectionStrategy.NodeEligibility nodeEligibility = Coordinator.localNodeMayWinElection(this.getLastAcceptedState(), this.electionStrategy);
                if (!nodeEligibility.mayWin()) {
                    assert (!nodeEligibility.reason().isEmpty());
                    logger.trace("skip election as local node may not win it ({}): {}", (Object)nodeEligibility.reason(), (Object)this.getLastAcceptedState().coordinationMetadata());
                    return;
                }
                long electionTerm = this.getTermForNewElection();
                logger.debug("starting election for {} in term {}", (Object)this.getLocalNode(), (Object)electionTerm);
                this.broadcastStartJoinRequest(this.getLocalNode(), electionTerm, this.getDiscoveredNodes());
            }
        }
    }

    private void broadcastStartJoinRequest(final DiscoveryNode candidateMasterNode, final long term, final List<DiscoveryNode> discoveredNodes) {
        this.electionStrategy.onNewElection(candidateMasterNode, term, new ActionListener<StartJoinRequest>(){

            @Override
            public void onResponse(StartJoinRequest startJoinRequest) {
                discoveredNodes.forEach(node -> Coordinator.this.joinHelper.sendStartJoinRequest(startJoinRequest, (DiscoveryNode)node));
            }

            @Override
            public void onFailure(Exception e) {
                logger.log(e instanceof CoordinationStateRejectedException ? Level.DEBUG : Level.WARN, org.elasticsearch.common.Strings.format("election attempt for [%s] in term [%d] failed", candidateMasterNode, term), (Throwable)e);
            }
        });
    }

    private void abdicateTo(DiscoveryNode newMaster) {
        assert (Thread.holdsLock(this.mutex));
        assert (this.mode == Mode.LEADER) : "expected to be leader on abdication but was " + String.valueOf((Object)this.mode);
        assert (newMaster.isMasterNode()) : "should only abdicate to master-eligible node but was " + String.valueOf(newMaster);
        long electionTerm = this.getTermForNewElection();
        logger.info("abdicating to {} with term {}", (Object)newMaster, (Object)electionTerm);
        this.broadcastStartJoinRequest(newMaster, electionTerm, this.getLastAcceptedState().nodes().mastersFirstStream().toList());
        assert (this.mode == Mode.LEADER) : "should still be leader after sending abdication messages " + String.valueOf((Object)this.mode);
        this.becomeCandidate("after abdicating to " + String.valueOf(newMaster));
    }

    private static ElectionStrategy.NodeEligibility localNodeMayWinElection(ClusterState lastAcceptedState, ElectionStrategy electionStrategy) {
        DiscoveryNode localNode = lastAcceptedState.nodes().getLocalNode();
        assert (localNode != null);
        return electionStrategy.nodeMayWinElection(lastAcceptedState, localNode);
    }

    private Optional<Join> ensureTermAtLeast(DiscoveryNode sourceNode, long targetTerm) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.getCurrentTerm() < targetTerm) {
            return Optional.of(this.joinLeaderInTerm(new StartJoinRequest(sourceNode, targetTerm)));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Join joinLeaderInTerm(StartJoinRequest startJoinRequest) {
        Object object = this.mutex;
        synchronized (object) {
            logger.debug("joinLeaderInTerm: for [{}] with term {}", (Object)startJoinRequest.getMasterCandidateNode(), (Object)startJoinRequest.getTerm());
            Join join = this.coordinationState.get().handleStartJoin(startJoinRequest);
            this.lastJoin = Optional.of(join);
            this.peerFinder.setCurrentTerm(this.getCurrentTerm());
            if (this.mode != Mode.CANDIDATE) {
                this.becomeCandidate("joinLeaderInTerm");
            } else {
                this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
                this.preVoteCollector.update(this.getPreVoteResponse(), null);
            }
            return join;
        }
    }

    private void handleJoinRequest(final JoinRequest joinRequest, final ActionListener<Void> joinListener) {
        assert (!Thread.holdsLock(this.mutex));
        assert (this.getLocalNode().isMasterNode()) : String.valueOf(this.getLocalNode()) + " received a join but is not master-eligible";
        logger.trace("handleJoinRequest: as {}, handling {}", (Object)this.mode, (Object)joinRequest);
        if (this.singleNodeDiscovery && !joinRequest.getSourceNode().equals(this.getLocalNode())) {
            joinListener.onFailure(new IllegalStateException("cannot join node with [" + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + "] set to [single-node] discovery"));
            return;
        }
        this.transportService.connectToNode(joinRequest.getSourceNode(), new ActionListener<Releasable>(){

            @Override
            public void onResponse(Releasable response) {
                Coordinator.this.validateJoinRequest(joinRequest, ActionListener.runBefore(joinListener, () -> Releasables.close(response)).delegateFailure((l, ignored) -> Coordinator.this.processJoinRequest(joinRequest, (ActionListener<Void>)l)));
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format("received join request from [%s] but could not connect back to the joining node", joinRequest.getSourceNode()), (Throwable)e);
                joinListener.onFailure(new NodeDisconnectedException(joinRequest.getSourceNode(), String.format(Locale.ROOT, "failure when opening connection back from [%s] to [%s]", Coordinator.this.getLocalNode().descriptionWithoutAttributes(), joinRequest.getSourceNode().descriptionWithoutAttributes()), "internal:cluster/coordination/join", e));
            }
        });
    }

    private void validateJoinRequest(JoinRequest joinRequest, ActionListener<Void> validateListener) {
        block8: {
            try (RefCountingListener listeners = new RefCountingListener(validateListener);){
                ActionListener.completeWith(listeners.acquire(), () -> {
                    ClusterState stateForJoinValidation = this.getStateForJoinValidationService();
                    if (stateForJoinValidation == null) {
                        return null;
                    }
                    assert (stateForJoinValidation.nodes().isLocalNodeElectedMaster());
                    this.onJoinValidators.forEach(a -> a.accept(joinRequest.getSourceNode(), stateForJoinValidation));
                    if (!stateForJoinValidation.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                        NodeJoinExecutor.ensureVersionBarrier(joinRequest.getSourceNode().getVersion(), stateForJoinValidation.getNodes().getMinNodeVersion());
                    }
                    this.sendJoinValidate(joinRequest.getSourceNode(), listeners.acquire());
                    return null;
                });
                if (!listeners.isFailing()) {
                    this.sendJoinPing(joinRequest.getSourceNode(), TransportRequestOptions.Type.PING, listeners.acquire());
                    this.sendJoinPing(joinRequest.getSourceNode(), TransportRequestOptions.Type.STATE, listeners.acquire());
                }
            }
            catch (Exception e) {
                logger.error("unexpected exception in validateJoinRequest", (Throwable)e);
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)e);
            }
        }
    }

    private void sendJoinValidate(DiscoveryNode discoveryNode, ActionListener<Void> listener) {
        this.joinValidationService.validateJoin(discoveryNode, listener.delegateResponse((delegate, e) -> {
            logger.warn(() -> "failed to validate incoming join request from node [" + String.valueOf(discoveryNode) + "]", (Throwable)e);
            delegate.onFailure(new IllegalStateException(String.format(Locale.ROOT, "failure when sending a join validation request from [%s] to [%s]", this.getLocalNode().descriptionWithoutAttributes(), discoveryNode.descriptionWithoutAttributes()), (Throwable)e));
        }));
    }

    private void sendJoinPing(DiscoveryNode discoveryNode, TransportRequestOptions.Type channelType, ActionListener<Void> listener) {
        this.transportService.sendRequest(discoveryNode, "internal:cluster/coordination/join/ping", (TransportRequest)new JoinHelper.JoinPingRequest(), TransportRequestOptions.of(null, channelType), TransportResponseHandler.empty(this.clusterCoordinationExecutor, listener.delegateResponse((l, e) -> {
            logger.warn(() -> Strings.format("failed to ping joining node [%s] on channel type [%s]", new Object[]{discoveryNode, channelType}), (Throwable)e);
            listener.onFailure(new IllegalStateException(String.format(Locale.ROOT, "failure when sending a join ping request from [%s] to [%s]", this.getLocalNode().descriptionWithoutAttributes(), discoveryNode.descriptionWithoutAttributes()), (Throwable)e));
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJoinRequest(JoinRequest joinRequest, ActionListener<Void> joinListener) {
        assert (Transports.assertNotTransportThread("blocking on coordinator mutex and maybe doing IO to increase term"));
        Optional<Join> optionalJoin = joinRequest.getOptionalJoin();
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.updateMaxTermSeen(joinRequest.getTerm());
                CoordinationState coordState = this.coordinationState.get();
                boolean prevElectionWon = coordState.electionWon() && optionalJoin.stream().allMatch(j -> j.term() <= this.getCurrentTerm());
                optionalJoin.ifPresent(this::handleJoin);
                this.joinAccumulator.handleJoinRequest(joinRequest.getSourceNode(), joinRequest.getCompatibilityVersions(), joinRequest.getFeatures(), joinListener);
                if (!prevElectionWon && coordState.electionWon()) {
                    this.becomeLeader();
                }
            }
        }
        catch (Exception e) {
            joinListener.onFailure(e);
        }
    }

    private void updateSingleNodeClusterChecker() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.mode == Mode.LEADER && this.applierState.nodes().size() == 1) {
            if (this.singleNodeClusterChecker == null) {
                this.singleNodeClusterChecker = this.transportService.getThreadPool().scheduleWithFixedDelay(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = Coordinator.this.mutex;
                        synchronized (object) {
                            if (Coordinator.this.mode != Mode.LEADER || Coordinator.this.applierState.nodes().size() > 1) {
                                return;
                            }
                        }
                        if (SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.exists(Coordinator.this.settings) && !SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.get(Coordinator.this.settings).isEmpty()) {
                            logger.warn("This node is a fully-formed single-node cluster with cluster UUID [{}], but it is configured as if to discover other nodes and form a multi-node cluster via the [{}={}] setting. Fully-formed clusters do not attempt to discover other nodes, and nodes with different cluster UUIDs cannot belong to the same cluster. The cluster UUID persists across restarts and can only be changed by deleting the contents of the node's data path(s). Remove the discovery configuration to suppress this message. See [{}] for more information.", (Object)Coordinator.this.applierState.metadata().clusterUUID(), (Object)SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.get(Coordinator.this.settings), (Object)ReferenceDocs.FORMING_SINGLE_NODE_CLUSTERS);
                        }
                    }

                    public String toString() {
                        return "single-node cluster checker";
                    }
                }, this.singleNodeClusterSeedHostsCheckInterval, this.clusterCoordinationExecutor);
            }
            return;
        }
        if (this.singleNodeClusterChecker != null) {
            this.singleNodeClusterChecker.cancel();
            this.singleNodeClusterChecker = null;
        }
    }

    void becomeCandidate(String method) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        logger.debug("{}: coordinator becoming CANDIDATE in term {} (was {}, lastKnownLeader was [{}])", (Object)method, (Object)this.getCurrentTerm(), (Object)this.mode, this.lastKnownLeader);
        if (this.mode != Mode.CANDIDATE) {
            Mode prevMode = this.mode;
            this.mode = Mode.CANDIDATE;
            this.cancelActivePublication("become candidate: " + method);
            this.joinAccumulator.close(this.mode);
            this.joinAccumulator = this.joinHelper.new JoinHelper.CandidateJoinAccumulator();
            this.peerFinder.activate(this.coordinationState.get().getLastAcceptedState().nodes());
            this.clusterFormationFailureHelper.start();
            this.leaderHeartbeatService.stop();
            this.leaderChecker.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
            this.leaderChecker.updateLeader(null);
            this.followersChecker.clearCurrentNodes();
            this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
            this.lagDetector.clearTrackedNodes();
            if (prevMode == Mode.LEADER) {
                this.cleanMasterService();
            }
            if (this.applierState.nodes().getMasterNodeId() != null) {
                this.applierState = this.clusterStateWithNoMasterBlock(this.applierState);
                this.clusterApplier.onNewClusterState("becoming candidate: " + method, () -> this.applierState, ActionListener.noop());
            }
        }
        this.updateSingleNodeClusterChecker();
        this.preVoteCollector.update(this.getPreVoteResponse(), null);
    }

    private void becomeLeader() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.mode == Mode.CANDIDATE) : "expected candidate but was " + String.valueOf((Object)this.mode);
        assert (this.getLocalNode().isMasterNode()) : String.valueOf(this.getLocalNode()) + " became a leader but is not master-eligible";
        final long leaderTerm = this.getCurrentTerm();
        logger.debug("handleJoinRequest: coordinator becoming LEADER in term {} (was {}, lastKnownLeader was [{}])", (Object)leaderTerm, (Object)this.mode, this.lastKnownLeader);
        this.mode = Mode.LEADER;
        this.joinAccumulator.close(this.mode);
        this.joinAccumulator = this.joinHelper.new JoinHelper.LeaderJoinAccumulator();
        this.lastKnownLeader = Optional.of(this.getLocalNode());
        this.peerFinder.deactivate(this.getLocalNode());
        this.clusterFormationFailureHelper.stop();
        this.closePrevotingRound();
        this.preVoteCollector.update(this.getPreVoteResponse(), this.getLocalNode());
        this.leaderHeartbeatService.start(this.getLocalNode(), leaderTerm, new ThreadedActionListener<Long>(this.transportService.getThreadPool().executor("cluster_coordination"), new ActionListener<Long>(){

            @Override
            public void onResponse(Long newTerm) {
                assert (newTerm != null && newTerm > leaderTerm) : newTerm + " vs " + leaderTerm;
                Coordinator.this.updateMaxTermSeen(newTerm);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> org.elasticsearch.common.Strings.format("failed to write heartbeat for term [%s]", leaderTerm), (Throwable)e);
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    if (Coordinator.this.getCurrentTerm() == leaderTerm) {
                        Coordinator.this.becomeCandidate("leaderHeartbeatService");
                    }
                }
            }

            public String toString() {
                return "term change heartbeat listener";
            }
        }));
        assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
        this.followersChecker.updateFastResponseState(leaderTerm, this.mode);
        this.updateSingleNodeClusterChecker();
    }

    void becomeFollower(String method, DiscoveryNode leaderNode) {
        boolean restartLeaderChecker;
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (leaderNode.isMasterNode()) : String.valueOf(leaderNode) + " became a leader but is not master-eligible";
        assert (this.mode != Mode.LEADER) : "do not switch to follower from leader (should be candidate first)";
        if (this.mode == Mode.FOLLOWER && Optional.of(leaderNode).equals(this.lastKnownLeader)) {
            logger.trace("{}: coordinator remaining FOLLOWER of [{}] in term {}", (Object)method, (Object)leaderNode, (Object)this.getCurrentTerm());
        } else {
            logger.debug("{}: coordinator becoming FOLLOWER of [{}] in term {} (was {}, lastKnownLeader was [{}])", (Object)method, (Object)leaderNode, (Object)this.getCurrentTerm(), (Object)this.mode, this.lastKnownLeader);
        }
        boolean bl = restartLeaderChecker = !(this.mode == Mode.FOLLOWER && Optional.of(leaderNode).equals(this.lastKnownLeader));
        if (this.mode != Mode.FOLLOWER) {
            this.mode = Mode.FOLLOWER;
            this.joinAccumulator.close(this.mode);
            this.joinAccumulator = new JoinHelper.FollowerJoinAccumulator();
            this.leaderChecker.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
            this.leaderHeartbeatService.stop();
        }
        this.updateSingleNodeClusterChecker();
        this.lastKnownLeader = Optional.of(leaderNode);
        this.peerFinder.deactivate(leaderNode);
        this.clusterFormationFailureHelper.stop();
        this.closePrevotingRound();
        this.cancelActivePublication("become follower: " + method);
        this.preVoteCollector.update(this.getPreVoteResponse(), leaderNode);
        if (restartLeaderChecker) {
            this.leaderChecker.updateLeader(leaderNode);
        }
        this.followersChecker.clearCurrentNodes();
        this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
        this.lagDetector.clearTrackedNodes();
    }

    private void cleanMasterService() {
        new LocalMasterServiceTask(Priority.NORMAL){

            @Override
            public void onFailure(Exception e) {
                logger.trace("failed to clean-up after stepping down as master", (Throwable)e);
            }

            @Override
            public void execute(ClusterState currentState) {
                if (!currentState.nodes().isLocalNodeElectedMaster()) {
                    Coordinator.this.allocationService.cleanCaches();
                }
            }

            public String toString() {
                return "cleanMasterService";
            }
        }.submit(this.masterService, "clean-up after stepping down as master");
    }

    private PreVoteResponse getPreVoteResponse() {
        return new PreVoteResponse(this.getCurrentTerm(), this.coordinationState.get().getLastAcceptedTerm(), this.coordinationState.get().getLastAcceptedState().version());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentTerm() {
        Object object = this.mutex;
        synchronized (object) {
            return this.coordinationState.get().getCurrentTerm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mode getMode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.mode;
        }
    }

    DiscoveryNode getLocalNode() {
        return this.transportService.getLocalNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean publicationInProgress() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentPublication.isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState initialState;
            CoordinationState.PersistedState persistedState = this.persistedStateSupplier.get();
            this.coordinationState.set(new CoordinationState(this.getLocalNode(), persistedState, this.electionStrategy));
            this.peerFinder.setCurrentTerm(this.getCurrentTerm());
            this.configuredHostsResolver.start();
            ClusterState lastAcceptedState = this.coordinationState.get().getLastAcceptedState();
            this.clusterBootstrapService.logBootstrapState(lastAcceptedState.metadata());
            CoordinationMetadata.VotingConfiguration votingConfiguration = lastAcceptedState.getLastCommittedConfiguration();
            if (this.singleNodeDiscovery && !votingConfiguration.isEmpty() && !votingConfiguration.hasQuorum(Collections.singleton(this.getLocalNode().getId()))) {
                throw new IllegalStateException("cannot start with [" + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + "] set to [single-node] when local node " + String.valueOf(this.getLocalNode()) + " does not have quorum in voting configuration " + String.valueOf(votingConfiguration));
            }
            Metadata.Builder metadata = Metadata.builder();
            if (lastAcceptedState.metadata().clusterUUIDCommitted()) {
                metadata.clusterUUID(lastAcceptedState.metadata().clusterUUID()).clusterUUIDCommitted(true);
            }
            this.applierState = initialState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(this.settings)).blocks(ClusterBlocks.builder().addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).addGlobalBlock(this.noMasterBlockService.getNoMasterBlock())).nodes(DiscoveryNodes.builder().add(this.getLocalNode()).localNodeId(this.getLocalNode().getId())).putCompatibilityVersions(this.getLocalNode().getId(), this.compatibilityVersions).metadata(metadata).build();
            this.clusterApplier.setInitialState(initialState);
        }
    }

    public DiscoveryStats stats() {
        return new DiscoveryStats(new PendingClusterStateStats(0, 0, 0), this.publicationHandler.stats(), this.getLocalNode().isMasterNode() ? this.masterService.getClusterStateUpdateStats() : null, this.clusterApplier.getStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInitialJoin() {
        Object object = this.mutex;
        synchronized (object) {
            this.becomeCandidate("startInitialJoin");
        }
        this.clusterBootstrapService.scheduleUnconfiguredBootstrap();
    }

    @Override
    protected void doStop() {
        this.configuredHostsResolver.stop();
        this.joinValidationService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        CoordinationState coordinationState = this.coordinationState.get();
        if (coordinationState != null) {
            Object object = this.mutex;
            synchronized (object) {
                coordinationState.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invariant() {
        Object object = this.mutex;
        synchronized (object) {
            Optional<DiscoveryNode> peerFinderLeader = this.peerFinder.getLeader();
            ClusterState lastAcceptedClusterState = this.getStateForMasterService();
            assert (this.peerFinder.getCurrentTerm() == this.getCurrentTerm());
            assert (this.followersChecker.getFastResponseState().term() == this.getCurrentTerm()) : this.followersChecker.getFastResponseState();
            assert (this.followersChecker.getFastResponseState().mode() == this.getMode()) : this.followersChecker.getFastResponseState();
            assert (this.applierState.nodes().getMasterNodeId() == null == this.applierState.blocks().hasGlobalBlockWithId(2));
            assert (this.preVoteCollector.getPreVoteResponse().equals(this.getPreVoteResponse())) : String.valueOf(this.preVoteCollector) + " vs " + String.valueOf(this.getPreVoteResponse());
            assert (!this.lagDetector.getTrackedNodes().contains(this.getLocalNode())) : this.lagDetector.getTrackedNodes();
            assert (this.followersChecker.getKnownFollowers().equals(this.lagDetector.getTrackedNodes())) : String.valueOf(this.followersChecker.getKnownFollowers()) + " vs " + String.valueOf(this.lagDetector.getTrackedNodes());
            assert (this.singleNodeClusterChecker == null || this.mode == Mode.LEADER && this.applierState.nodes().size() == 1) : "Single node checker must exist iff there is a single-node cluster";
            if (this.mode == Mode.LEADER) {
                boolean becomingMaster;
                boolean bl = becomingMaster = lastAcceptedClusterState.term() != this.getCurrentTerm();
                assert (this.coordinationState.get().electionWon());
                assert (this.lastKnownLeader.isPresent() && this.lastKnownLeader.get().equals(this.getLocalNode()));
                assert (this.joinAccumulator instanceof JoinHelper.LeaderJoinAccumulator);
                assert (peerFinderLeader.equals(this.lastKnownLeader)) : peerFinderLeader;
                assert (this.prevotingRound == null) : this.prevotingRound;
                assert (becomingMaster || lastAcceptedClusterState.nodes().getMasterNodeId() != null) : lastAcceptedClusterState;
                assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
                assert (this.getLocalNode().equals(this.applierState.nodes().getMasterNode()) || this.applierState.nodes().getMasterNodeId() == null && this.applierState.term() < this.getCurrentTerm());
                assert (this.preVoteCollector.getLeader() == this.getLocalNode()) : this.preVoteCollector;
                assert (!this.clusterFormationFailureHelper.isRunning());
                boolean activePublication = this.currentPublication.map(CoordinatorPublication::isActiveForCurrentLeader).orElse(false);
                if (becomingMaster && !activePublication) {
                    assert (this.followersChecker.getKnownFollowers().isEmpty()) : this.followersChecker.getKnownFollowers();
                } else {
                    ClusterState lastPublishedState = activePublication ? this.currentPublication.get().publishedState() : this.coordinationState.get().getLastAcceptedState();
                    HashSet lastPublishedNodes = new HashSet();
                    lastPublishedState.nodes().forEach(lastPublishedNodes::add);
                    assert (lastPublishedNodes.remove(this.getLocalNode()));
                    assert (lastPublishedNodes.equals(this.followersChecker.getKnownFollowers())) : String.valueOf(lastPublishedNodes) + " != " + String.valueOf(this.followersChecker.getKnownFollowers());
                }
                assert (becomingMaster || activePublication || this.coordinationState.get().getLastAcceptedConfiguration().equals(this.coordinationState.get().getLastCommittedConfiguration())) : String.valueOf(this.coordinationState.get().getLastAcceptedConfiguration()) + " != " + String.valueOf(this.coordinationState.get().getLastCommittedConfiguration());
            } else if (this.mode == Mode.FOLLOWER) {
                assert (!this.coordinationState.get().electionWon()) : String.valueOf(this.getLocalNode()) + " is FOLLOWER so electionWon() should be false";
                assert (this.lastKnownLeader.isPresent() && !this.lastKnownLeader.get().equals(this.getLocalNode()));
                assert (this.joinAccumulator instanceof JoinHelper.FollowerJoinAccumulator);
                assert (peerFinderLeader.equals(this.lastKnownLeader)) : peerFinderLeader;
                assert (this.prevotingRound == null) : this.prevotingRound;
                assert (lastAcceptedClusterState.nodes().getMasterNodeId() == null) : lastAcceptedClusterState;
                assert (!this.leaderChecker.currentNodeIsMaster());
                assert (this.lastKnownLeader.equals(Optional.of(this.leaderChecker.leader())));
                assert (this.followersChecker.getKnownFollowers().isEmpty());
                assert (this.lastKnownLeader.get().equals(this.applierState.nodes().getMasterNode()) || this.applierState.nodes().getMasterNodeId() == null && (this.applierState.term() < this.getCurrentTerm() || this.applierState.version() < this.getLastAcceptedState().version()));
                assert (this.currentPublication.map(Publication::isCommitted).orElse(true).booleanValue());
                assert (this.preVoteCollector.getLeader().equals(this.lastKnownLeader.get())) : this.preVoteCollector;
                assert (!this.clusterFormationFailureHelper.isRunning());
            } else {
                assert (this.mode == Mode.CANDIDATE);
                assert (this.joinAccumulator instanceof JoinHelper.CandidateJoinAccumulator);
                assert (!peerFinderLeader.isPresent()) : peerFinderLeader;
                assert (this.prevotingRound == null || this.electionScheduler != null);
                assert (lastAcceptedClusterState.nodes().getMasterNodeId() == null) : lastAcceptedClusterState;
                assert (!this.leaderChecker.currentNodeIsMaster());
                assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
                assert (this.followersChecker.getKnownFollowers().isEmpty());
                assert (this.applierState.nodes().getMasterNodeId() == null);
                assert (this.currentPublication.map(Publication::isCommitted).orElse(true).booleanValue());
                assert (this.preVoteCollector.getLeader() == null) : this.preVoteCollector;
                assert (this.clusterFormationFailureHelper.isRunning());
            }
        }
    }

    public boolean isInitialConfigurationSet() {
        return !this.getLastAcceptedState().getLastAcceptedConfiguration().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInitialConfiguration(CoordinationMetadata.VotingConfiguration votingConfiguration) {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState currentState = this.getStateForMasterService();
            if (this.isInitialConfigurationSet()) {
                logger.debug("initial configuration already set, ignoring {}", (Object)votingConfiguration);
                return false;
            }
            if (!this.getLocalNode().isMasterNode()) {
                logger.debug("skip setting initial configuration as local node is not a master-eligible node");
                throw new CoordinationStateRejectedException("this node is not master-eligible, but cluster bootstrapping can only happen on a master-eligible node", new Object[0]);
            }
            if (!votingConfiguration.getNodeIds().contains(this.getLocalNode().getId())) {
                logger.debug("skip setting initial configuration as local node is not part of initial configuration");
                throw new CoordinationStateRejectedException("local node is not part of initial configuration", new Object[0]);
            }
            ArrayList<DiscoveryNode> knownNodes = new ArrayList<DiscoveryNode>();
            knownNodes.add(this.getLocalNode());
            this.peerFinder.getFoundPeers().forEach(knownNodes::add);
            if (!votingConfiguration.hasQuorum(knownNodes.stream().map(DiscoveryNode::getId).toList())) {
                logger.debug("skip setting initial configuration as not enough nodes discovered to form a quorum in the initial configuration [knownNodes={}, {}]", knownNodes, (Object)votingConfiguration);
                throw new CoordinationStateRejectedException("not enough nodes discovered to form a quorum in the initial configuration [knownNodes=" + String.valueOf(knownNodes) + ", " + String.valueOf(votingConfiguration) + "]", new Object[0]);
            }
            logger.info("setting initial configuration to {}", (Object)votingConfiguration);
            CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).lastAcceptedConfiguration(votingConfiguration).lastCommittedConfiguration(votingConfiguration).build();
            Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
            metadataBuilder.generateClusterUuidIfNeeded();
            metadataBuilder.coordinationMetadata(coordinationMetadata);
            this.coordinationState.get().setInitialState(ClusterState.builder(currentState).metadata(metadataBuilder).build());
            ElectionStrategy.NodeEligibility nodeEligibility = Coordinator.localNodeMayWinElection(this.getLastAcceptedState(), this.electionStrategy);
            assert (nodeEligibility.mayWin()) : "initial state does not allow local node to win election, reason: " + nodeEligibility.reason() + " , metadata: " + String.valueOf(this.getLastAcceptedState().coordinationMetadata());
            this.preVoteCollector.update(this.getPreVoteResponse(), null);
            this.startElectionScheduler();
            return true;
        }
    }

    ClusterState improveConfiguration(ClusterState clusterState) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (Coordinator.validVotingConfigExclusionState(clusterState)) : clusterState;
        Stream<String> excludedNodeIds = clusterState.getVotingConfigExclusions().stream().map(CoordinationMetadata.VotingConfigExclusion::getNodeId);
        Stream<String> masterIneligibleNodeIdsInVotingConfig = clusterState.nodes().stream().filter(n -> !n.isMasterNode() && (clusterState.getLastAcceptedConfiguration().getNodeIds().contains(n.getId()) || clusterState.getLastCommittedConfiguration().getNodeIds().contains(n.getId()))).map(DiscoveryNode::getId);
        DiscoveryNode localNode = this.getLocalNode();
        Set<DiscoveryNode> liveNodes = clusterState.nodes().stream().filter(DiscoveryNode::isMasterNode).filter(n -> this.coordinationState.get().containsJoinVoteFor((DiscoveryNode)n) || n.equals(localNode)).collect(Collectors.toSet());
        CoordinationMetadata.VotingConfiguration newConfig = this.reconfigurator.reconfigure(liveNodes, Stream.concat(masterIneligibleNodeIdsInVotingConfig, excludedNodeIds).collect(Collectors.toSet()), localNode, clusterState.getLastAcceptedConfiguration());
        if (!newConfig.equals(clusterState.getLastAcceptedConfiguration())) {
            assert (this.coordinationState.get().joinVotesHaveQuorumFor(newConfig));
            return ClusterState.builder(clusterState).metadata(Metadata.builder(clusterState.metadata()).coordinationMetadata(CoordinationMetadata.builder(clusterState.coordinationMetadata()).lastAcceptedConfiguration(newConfig).build())).build();
        }
        return clusterState;
    }

    static boolean validVotingConfigExclusionState(ClusterState clusterState) {
        Set<CoordinationMetadata.VotingConfigExclusion> votingConfigExclusions = clusterState.getVotingConfigExclusions();
        Set nodeNamesWithAbsentId = votingConfigExclusions.stream().filter(e -> e.getNodeId().equals("_absent_")).map(CoordinationMetadata.VotingConfigExclusion::getNodeName).collect(Collectors.toSet());
        Set nodeIdsWithAbsentName = votingConfigExclusions.stream().filter(e -> e.getNodeName().equals("_absent_")).map(CoordinationMetadata.VotingConfigExclusion::getNodeId).collect(Collectors.toSet());
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!node.isMasterNode() || !nodeIdsWithAbsentName.contains(node.getId()) && !nodeNamesWithAbsentId.contains(node.getName())) continue;
            return false;
        }
        return true;
    }

    private void scheduleReconfigurationIfNeeded() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.mode == Mode.LEADER) : this.mode;
        assert (!this.currentPublication.isPresent()) : "Expected no publication in progress";
        ClusterState state = this.getLastAcceptedState();
        if (this.improveConfiguration(state) != state && this.reconfigurationTaskScheduled.compareAndSet(false, true)) {
            logger.trace("scheduling reconfiguration");
            this.submitUnbatchedTask("reconfigure", new ClusterStateUpdateTask(Priority.URGENT){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClusterState execute(ClusterState currentState) {
                    Coordinator.this.reconfigurationTaskScheduled.set(false);
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        return Coordinator.this.improveConfiguration(currentState);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    Coordinator.this.reconfigurationTaskScheduled.set(false);
                    logger.debug("reconfiguration failed", (Throwable)e);
                }
            });
        }
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.masterService.submitUnbatchedStateUpdateTask(source, task);
    }

    boolean missingJoinVoteFrom(DiscoveryNode node) {
        return node.isMasterNode() && !this.coordinationState.get().containsJoinVoteFor(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJoin(Join join) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensureTermAtLeast(this.getLocalNode(), join.term()).ifPresent(this::handleJoin);
            if (this.coordinationState.get().electionWon()) {
                boolean establishedAsMaster;
                boolean isNewJoinFromMasterEligibleNode = this.handleJoinIgnoringExceptions(join);
                boolean bl = establishedAsMaster = this.mode == Mode.LEADER && this.getLastAcceptedState().term() == this.getCurrentTerm();
                if (isNewJoinFromMasterEligibleNode && establishedAsMaster && !this.publicationInProgress()) {
                    this.scheduleReconfigurationIfNeeded();
                }
            } else {
                this.coordinationState.get().handleJoin(join);
            }
        }
    }

    private boolean handleJoinIgnoringExceptions(Join join) {
        try {
            return this.coordinationState.get().handleJoin(join);
        }
        catch (CoordinationStateRejectedException e) {
            logger.debug(() -> "failed to add " + String.valueOf(join) + " - ignoring", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getLastAcceptedState() {
        Object object = this.mutex;
        synchronized (object) {
            return this.coordinationState.get().getLastAcceptedState();
        }
    }

    private void getLatestStoredStateAfterWinningAnElection(ActionListener<ClusterState> listener, long joiningTerm) {
        SubscribableListener<ClusterState> latestStoredStateListener = new SubscribableListener<ClusterState>();
        this.persistedStateSupplier.get().getLatestStoredState(joiningTerm, latestStoredStateListener);
        latestStoredStateListener.addListener(listener.delegateResponse((delegate, e) -> {
            Object object = this.mutex;
            synchronized (object) {
                this.becomeCandidate("failed fetching latest stored state");
            }
            delegate.onFailure((Exception)e);
        }), this.transportService.getThreadPool().executor("cluster_coordination"), null);
    }

    @Nullable
    public ClusterState getApplierState() {
        return this.applierState;
    }

    private List<DiscoveryNode> getDiscoveredNodes() {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        nodes.add(this.getLocalNode());
        this.peerFinder.getFoundPeers().forEach(nodes::add);
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState getStateForMasterService() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState clusterState = this.coordinationState.get().getLastAcceptedState();
            assert (clusterState.nodes().getLocalNode() != null);
            if (this.mode != Mode.LEADER || clusterState.term() != this.getCurrentTerm()) {
                return this.clusterStateWithNoMasterBlock(clusterState);
            }
            return clusterState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterState getStateForJoinValidationService() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState clusterState = this.coordinationState.get().getLastAcceptedState();
            assert (clusterState.nodes().getLocalNode() != null);
            if (this.mode != Mode.LEADER || clusterState.term() != this.getCurrentTerm() || !clusterState.nodes().isLocalNodeElectedMaster()) {
                return null;
            }
            return clusterState;
        }
    }

    private ClusterState clusterStateWithNoMasterBlock(ClusterState clusterState) {
        if (clusterState.nodes().getMasterNodeId() != null) {
            assert (!clusterState.blocks().hasGlobalBlockWithId(2)) : "NO_MASTER_BLOCK should only be added by Coordinator";
            ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(clusterState.blocks()).addGlobalBlock(this.noMasterBlockService.getNoMasterBlock()).build();
            return ClusterState.builder(clusterState).blocks(clusterBlocks).nodes(clusterState.nodes().withMasterNodeId(null)).build();
        }
        return clusterState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(ClusterStatePublicationEvent clusterStatePublicationEvent, ActionListener<Void> publishListener, ClusterStatePublisher.AckListener ackListener) {
        try {
            Object object = this.mutex;
            synchronized (object) {
                PublicationTransportHandler.PublicationContext publicationContext;
                long publicationContextConstructionStartMillis;
                ClusterState clusterState;
                if (this.mode != Mode.LEADER || this.getCurrentTerm() != clusterStatePublicationEvent.getNewState().term()) {
                    logger.debug(() -> Strings.format("[%s] failed publication as node is no longer master for term %s", clusterStatePublicationEvent.getSummary(), clusterStatePublicationEvent.getNewState().term()));
                    throw new FailedToCommitClusterStateException("node is no longer master for term " + clusterStatePublicationEvent.getNewState().term() + " while handling publication", new Object[0]);
                }
                if (this.currentPublication.isPresent()) {
                    assert (false) : "[" + String.valueOf(this.currentPublication.get()) + "] in progress, cannot start new publication";
                    logger.error(() -> Strings.format("[%s] failed publication as already publication in progress", clusterStatePublicationEvent.getSummary()));
                    throw new FailedToCommitClusterStateException("publication " + String.valueOf(this.currentPublication.get()) + " already in progress", new Object[0]);
                }
                assert (this.assertPreviousStateConsistency(clusterStatePublicationEvent));
                try {
                    clusterState = clusterStatePublicationEvent.getNewState();
                    assert (this.getLocalNode().equals(clusterState.getNodes().get(this.getLocalNode().getId()))) : String.valueOf(this.getLocalNode()) + " should be in published " + String.valueOf(clusterState);
                    publicationContextConstructionStartMillis = this.transportService.getThreadPool().rawRelativeTimeInMillis();
                    publicationContext = this.publicationHandler.newPublicationContext(clusterStatePublicationEvent);
                }
                catch (Exception e) {
                    logger.debug(() -> "[" + String.valueOf(clusterStatePublicationEvent.getSummary()) + "] publishing failed during context creation", (Throwable)e);
                    this.becomeCandidate("publication context creation");
                    throw new FailedToCommitClusterStateException("publishing failed during context creation", (Throwable)e, new Object[0]);
                }
                try (Releasable ignored = publicationContext::decRef;){
                    PublishRequest publishRequest;
                    try {
                        clusterStatePublicationEvent.setPublicationContextConstructionElapsedMillis(this.transportService.getThreadPool().rawRelativeTimeInMillis() - publicationContextConstructionStartMillis);
                        publishRequest = this.coordinationState.get().handleClientValue(clusterState);
                    }
                    catch (Exception e) {
                        logger.warn("failed to start publication of state version [" + clusterState.version() + "] in term [" + clusterState.term() + "] for [" + String.valueOf(clusterStatePublicationEvent.getSummary()) + "]", (Throwable)e);
                        this.becomeCandidate("publication creation");
                        throw new FailedToCommitClusterStateException("publishing failed while starting", (Throwable)e, new Object[0]);
                    }
                    try {
                        CoordinatorPublication publication = new CoordinatorPublication(clusterStatePublicationEvent, publishRequest, publicationContext, new ListenableFuture<Void>(), ackListener, publishListener);
                        this.currentPublication = Optional.of(publication);
                        DiscoveryNodes publishNodes = publishRequest.getAcceptedState().nodes();
                        this.leaderChecker.setCurrentNodes(publishNodes);
                        this.followersChecker.setCurrentNodes(publishNodes);
                        this.lagDetector.setTrackedNodes(publishNodes);
                        publication.start(this.followersChecker.getFaultyNodes());
                    }
                    catch (Exception e) {
                        assert (false) : e;
                        if (this.currentPublication.isEmpty()) {
                            throw new IllegalStateException(e);
                        }
                        this.becomeCandidate("publication start");
                    }
                }
            }
        }
        catch (FailedToCommitClusterStateException failedToCommitClusterStateException) {
            publishListener.onFailure(failedToCommitClusterStateException);
        }
        catch (Exception e) {
            assert (false) : e;
            logger.error(() -> "[" + String.valueOf(clusterStatePublicationEvent.getSummary()) + "] publishing unexpectedly failed", (Throwable)e);
            publishListener.onFailure(new FailedToCommitClusterStateException("publishing unexpectedly failed", (Throwable)e, new Object[0]));
        }
    }

    private boolean assertPreviousStateConsistency(ClusterStatePublicationEvent clusterStatePublicationEvent) {
        assert (clusterStatePublicationEvent.getOldState() == this.coordinationState.get().getLastAcceptedState() || XContentHelper.convertToMap(JsonXContent.jsonXContent, org.elasticsearch.common.Strings.toString(clusterStatePublicationEvent.getOldState()), false).equals(XContentHelper.convertToMap(JsonXContent.jsonXContent, org.elasticsearch.common.Strings.toString(this.clusterStateWithNoMasterBlock(this.coordinationState.get().getLastAcceptedState())), false))) : org.elasticsearch.common.Strings.toString(clusterStatePublicationEvent.getOldState()) + " vs " + org.elasticsearch.common.Strings.toString(this.clusterStateWithNoMasterBlock(this.coordinationState.get().getLastAcceptedState()));
        return true;
    }

    private <T> ActionListener<T> wrapWithMutex(final ActionListener<T> listener) {
        return new ActionListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(T t) {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    listener.onResponse(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e) {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    listener.onFailure(e);
                }
            }
        };
    }

    private void cancelActivePublication(String reason) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.currentPublication.isPresent()) {
            this.currentPublication.get().cancel(reason);
        }
    }

    public Collection<BiConsumer<DiscoveryNode, ClusterState>> getOnJoinValidators() {
        return this.onJoinValidators;
    }

    boolean hasIdleJoinValidationService() {
        return this.joinValidationService.isIdle();
    }

    boolean electionSchedulerActive() {
        return this.electionScheduler != null;
    }

    public void addPeerFinderListener(PeerFinderListener peerFinderListener) {
        this.peerFinderListeners.add(peerFinderListener);
    }

    private void startElectionScheduler() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.electionScheduler == null) : this.electionScheduler;
        if (!this.getLocalNode().isMasterNode()) {
            return;
        }
        TimeValue gracePeriod = TimeValue.ZERO;
        this.electionScheduler = this.electionSchedulerFactory.startElectionScheduler(gracePeriod, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    if (Coordinator.this.mode == Mode.CANDIDATE) {
                        ClusterState lastAcceptedState = Coordinator.this.coordinationState.get().getLastAcceptedState();
                        ElectionStrategy.NodeEligibility nodeEligibility = Coordinator.localNodeMayWinElection(lastAcceptedState, Coordinator.this.electionStrategy);
                        if (!nodeEligibility.mayWin()) {
                            assert (!nodeEligibility.reason().isEmpty());
                            logger.info("skip prevoting as local node may not win election ({}): {}", (Object)nodeEligibility.reason(), (Object)lastAcceptedState.coordinationMetadata());
                            return;
                        }
                        StatusInfo statusInfo = Coordinator.this.nodeHealthService.getHealth();
                        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
                            logger.debug("skip prevoting as local node is unhealthy: [{}]", (Object)statusInfo.getInfo());
                            return;
                        }
                        if (Coordinator.this.prevotingRound != null) {
                            Coordinator.this.prevotingRound.close();
                        }
                        Coordinator.this.prevotingRound = Coordinator.this.preVoteCollector.start(lastAcceptedState, Coordinator.this.getDiscoveredNodes());
                    }
                }
            }

            public String toString() {
                return "scheduling of new prevoting round";
            }
        });
    }

    private void closeElectionScheduler() {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        final long term = this.applierState.term();
        if (this.electionScheduler != null) {
            this.clusterCoordinationExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        if (Coordinator.this.electionScheduler != null && Coordinator.this.mode != Mode.CANDIDATE && Coordinator.this.getCurrentTerm() == term) {
                            logger.debug("stabilised in term [{}], closing election scheduler", (Object)term);
                            Coordinator.this.electionScheduler.close();
                            Coordinator.this.electionScheduler = null;
                        }
                    }
                }

                public String toString() {
                    return "closeElectionScheduler in term [" + term + "]";
                }
            });
        }
    }

    public Iterable<DiscoveryNode> getFoundPeers() {
        return this.peerFinder.getFoundPeers();
    }

    public PeerFinder getPeerFinder() {
        return this.peerFinder;
    }

    private void beforeCommit(long term, long version, ActionListener<Void> listener) {
        this.electionStrategy.beforeCommit(term, version, listener);
    }

    private class CoordinatorPeerFinder
    extends PeerFinder {
        CoordinatorPeerFinder(Settings settings, TransportService transportService, TransportAddressConnector transportAddressConnector, ConfiguredHostsResolver configuredHostsResolver) {
            super(settings, transportService, transportAddressConnector, Coordinator.this.singleNodeDiscovery ? hostsResolver -> {} : configuredHostsResolver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onActiveMasterFound(DiscoveryNode masterNode, long term) {
            Object object = Coordinator.this.mutex;
            synchronized (object) {
                Coordinator.this.ensureTermAtLeast(masterNode, term);
                Coordinator.this.joinHelper.sendJoinRequest(masterNode, this.getCurrentTerm(), Coordinator.joinWithDestination(Coordinator.this.lastJoin, masterNode, term));
            }
        }

        @Override
        protected void startProbe(TransportAddress transportAddress) {
            if (!Coordinator.this.singleNodeDiscovery) {
                super.startProbe(transportAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onFoundPeersUpdated() {
            Object object = Coordinator.this.mutex;
            synchronized (object) {
                if (Coordinator.this.mode == Mode.CANDIDATE) {
                    CoordinationState.VoteCollection expectedVotes = new CoordinationState.VoteCollection();
                    this.getFoundPeers().forEach(expectedVotes::addVote);
                    expectedVotes.addVote(Coordinator.this.getLocalNode());
                    boolean foundQuorum = Coordinator.this.coordinationState.get().isElectionQuorum(expectedVotes);
                    if (foundQuorum) {
                        if (Coordinator.this.electionScheduler == null) {
                            logger.debug("starting election scheduler, expecting votes [{}]", (Object)expectedVotes);
                            Coordinator.this.startElectionScheduler();
                        }
                    } else {
                        Coordinator.this.closePrevotingRound();
                        if (Coordinator.this.electionScheduler != null) {
                            logger.debug("closing election scheduler, expecting votes [{}]", (Object)expectedVotes);
                            Coordinator.this.electionScheduler.close();
                            Coordinator.this.electionScheduler = null;
                        }
                    }
                }
            }
            Coordinator.this.peerFinderListeners.forEach(PeerFinderListener::onFoundPeersUpdated);
        }
    }

    public static enum Mode {
        CANDIDATE,
        LEADER,
        FOLLOWER;

    }

    class CoordinatorPublication
    extends Publication {
        private final ClusterStatePublicationEvent clusterStatePublicationEvent;
        private final PublishRequest publishRequest;
        private final ListenableFuture<Void> localNodeAckEvent;
        private final ClusterStatePublisher.AckListener ackListener;
        private final ActionListener<Void> publishListener;
        private final PublicationTransportHandler.PublicationContext publicationContext;
        @Nullable
        private final Scheduler.ScheduledCancellable timeoutHandler;
        private final Scheduler.Cancellable infoTimeoutHandler;
        private final List<Join> receivedJoins;
        private boolean receivedJoinsProcessed;
        private static final TransportRequestOptions COMMIT_STATE_REQUEST_OPTIONS = TransportRequestOptions.of(null, TransportRequestOptions.Type.STATE);

        CoordinatorPublication(final ClusterStatePublicationEvent clusterStatePublicationEvent, final PublishRequest publishRequest, PublicationTransportHandler.PublicationContext publicationContext, final ListenableFuture<Void> localNodeAckEvent, final ClusterStatePublisher.AckListener ackListener, ActionListener<Void> publishListener) {
            super(publishRequest, new ClusterStatePublisher.AckListener(){

                @Override
                public void onCommit(TimeValue commitTime) {
                    clusterStatePublicationEvent.setPublicationCommitElapsedMillis(commitTime.millis());
                    ackListener.onCommit(commitTime);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNodeAck(DiscoveryNode node, Exception e) {
                    if (node.equals(Coordinator.this.getLocalNode())) {
                        Object object = Coordinator.this.mutex;
                        synchronized (object) {
                            if (e == null) {
                                localNodeAckEvent.onResponse(null);
                            } else {
                                localNodeAckEvent.onFailure(e);
                            }
                        }
                    } else {
                        ackListener.onNodeAck(node, e);
                        if (e == null) {
                            Coordinator.this.lagDetector.setAppliedVersion(node, publishRequest.getAcceptedState().version());
                        }
                    }
                }
            }, Coordinator.this.transportService.getThreadPool()::rawRelativeTimeInMillis);
            this.receivedJoins = new ArrayList<Join>();
            this.clusterStatePublicationEvent = clusterStatePublicationEvent;
            this.publishRequest = publishRequest;
            this.publicationContext = publicationContext;
            this.localNodeAckEvent = localNodeAckEvent;
            this.ackListener = ackListener;
            this.publishListener = publishListener;
            this.timeoutHandler = Coordinator.this.singleNodeDiscovery ? null : Coordinator.this.transportService.getThreadPool().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        CoordinatorPublication.this.cancel("timed out after " + String.valueOf(Coordinator.this.publishTimeout));
                    }
                }

                public String toString() {
                    return "scheduled timeout for " + String.valueOf(CoordinatorPublication.this);
                }
            }, Coordinator.this.publishTimeout, Coordinator.this.clusterCoordinationExecutor);
            this.infoTimeoutHandler = Coordinator.this.transportService.getThreadPool().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        CoordinatorPublication.this.logIncompleteNodes(Level.INFO);
                    }
                }

                public String toString() {
                    return "scheduled timeout for reporting on " + String.valueOf(CoordinatorPublication.this);
                }
            }, Coordinator.this.publishInfoTimeout, Coordinator.this.clusterCoordinationExecutor);
        }

        private void removePublicationAndPossiblyBecomeCandidate(String reason) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            assert (Coordinator.this.currentPublication.get() == this);
            Coordinator.this.currentPublication = Optional.empty();
            this.logger.debug("publication ended unsuccessfully: {}", (Object)this);
            if (this.isActiveForCurrentLeader()) {
                Coordinator.this.becomeCandidate(reason);
            }
        }

        boolean isActiveForCurrentLeader() {
            return Coordinator.this.mode == Mode.LEADER && this.publishRequest.getAcceptedState().term() == Coordinator.this.getCurrentTerm();
        }

        @Override
        protected void onCompletion(final boolean committed) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            final long completionTimeMillis = Coordinator.this.transportService.getThreadPool().rawRelativeTimeInMillis();
            this.clusterStatePublicationEvent.setPublicationCompletionElapsedMillis(completionTimeMillis - this.getStartTime());
            this.localNodeAckEvent.addListener(new ActionListener<Void>(){

                @Override
                public void onResponse(Void ignore) {
                    assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
                    assert (committed);
                    CoordinatorPublication.this.receivedJoins.forEach(CoordinatorPublication.this::handleAssociatedJoin);
                    assert (!CoordinatorPublication.this.receivedJoinsProcessed);
                    CoordinatorPublication.this.receivedJoinsProcessed = true;
                    Coordinator.this.clusterApplier.onNewClusterState(CoordinatorPublication.this.toString(), () -> Coordinator.this.applierState, new ActionListener<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onFailure(Exception e) {
                            Object object = Coordinator.this.mutex;
                            synchronized (object) {
                                CoordinatorPublication.this.removePublicationAndPossiblyBecomeCandidate("clusterApplier#onNewClusterState");
                            }
                            CoordinatorPublication.this.cancelTimeoutHandlers();
                            CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), e);
                            CoordinatorPublication.this.publishListener.onFailure(e);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onResponse(Void ignored) {
                            Coordinator.this.onClusterStateApplied();
                            CoordinatorPublication.this.clusterStatePublicationEvent.setMasterApplyElapsedMillis(Coordinator.this.transportService.getThreadPool().rawRelativeTimeInMillis() - completionTimeMillis);
                            Object object = Coordinator.this.mutex;
                            synchronized (object) {
                                assert (Coordinator.this.currentPublication.get() == CoordinatorPublication.this);
                                Coordinator.this.currentPublication = Optional.empty();
                                CoordinatorPublication.this.logger.debug("publication ended successfully: {}", (Object)CoordinatorPublication.this);
                                Coordinator.this.updateMaxTermSeen(Coordinator.this.getCurrentTerm());
                                if (Coordinator.this.mode == Mode.LEADER) {
                                    List<DiscoveryNode> masterCandidates;
                                    boolean attemptReconfiguration = true;
                                    ClusterState state = Coordinator.this.getLastAcceptedState();
                                    if (!Coordinator.localNodeMayWinElection(state, Coordinator.this.electionStrategy).mayWin() && !(masterCandidates = CoordinatorPublication.this.completedNodes().stream().filter(DiscoveryNode::isMasterNode).filter(node -> Coordinator.this.electionStrategy.nodeMayWinElection(state, (DiscoveryNode)node).mayWin()).filter(node -> {
                                        long futureElectionTerm = state.term() + 1L;
                                        CoordinationState.VoteCollection futureVoteCollection = new CoordinationState.VoteCollection();
                                        CoordinatorPublication.this.completedNodes().forEach(completedNode -> futureVoteCollection.addJoinVote(new Join((DiscoveryNode)completedNode, (DiscoveryNode)node, futureElectionTerm, state.term(), state.version())));
                                        return Coordinator.this.electionStrategy.isElectionQuorum((DiscoveryNode)node, futureElectionTerm, state.term(), state.version(), state.getLastCommittedConfiguration(), state.getLastAcceptedConfiguration(), futureVoteCollection);
                                    }).toList()).isEmpty()) {
                                        Coordinator.this.abdicateTo(masterCandidates.get(Coordinator.this.random.nextInt(masterCandidates.size())));
                                        attemptReconfiguration = false;
                                    }
                                    if (attemptReconfiguration) {
                                        Coordinator.this.scheduleReconfigurationIfNeeded();
                                    }
                                }
                                Coordinator.this.lagDetector.startLagDetector(CoordinatorPublication.this.publishRequest.getAcceptedState().version());
                                CoordinatorPublication.this.logIncompleteNodes(Level.WARN);
                            }
                            CoordinatorPublication.this.cancelTimeoutHandlers();
                            CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), null);
                            CoordinatorPublication.this.publishListener.onResponse(null);
                        }
                    });
                }

                @Override
                public void onFailure(Exception e) {
                    assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
                    CoordinatorPublication.this.removePublicationAndPossiblyBecomeCandidate("Publication.onCompletion(false)");
                    CoordinatorPublication.this.cancelTimeoutHandlers();
                    FailedToCommitClusterStateException exception = new FailedToCommitClusterStateException(org.elasticsearch.common.Strings.format("publication of cluster state version [%d] in term [%d] failed [committed=%s]", CoordinatorPublication.this.publishRequest.getAcceptedState().version(), CoordinatorPublication.this.publishRequest.getAcceptedState().term(), committed), (Throwable)e, new Object[0]);
                    CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), exception);
                    CoordinatorPublication.this.publishListener.onFailure(exception);
                }
            }, EsExecutors.DIRECT_EXECUTOR_SERVICE, Coordinator.this.transportService.getThreadPool().getThreadContext());
        }

        private void cancelTimeoutHandlers() {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.cancel();
            }
            this.infoTimeoutHandler.cancel();
        }

        private void handleAssociatedJoin(Join join) {
            if (join.term() == Coordinator.this.getCurrentTerm() && Coordinator.this.missingJoinVoteFrom(join.votingNode())) {
                this.logger.trace("handling {}", (Object)join);
                Coordinator.this.handleJoin(join);
            }
        }

        @Override
        protected boolean isPublishQuorum(CoordinationState.VoteCollection votes) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            return Coordinator.this.coordinationState.get().isPublishQuorum(votes);
        }

        @Override
        protected Optional<SubscribableListener<ApplyCommitRequest>> handlePublishResponse(DiscoveryNode sourceNode, PublishResponse publishResponse) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            assert (Coordinator.this.getCurrentTerm() >= publishResponse.getTerm());
            return Coordinator.this.coordinationState.get().handlePublishResponse(sourceNode, publishResponse).map(applyCommitRequest -> {
                SubscribableListener<Object> future = new SubscribableListener<Object>();
                Coordinator.this.beforeCommit(applyCommitRequest.getTerm(), applyCommitRequest.getVersion(), future.map(ignored -> applyCommitRequest));
                future.addListener(new ActionListener<ApplyCommitRequest>(){

                    @Override
                    public void onResponse(ApplyCommitRequest applyCommitRequest) {
                    }

                    @Override
                    public void onFailure(Exception e) {
                        CoordinatorPublication.this.logger.log(e instanceof CoordinationStateRejectedException ? Level.DEBUG : Level.WARN, org.elasticsearch.common.Strings.format("publication of cluster state version [%d] in term [%d] failed to commit after reaching quorum", CoordinatorPublication.this.publishRequest.getAcceptedState().version(), CoordinatorPublication.this.publishRequest.getAcceptedState().term()), (Throwable)e);
                    }
                });
                return future;
            });
        }

        @Override
        protected void onJoin(Join join) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            if (this.receivedJoinsProcessed) {
                this.handleAssociatedJoin(join);
            } else {
                this.receivedJoins.add(join);
            }
        }

        @Override
        protected void onMissingJoin(DiscoveryNode discoveryNode) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            if (Coordinator.this.missingJoinVoteFrom(discoveryNode)) {
                long term = this.publishRequest.getAcceptedState().term();
                this.logger.debug("onMissingJoin: no join vote from {}, bumping term to exceed {}", (Object)discoveryNode, (Object)term);
                Coordinator.this.updateMaxTermSeen(term + 1L);
            }
        }

        @Override
        protected void sendPublishRequest(DiscoveryNode destination, PublishRequest publishRequest, ActionListener<PublishWithJoinResponse> responseActionListener) {
            this.publicationContext.sendPublishRequest(destination, publishRequest, Coordinator.this.wrapWithMutex(responseActionListener));
        }

        @Override
        protected void sendApplyCommit(DiscoveryNode destination, ApplyCommitRequest applyCommit, ActionListener<Void> responseActionListener) {
            assert (Coordinator.this.transportService.getThreadPool().getThreadContext().isSystemContext());
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            try {
                Coordinator.this.transportService.sendRequest(destination, Coordinator.COMMIT_STATE_ACTION_NAME, (TransportRequest)applyCommit, COMMIT_STATE_REQUEST_OPTIONS, TransportResponseHandler.empty(Coordinator.this.clusterCoordinationExecutor, Coordinator.this.wrapWithMutex(responseActionListener)));
            }
            catch (Exception e) {
                responseActionListener.onFailure(e);
            }
        }

        @Override
        protected <T> ActionListener<T> wrapListener(ActionListener<T> listener) {
            return Coordinator.this.wrapWithMutex(listener);
        }

        @Override
        boolean publicationCompletedIffAllTargetsInactiveOrCancelled() {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            return super.publicationCompletedIffAllTargetsInactiveOrCancelled();
        }
    }

    public static interface PeerFinderListener {
        public void onFoundPeersUpdated();
    }
}

