/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class SingleMetricAggregateBase
extends AggregateBase {
    private final double value;
    @Nullable
    private final String valueAsString;

    protected SingleMetricAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.value = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).value, (Object)this, "value", 0.0);
        this.valueAsString = ((AbstractBuilder)builder).valueAsString;
    }

    public final double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        JsonpUtils.serializeDoubleOrNull(generator, this.value, 0.0);
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleMetricAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::value, JsonpDeserializer.doubleOrNullDeserializer(0.0), "value");
        op.add(AbstractBuilder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Double value;
        @Nullable
        private String valueAsString;

        public final BuilderT value(double value) {
            this.value = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

