/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;

public class GetEnrichPolicyAction
extends ActionType<Response> {
    public static final GetEnrichPolicyAction INSTANCE = new GetEnrichPolicyAction();
    public static final String NAME = "cluster:admin/xpack/enrich/get";

    private GetEnrichPolicyAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<EnrichPolicy.NamedPolicy> policies;

        public Response(Map<String, EnrichPolicy> policies) {
            Objects.requireNonNull(policies, "policies cannot be null");
            this.policies = new TreeMap<String, EnrichPolicy>(policies).entrySet().stream().map(entry -> new EnrichPolicy.NamedPolicy((String)entry.getKey(), (EnrichPolicy)entry.getValue())).collect(Collectors.toList());
        }

        public Response(StreamInput in) throws IOException {
            this.policies = in.readCollectionAsList(EnrichPolicy.NamedPolicy::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.policies);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("policies");
            for (EnrichPolicy.NamedPolicy policy : this.policies) {
                builder.startObject();
                builder.startObject("config");
                policy.toXContent(builder, params);
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public List<EnrichPolicy.NamedPolicy> getPolicies() {
            return this.policies;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.policies.equals(response.policies);
        }

        public int hashCode() {
            return Objects.hash(this.policies);
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final List<String> names;

        public Request(TimeValue masterNodeTimeout, String ... names) {
            super(masterNodeTimeout);
            this.names = List.of(names);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringCollectionAsImmutableList();
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public List<String> getNames() {
            return this.names;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.names);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.names, request.names);
        }

        public int hashCode() {
            return Objects.hash(this.names);
        }
    }
}

