/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.HashSet;
import java.util.List;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureResponse;

public class TransportXPackInfoAction
extends HandledTransportAction<XPackInfoRequest, XPackInfoResponse> {
    private final LicenseService licenseService;
    private final NodeClient client;
    private final List<ActionType<XPackInfoFeatureResponse>> infoActions;

    @Inject
    public TransportXPackInfoAction(TransportService transportService, ActionFilters actionFilters, LicenseService licenseService, NodeClient client) {
        super("cluster:monitor/xpack/info", transportService, actionFilters, XPackInfoRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseService = licenseService;
        this.client = client;
        this.infoActions = this.infoActions();
    }

    protected List<ActionType<XPackInfoFeatureResponse>> infoActions() {
        return XPackInfoFeatureAction.ALL;
    }

    @Override
    protected void doExecute(Task task, XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        License license;
        XPackInfoResponse.BuildInfo buildInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.BUILD)) {
            buildInfo = new XPackInfoResponse.BuildInfo(Build.current().hash(), Build.current().date());
        }
        XPackInfoResponse.LicenseInfo licenseInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.LICENSE) && (license = this.licenseService.getLicense()) != null) {
            licenseInfo = new XPackInfoResponse.LicenseInfo(license.uid(), license.type(), license.operationMode().description(), LicenseUtils.status(license), LicenseUtils.getExpiryDate(license));
        }
        XPackInfoResponse.FeatureSetsInfo featureSetsInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.FEATURES)) {
            HashSet<XPackInfoResponse.FeatureSetsInfo.FeatureSet> featureSets = new HashSet<XPackInfoResponse.FeatureSetsInfo.FeatureSet>();
            for (ActionType<XPackInfoFeatureResponse> infoAction : this.infoActions) {
                this.client.executeLocally(infoAction, request, listener.delegateFailureAndWrap((l, response) -> featureSets.add(response.getInfo())));
            }
            featureSetsInfo = new XPackInfoResponse.FeatureSetsInfo(featureSets);
        }
        listener.onResponse(new XPackInfoResponse(buildInfo, licenseInfo, featureSetsInfo));
    }
}

