/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiPointValues;

public class MultiGeoPointValues
extends MultiPointValues<GeoPoint> {
    private final GeoPoint point = new GeoPoint();

    public MultiGeoPointValues(SortedNumericDocValues numericValues) {
        super(numericValues);
    }

    @Override
    public GeoPoint nextValue() throws IOException {
        return this.point.resetFromEncoded(this.numericValues.nextValue());
    }

    protected GeoPointValues getPointValues() {
        NumericDocValues singleton = DocValues.unwrapSingleton(this.numericValues);
        return singleton != null ? new GeoPointValues(singleton) : null;
    }
}

