/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.jackson.JacksonJsonpGenerator;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpParser;
import co.elastic.clients.json.jackson.JacksonUtils;
import com.fasterxml.jackson.core.JsonFactory;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class JacksonJsonProvider
extends JsonProvider {
    private final JacksonJsonpMapper mapper;
    private final JsonFactory jsonFactory;
    private final ParserFactory defaultParserFactory = new ParserFactory(null);
    private final JsonGeneratorFactory defaultGeneratorFactory = new GeneratorFactory(null);

    public JacksonJsonProvider(JacksonJsonpMapper mapper) {
        this.mapper = mapper;
        this.jsonFactory = mapper.objectMapper().getFactory();
    }

    public JacksonJsonProvider() {
        this(new JacksonJsonpMapper());
    }

    public JacksonJsonpMapper mapper() {
        return this.mapper;
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return this.defaultParserFactory;
        }
        return this.defaultParserFactory;
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return this.defaultParserFactory.createParser(reader);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return this.defaultParserFactory.createParser(in);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return this.defaultGeneratorFactory;
        }
        return this.defaultGeneratorFactory;
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return this.defaultGeneratorFactory.createGenerator(writer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return this.defaultGeneratorFactory.createGenerator(out);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonReader createReader(InputStream in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    private class ParserFactory
    implements JsonParserFactory {
        private final Map<String, ?> config;

        ParserFactory(Map<String, ?> config) {
            this.config = config == null ? Collections.emptyMap() : config;
        }

        @Override
        public JsonParser createParser(Reader reader) {
            try {
                return new JacksonJsonpParser(JacksonJsonProvider.this.jsonFactory.createParser(reader), JacksonJsonProvider.this.mapper);
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        @Override
        public JsonParser createParser(InputStream in) {
            try {
                return new JacksonJsonpParser(JacksonJsonProvider.this.jsonFactory.createParser(in), JacksonJsonProvider.this.mapper);
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        @Override
        public JsonParser createParser(InputStream in, Charset charset) {
            try {
                return new JacksonJsonpParser(JacksonJsonProvider.this.jsonFactory.createParser((Reader)new InputStreamReader(in, charset)), JacksonJsonProvider.this.mapper);
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        @Override
        public JsonParser createParser(JsonObject obj) {
            return JsonpUtils.provider().createParserFactory(null).createParser(obj);
        }

        @Override
        public JsonParser createParser(JsonArray array) {
            return JsonpUtils.provider().createParserFactory(null).createParser(array);
        }

        @Override
        public Map<String, ?> getConfigInUse() {
            return this.config;
        }
    }

    private class GeneratorFactory
    implements JsonGeneratorFactory {
        private final Map<String, ?> config;

        GeneratorFactory(Map<String, ?> config) {
            this.config = config == null ? Collections.emptyMap() : config;
        }

        @Override
        public JsonGenerator createGenerator(Writer writer) {
            try {
                return new JacksonJsonpGenerator(JacksonJsonProvider.this.jsonFactory.createGenerator(writer));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        @Override
        public JsonGenerator createGenerator(OutputStream out) {
            try {
                return new JacksonJsonpGenerator(JacksonJsonProvider.this.jsonFactory.createGenerator(out));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        @Override
        public JsonGenerator createGenerator(OutputStream out, Charset charset) {
            try {
                return new JacksonJsonpGenerator(JacksonJsonProvider.this.jsonFactory.createGenerator((Writer)new OutputStreamWriter(out, charset)));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        @Override
        public Map<String, ?> getConfigInUse() {
            return this.config;
        }
    }
}

