"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSLOStatsOverview = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _queries = require("../utils/queries");
var _slo_settings = require("./slo_settings");
var _transform_generators = require("./transform_generators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetSLOStatsOverview {
  constructor(soClient, esClient, spaceId, logger, rulesClient, racClient) {
    this.soClient = soClient;
    this.esClient = esClient;
    this.spaceId = spaceId;
    this.logger = logger;
    this.rulesClient = rulesClient;
    this.racClient = racClient;
  }
  async execute(params) {
    var _params$kqlQuery, _params$filters, _parsedFilters$filter, _parsedFilters$must_n, _aggs$not_stale$viola, _aggs$not_stale, _aggs$not_stale$degra, _aggs$not_stale2, _aggs$not_stale$healt, _aggs$not_stale3, _aggs$not_stale3$heal, _aggs$not_stale$noDat, _aggs$not_stale4, _aggs$stale$doc_count;
    const settings = await (0, _slo_settings.getSloSettings)(this.soClient);
    const {
      indices
    } = await (0, _slo_settings.getSummaryIndices)(this.esClient, settings);
    const kqlQuery = (_params$kqlQuery = params.kqlQuery) !== null && _params$kqlQuery !== void 0 ? _params$kqlQuery : '';
    const filters = (_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : '';
    const parsedFilters = (0, _transform_generators.parseStringFilters)(filters, this.logger);
    const response = await (0, _queries.typedSearch)(this.esClient, {
      index: indices,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              spaceId: this.spaceId
            }
          }, (0, _transform_generators.getElasticsearchQueryOrThrow)(kqlQuery), ...((_parsedFilters$filter = parsedFilters.filter) !== null && _parsedFilters$filter !== void 0 ? _parsedFilters$filter : [])],
          must_not: [...((_parsedFilters$must_n = parsedFilters.must_not) !== null && _parsedFilters$must_n !== void 0 ? _parsedFilters$must_n : [])]
        }
      },
      body: {
        aggs: {
          stale: {
            filter: {
              range: {
                summaryUpdatedAt: {
                  lt: `now-${settings.staleThresholdInHours}h`
                }
              }
            }
          },
          not_stale: {
            filter: {
              range: {
                summaryUpdatedAt: {
                  gte: `now-${settings.staleThresholdInHours}h`
                }
              }
            },
            aggs: {
              violated: {
                filter: {
                  term: {
                    status: 'VIOLATED'
                  }
                }
              },
              healthy: {
                filter: {
                  term: {
                    status: 'HEALTHY'
                  }
                }
              },
              degrading: {
                filter: {
                  term: {
                    status: 'DEGRADING'
                  }
                }
              },
              noData: {
                filter: {
                  term: {
                    status: 'NO_DATA'
                  }
                }
              }
            }
          }
        }
      }
    });
    const [rules, alerts] = await Promise.all([this.rulesClient.find({
      options: {
        ruleTypeIds: _ruleDataUtils.SLO_RULE_TYPE_IDS,
        consumers: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.OBSERVABILITY]
      }
    }), this.racClient.getAlertSummary({
      ruleTypeIds: _ruleDataUtils.SLO_RULE_TYPE_IDS,
      consumers: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
      gte: (0, _moment.default)().subtract(24, 'hours').toISOString(),
      lte: (0, _moment.default)().toISOString()
    })]);
    const aggs = response.aggregations;
    return {
      violated: (_aggs$not_stale$viola = aggs === null || aggs === void 0 ? void 0 : (_aggs$not_stale = aggs.not_stale) === null || _aggs$not_stale === void 0 ? void 0 : _aggs$not_stale.violated.doc_count) !== null && _aggs$not_stale$viola !== void 0 ? _aggs$not_stale$viola : 0,
      degrading: (_aggs$not_stale$degra = aggs === null || aggs === void 0 ? void 0 : (_aggs$not_stale2 = aggs.not_stale) === null || _aggs$not_stale2 === void 0 ? void 0 : _aggs$not_stale2.degrading.doc_count) !== null && _aggs$not_stale$degra !== void 0 ? _aggs$not_stale$degra : 0,
      healthy: (_aggs$not_stale$healt = aggs === null || aggs === void 0 ? void 0 : (_aggs$not_stale3 = aggs.not_stale) === null || _aggs$not_stale3 === void 0 ? void 0 : (_aggs$not_stale3$heal = _aggs$not_stale3.healthy) === null || _aggs$not_stale3$heal === void 0 ? void 0 : _aggs$not_stale3$heal.doc_count) !== null && _aggs$not_stale$healt !== void 0 ? _aggs$not_stale$healt : 0,
      noData: (_aggs$not_stale$noDat = aggs === null || aggs === void 0 ? void 0 : (_aggs$not_stale4 = aggs.not_stale) === null || _aggs$not_stale4 === void 0 ? void 0 : _aggs$not_stale4.noData.doc_count) !== null && _aggs$not_stale$noDat !== void 0 ? _aggs$not_stale$noDat : 0,
      stale: (_aggs$stale$doc_count = aggs === null || aggs === void 0 ? void 0 : aggs.stale.doc_count) !== null && _aggs$stale$doc_count !== void 0 ? _aggs$stale$doc_count : 0,
      burnRateRules: rules.total,
      burnRateActiveAlerts: alerts.activeAlertCount,
      burnRateRecoveredAlerts: alerts.recoveredAlertCount
    };
  }
}
exports.GetSLOStatsOverview = GetSLOStatsOverview;