"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBurnRates = getBurnRates;
var _burn_rates_client = require("./burn_rates_client");
var _slo_definition_client = require("./slo_definition_client");
var _slo_repository = require("./slo_repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getBurnRates({
  sloId,
  spaceId,
  windows,
  instanceId,
  remoteName,
  services
}) {
  const {
    soClient,
    esClient,
    logger
  } = services;
  const repository = new _slo_repository.KibanaSavedObjectsSLORepository(soClient, logger);
  const burnRatesClient = new _burn_rates_client.DefaultBurnRatesClient(esClient);
  const definitionClient = new _slo_definition_client.SloDefinitionClient(repository, esClient, logger);
  const {
    slo
  } = await definitionClient.execute(sloId, spaceId, remoteName);
  const burnRates = await burnRatesClient.calculate(slo, instanceId, windows, remoteName);
  return {
    burnRates
  };
}