"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSloInstancesRoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSloInstancesRoute = exports.deleteSloInstancesRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/_delete_instances 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.deleteSLOInstancesParamsSchema,
  handler: async ({
    request,
    logger,
    response,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient
    } = await getScopedClients({
      request,
      logger
    });
    const deleteSloInstances = new _services.DeleteSLOInstances(scopedClusterClient.asCurrentUser);
    await deleteSloInstances.execute(params.body);
    return response.noContent();
  }
});