"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloList = useFetchSloList;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _constants = require("../../common/constants");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _use_create_data_view = require("./use_create_data_view");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloList({
  kqlQuery = '',
  page = 1,
  sortBy = 'status',
  sortDirection = 'desc',
  perPage = _constants.DEFAULT_SLO_PAGE_SIZE,
  filters: filterDSL = [],
  lastRefresh,
  tagsFilter,
  statusFilter,
  disabled = false
} = {}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: _constants.SUMMARY_DESTINATION_INDEX_PATTERN
  });
  const filters = (0, _react.useMemo)(() => {
    try {
      return JSON.stringify((0, _esQuery.buildQueryFromFilters)([...filterDSL, ...(statusFilter ? [statusFilter] : []), ...(tagsFilter ? [tagsFilter] : [])], dataView, {
        ignoreFilterIfFieldNotInIndex: true
      }));
    } catch (e) {
      return '';
    }
  }, [filterDSL, dataView, tagsFilter, statusFilter]);
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.list({
      kqlQuery,
      page,
      perPage,
      sortBy,
      sortDirection,
      filters,
      lastRefresh
    }),
    queryFn: async ({
      signal
    }) => {
      return await sloClient.fetch('GET /api/observability/slos 2023-10-31', {
        params: {
          query: {
            ...(kqlQuery && {
              kqlQuery
            }),
            ...(sortBy && {
              sortBy
            }),
            ...(sortDirection && {
              sortDirection
            }),
            ...(page !== undefined && {
              page: String(page)
            }),
            ...(perPage !== undefined && {
              perPage: String(perPage)
            }),
            ...(filters && {
              filters
            }),
            hideStale: true
          }
        },
        signal
      });
    },
    enabled: !disabled,
    cacheTime: 0,
    refetchOnWindowFocus: false,
    retry: (failureCount, error) => {
      if (String(error) === 'Error: Forbidden') {
        return false;
      }
      return failureCount < 4;
    },
    onSuccess: ({
      results
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.historicalSummaries(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.activeAlerts(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.rules(),
        exact: false
      });
    },
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.slo.list.errorNotification', {
          defaultMessage: 'Something went wrong while fetching SLOs'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}