"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindListsResponse = exports.FindListsRequestQuery = exports.FindListsFilter = exports.FindListsCursor = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _list_schemas = require("../model/list_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find lists API endpoint
 *   version: 2023-10-31
 */

const FindListsCursor = exports.FindListsCursor = _primitives.NonEmptyString;
const FindListsFilter = exports.FindListsFilter = _zod.z.string();
const FindListsRequestQuery = exports.FindListsRequestQuery = _zod.z.object({
  /**
   * The page number to return
   */
  page: _zod.z.coerce.number().int().optional(),
  /**
   * The number of lists to return per page
   */
  per_page: _zod.z.coerce.number().int().optional(),
  /**
   * Determines which field is used to sort the results
   */
  sort_field: _primitives.NonEmptyString.optional(),
  /**
   * Determines the sort order, which can be `desc` or `asc`
   */
  sort_order: _zod.z.enum(['desc', 'asc']).optional(),
  /** 
      * Returns the list that come after the last list returned in the previous call
  (use the cursor value returned in the previous call). This parameter uses
  the `tie_breaker_id` field to ensure all lists are sorted and returned correctly.
        */
  cursor: FindListsCursor.optional(),
  /** 
      * Filters the returned results according to the value of the specified field,
  using the <field name>:<field value> syntax.
        */
  filter: FindListsFilter.optional()
});
const FindListsResponse = exports.FindListsResponse = _zod.z.object({
  data: _zod.z.array(_list_schemas.List),
  page: _zod.z.number().int().min(0),
  per_page: _zod.z.number().int().min(0),
  total: _zod.z.number().int().min(0),
  cursor: FindListsCursor
});