"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductFeaturesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _product_features = require("@kbn/security-solution-features/product_features");
var _actions = require("@kbn/security-solution-features/actions");
var _common = require("../../../common");
var _product_features2 = require("./product_features");
var _security_saved_objects = require("./security_saved_objects");
var _cases_privileges = require("./cases_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductFeaturesService {
  constructor(logger, experimentalFeatures) {
    (0, _defineProperty2.default)(this, "securityProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "securityV2ProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "casesProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "casesProductV2Features", void 0);
    (0, _defineProperty2.default)(this, "casesProductFeaturesV3", void 0);
    (0, _defineProperty2.default)(this, "securityAssistantProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "attackDiscoveryProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "timelineProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "notesProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "siemMigrationsProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "productFeatures", void 0);
    (0, _defineProperty2.default)(this, "getApiActionName", apiPrivilege => `api:${_actions.API_ACTION_PREFIX}${apiPrivilege}`);
    this.logger = logger;
    this.experimentalFeatures = experimentalFeatures;
    const securityFeature = (0, _product_features.getSecurityFeature)({
      savedObjects: _security_saved_objects.securityV1SavedObjects,
      experimentalFeatures: this.experimentalFeatures
    });
    this.securityProductFeatures = new _product_features2.ProductFeatures(this.logger, securityFeature.subFeaturesMap, securityFeature.baseKibanaFeature, securityFeature.baseKibanaSubFeatureIds);
    const securityV2Feature = (0, _product_features.getSecurityV2Feature)({
      savedObjects: _security_saved_objects.securityDefaultSavedObjects,
      experimentalFeatures: this.experimentalFeatures
    });
    this.securityV2ProductFeatures = new _product_features2.ProductFeatures(this.logger, securityV2Feature.subFeaturesMap, securityV2Feature.baseKibanaFeature, securityV2Feature.baseKibanaSubFeatureIds);
    const casesFeature = (0, _product_features.getCasesFeature)({
      uiCapabilities: _cases_privileges.casesUiCapabilities,
      apiTags: _cases_privileges.casesApiTags,
      savedObjects: {
        files: _saved_objects.hiddenTypes
      }
    });
    this.casesProductFeatures = new _product_features2.ProductFeatures(this.logger, casesFeature.subFeaturesMap, casesFeature.baseKibanaFeature, casesFeature.baseKibanaSubFeatureIds);
    const casesV2Feature = (0, _product_features.getCasesV2Feature)({
      uiCapabilities: _cases_privileges.casesUiCapabilities,
      apiTags: _cases_privileges.casesApiTags,
      savedObjects: {
        files: _saved_objects.hiddenTypes
      }
    });
    this.casesProductV2Features = new _product_features2.ProductFeatures(this.logger, casesV2Feature.subFeaturesMap, casesV2Feature.baseKibanaFeature, casesV2Feature.baseKibanaSubFeatureIds);
    const casesV3Feature = (0, _product_features.getCasesV3Feature)({
      uiCapabilities: _cases_privileges.casesUiCapabilities,
      apiTags: _cases_privileges.casesApiTags,
      savedObjects: {
        files: _saved_objects.hiddenTypes
      }
    });
    this.casesProductFeaturesV3 = new _product_features2.ProductFeatures(this.logger, casesV3Feature.subFeaturesMap, casesV3Feature.baseKibanaFeature, casesV3Feature.baseKibanaSubFeatureIds);
    const assistantFeature = (0, _product_features.getAssistantFeature)(this.experimentalFeatures);
    this.securityAssistantProductFeatures = new _product_features2.ProductFeatures(this.logger, assistantFeature.subFeaturesMap, assistantFeature.baseKibanaFeature, assistantFeature.baseKibanaSubFeatureIds);
    const attackDiscoveryFeature = (0, _product_features.getAttackDiscoveryFeature)();
    this.attackDiscoveryProductFeatures = new _product_features2.ProductFeatures(this.logger, attackDiscoveryFeature.subFeaturesMap, attackDiscoveryFeature.baseKibanaFeature, attackDiscoveryFeature.baseKibanaSubFeatureIds);
    const timelineFeature = (0, _product_features.getTimelineFeature)({
      savedObjects: _security_saved_objects.securityTimelineSavedObjects,
      experimentalFeatures: {}
    });
    this.timelineProductFeatures = new _product_features2.ProductFeatures(this.logger, timelineFeature.subFeaturesMap, timelineFeature.baseKibanaFeature, timelineFeature.baseKibanaSubFeatureIds);
    const notesFeature = (0, _product_features.getNotesFeature)({
      savedObjects: _security_saved_objects.securityNotesSavedObjects,
      experimentalFeatures: {}
    });
    this.notesProductFeatures = new _product_features2.ProductFeatures(this.logger, notesFeature.subFeaturesMap, notesFeature.baseKibanaFeature, notesFeature.baseKibanaSubFeatureIds);
    const siemMigrationsFeature = (0, _product_features.getSiemMigrationsFeature)();
    this.siemMigrationsProductFeatures = new _product_features2.ProductFeatures(this.logger, siemMigrationsFeature.subFeaturesMap, siemMigrationsFeature.baseKibanaFeature, siemMigrationsFeature.baseKibanaSubFeatureIds);
  }
  init(featuresSetup) {
    this.securityProductFeatures.init(featuresSetup);
    this.securityV2ProductFeatures.init(featuresSetup);
    this.casesProductFeatures.init(featuresSetup);
    this.casesProductV2Features.init(featuresSetup);
    this.casesProductFeaturesV3.init(featuresSetup);
    this.securityAssistantProductFeatures.init(featuresSetup);
    this.attackDiscoveryProductFeatures.init(featuresSetup);
    this.timelineProductFeatures.init(featuresSetup);
    this.notesProductFeatures.init(featuresSetup);
    this.siemMigrationsProductFeatures.init(featuresSetup);
  }
  setProductFeaturesConfigurator(configurator) {
    const securityProductFeaturesConfig = configurator.security();
    this.securityProductFeatures.setConfig(securityProductFeaturesConfig);
    this.securityV2ProductFeatures.setConfig(securityProductFeaturesConfig);
    const casesProductFeaturesConfig = configurator.cases();
    this.casesProductFeatures.setConfig(casesProductFeaturesConfig);
    this.casesProductV2Features.setConfig(casesProductFeaturesConfig);
    this.casesProductFeaturesV3.setConfig(casesProductFeaturesConfig);
    const securityAssistantProductFeaturesConfig = configurator.securityAssistant();
    this.securityAssistantProductFeatures.setConfig(securityAssistantProductFeaturesConfig);
    const attackDiscoveryProductFeaturesConfig = configurator.attackDiscovery();
    this.attackDiscoveryProductFeatures.setConfig(attackDiscoveryProductFeaturesConfig);
    const timelineProductFeaturesConfig = configurator.timeline();
    this.timelineProductFeatures.setConfig(timelineProductFeaturesConfig);
    const notesProductFeaturesConfig = configurator.notes();
    this.notesProductFeatures.setConfig(notesProductFeaturesConfig);
    let siemMigrationsProductFeaturesConfig = new Map();
    if (!this.experimentalFeatures.siemMigrationsDisabled) {
      siemMigrationsProductFeaturesConfig = configurator.siemMigrations();
      this.siemMigrationsProductFeatures.setConfig(siemMigrationsProductFeaturesConfig);
    }
    this.productFeatures = new Set(Object.freeze([...securityProductFeaturesConfig.keys(), ...casesProductFeaturesConfig.keys(), ...securityAssistantProductFeaturesConfig.keys(), ...attackDiscoveryProductFeaturesConfig.keys(), ...timelineProductFeaturesConfig.keys(), ...notesProductFeaturesConfig.keys(), ...siemMigrationsProductFeaturesConfig.keys()]));
  }
  isEnabled(productFeatureKey) {
    if (!this.productFeatures) {
      throw new Error('ProductFeatures has not yet been configured');
    }
    return this.productFeatures.has(productFeatureKey);
  }
  isActionRegistered(action) {
    return this.securityProductFeatures.isActionRegistered(action) || this.securityV2ProductFeatures.isActionRegistered(action) || this.casesProductFeatures.isActionRegistered(action) || this.casesProductV2Features.isActionRegistered(action) || this.securityAssistantProductFeatures.isActionRegistered(action) || this.attackDiscoveryProductFeatures.isActionRegistered(action) || this.timelineProductFeatures.isActionRegistered(action) || this.notesProductFeatures.isActionRegistered(action) || this.siemMigrationsProductFeatures.isActionRegistered(action);
  }
  /** @deprecated Use security.authz.requiredPrivileges instead */
  isApiPrivilegeEnabled(apiPrivilege) {
    return this.isActionRegistered(this.getApiActionName(apiPrivilege));
  }
  registerApiAccessControl(http) {
    // The `securitySolutionProductFeature:` prefix is used for ProductFeature based control.
    // Should be used only by routes that do not need RBAC, only direct productFeature control.
    const APP_FEATURE_TAG_PREFIX = 'securitySolutionProductFeature:';

    /** @deprecated Use security.authz.requiredPrivileges instead */
    const API_ACTION_TAG_PREFIX = `access:${_common.APP_ID}-`;
    const isAuthzEnabled = authz => {
      return Boolean(authz === null || authz === void 0 ? void 0 : authz.requiredPrivileges);
    };

    /** Returns true only if the API privilege is a security action and is disabled */
    const isApiPrivilegeSecurityAndDisabled = apiPrivilege => {
      if (apiPrivilege.startsWith(_actions.API_ACTION_PREFIX)) {
        return !this.isActionRegistered(`api:${apiPrivilege}`);
      }
      return false;
    };
    http.registerOnPostAuth((request, response, toolkit) => {
      var _request$route$option2;
      for (const tag of (_request$route$option = request.route.options.tags) !== null && _request$route$option !== void 0 ? _request$route$option : []) {
        var _request$route$option;
        let isEnabled = true;
        if (tag.startsWith(APP_FEATURE_TAG_PREFIX)) {
          isEnabled = this.isEnabled(tag.substring(APP_FEATURE_TAG_PREFIX.length));
        } else if (tag.startsWith(API_ACTION_TAG_PREFIX)) {
          isEnabled = this.isApiPrivilegeEnabled(tag.substring(API_ACTION_TAG_PREFIX.length));
        }
        if (!isEnabled) {
          this.logger.warn(`Accessing disabled route "${request.url.pathname}${request.url.search}": responding with 404`);
          return response.notFound();
        }
      }

      // This control ensures the action privileges have been registered by the productFeature service,
      // preventing full access (`*`) roles, such as superuser, from bypassing productFeature controls.
      const authz = (_request$route$option2 = request.route.options.security) === null || _request$route$option2 === void 0 ? void 0 : _request$route$option2.authz;
      if (isAuthzEnabled(authz)) {
        const disabled = authz.requiredPrivileges.some(privilegeEntry => {
          if (typeof privilegeEntry === 'object') {
            if (privilegeEntry.allRequired) {
              if (privilegeEntry.allRequired.some(entry => typeof entry === 'string' ? isApiPrivilegeSecurityAndDisabled(entry) : entry.anyOf.every(isApiPrivilegeSecurityAndDisabled))) {
                return true;
              }
            }
            if (privilegeEntry.anyRequired) {
              if (privilegeEntry.anyRequired.every(entry => typeof entry === 'string' ? isApiPrivilegeSecurityAndDisabled(entry) : entry.allOf.some(isApiPrivilegeSecurityAndDisabled))) {
                return true;
              }
            }
            return false;
          } else {
            return isApiPrivilegeSecurityAndDisabled(privilegeEntry);
          }
        });
        if (disabled) {
          this.logger.warn(`Accessing disabled route "${request.url.pathname}${request.url.search}": responding with 404`);
          return response.notFound();
        }
      }
      return toolkit.next();
    });
  }
}
exports.ProductFeaturesService = ProductFeaturesService;