"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsqlSearchRequest = void 0;
var _build_events_query = require("../utils/build_events_query");
var _get_query_filter = require("../utils/get_query_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildEsqlSearchRequest = ({
  query,
  from,
  to,
  filters,
  primaryTimestamp,
  secondaryTimestamp,
  exceptionFilter,
  size,
  excludedDocumentIds,
  ruleExecutionTimeout
}) => {
  const esFilter = (0, _get_query_filter.getQueryFilter)({
    query: '',
    language: 'esql',
    filters: filters || [],
    index: undefined,
    exceptionFilter
  });
  const rangeFilter = (0, _build_events_query.buildTimeRangeFilter)({
    to,
    from,
    primaryTimestamp,
    secondaryTimestamp
  });
  const requestFilter = [rangeFilter, esFilter];
  return {
    query: `${query} | limit ${size}`,
    filter: {
      bool: {
        filter: requestFilter,
        ...(excludedDocumentIds.length > 0 ? {
          must_not: {
            ids: {
              values: excludedDocumentIds
            }
          }
        } : {})
      }
    },
    wait_for_completion_timeout: '4m',
    // hard limit request timeout is 5m set by ES proxy and alerting framework. So, we should be fine to wait 4m for async query completion. If rule execution is shorter than 4m and query was not completed, it will be aborted.
    ...(ruleExecutionTimeout ? {
      keep_alive: ruleExecutionTimeout
    } : {})
  };
};
exports.buildEsqlSearchRequest = buildEsqlSearchRequest;